{ sLongDate Parser Demo by George Tylutki, Borland Pascal 7.0 }

PROGRAM LDDemo;

USES WinTypes, WinProcs, OWindows, WinDos, Strings;

CONST
MaxSepLen = 6;

type
tChar9 = array[0..9] of char;
tChar8 = array[0..8] of char;
tChar6 = array[0..MaxSepLen] of char;
tChar4 = array[0..4] of char;

CONST
LongDayNameArray : array[0..6] of tChar9 = ('Sunday', 'Monday',
  'Tuesday', 'Wednesday','Thursday', 'Friday', 'Saturday');
LongMonthNameArray : array[1..12] of tChar9 = ('January', 'February',
  'March', 'April', 'May', 'June', 'July', 'August', 'September',
  'October', 'November', 'December');
FormatStr : array[1..2] of tChar4 = ('%d', '%02d');

TYPE
tLongDateTimeRec = record
  TimeSep : array[0..1] of char;                                   {ex. :}
  Time24Hour : boolean;                    {true= 24-hour; false= 12-hour}
  TimeTrailers : array[false..true] of tChar8;               {ex. pm & am}
  HoursLeadingZero : integer;                                  {1=1; 2=01}
  DateSeps : array[1..3] of tChar6;   {ex. ',' & ' ' between mon, day, yr}
  Day1Char : integer;                                     {1=d=1; 2=dd=01}
  Year2Char : boolean;                       {true=yy=94; false=yyyy=1994}
  DayOfWeek3Char : integer;            {-1=none; 0=ddd=Sun; 1=dddd=Sunday}
  MonthFormat : integer;     {1(m)=3; 2(mm)=03; 3(mmm)=Mar; 4(mmmm)=March}
  DateOrder : integer;                               {1=MDY; 2=DMY; 3=YMD}
end;

pLongDateMainWin = ^tLongDateMainWin;
tLongDateMainWin = object(tWindow)
  LongDateTimeRec : tLongDateTimeRec;
  procedure SetupWindow; virtual;
  procedure ReadWinIni;
  procedure ParseLongDate(LongDateStr : pChar);
  procedure ShowDateAndTime;
  procedure wmWinIniChange(var Msg: tMessage); virtual
    wm_First + wm_WinIniChange;
  procedure wmTimeChange(var Msg: tMessage); virtual
    wm_First + wm_TimeChange;
end;

tLongDateApp = object(tApplication)
  procedure InitMainWindow; virtual;
end;

VAR
  sLongDateStr : array[0..54] of char;    {used only to display sLongDate}

{========================================}
procedure tLongDateMainWin.SetupWindow;
begin
  inherited SetupWindow;
  MoveWindow(hWindow,  10, 10, 620, GetSystemMetrics(sm_cyCaption), true);
  ReadWinIni;
  ShowDateAndTime;
end;


procedure tLongDateMainWin.ReadWinIni;
const
  defaultLongDateStr : array[0..23] of char =
    'dddd'' ''mmmm'' ''d'', ''yyyy';
begin
  with LongDateTimeRec do
  begin
    GetProfileString('intl', 'sTime', ':', TimeSep, sizeof(TimeSep));
    Time24Hour := boolean(GetProfileInt('intl', 'iTime', 0));
    GetProfileString('intl', 's2359', 'pm',
      TimeTrailers[false], sizeof(TimeTrailers[false]));
    GetProfileString('intl', 's1159', 'am',
      TimeTrailers[true], sizeof(TimeTrailers[true]));
    HoursLeadingZero := GetProfileInt('intl', 'iTLZero', 0) + 1;
    if GetProfileString('intl', 'sLongDate', defaultLongDateStr,
      sLongDateStr, sizeof(sLongDateStr)) > 53 then
        StrCopy(sLongDateStr, defaultLongDateStr);
  end;
  ParseLongDate(sLongDateStr);
end;


procedure tLongDateMainWin.ParseLongDate(LongDateStr : pChar);
const
  TheCowsComeHome : boolean = false;
  HellFreezesOver : boolean = false;
var
  SepNum,                                           {separator 1, 2, or 3}
  First, Index, x : integer;
  ParsingSep,                     {rather than of mon, day, or yr picture}
  QuotedSep : boolean;                               {ex. ', ' or ' of  '}
begin
  with LongDateTimeRec do
  begin                     {set some defaults in case LongDateStr is bad}
    for SepNum := 1 to 3 do StrCopy(DateSeps[SepNum], ' ');
    DateOrder := 0;                                    {set/checked below}
    DayOfWeek3Char := -1;                                 {no day of week}
    Day1Char := 1;                                            {1, 2, etc.}
    Year2Char := false;                                 {1995, 1996, etc.}

    ParsingSep := false;
    Index := 0;
    if LongDateStr[Index] = '''' then
    begin
      ParsingSep := true;
      QuotedSep := true;
      Index := 1;
    end;

    First := 0;
    SepNum := 1;
    repeat
      if ParsingSep then
      begin
        x := 0;
        repeat
          if x < MaxSepLen then DateSeps[SepNum][x] :=
            LongDateStr[Index];              {accept no more than 6 chars}
          if QuotedSep
          and (LongDateStr[Index] = '''')             {quote in separator}
          and (LongDateStr[Index + 1] = '''') then
            inc(Index);                           {accept 1 '; skip one '}
          inc(Index);
          inc(x);
          if (LongDateStr[Index] = #0)          {not expected; bad string}
          or (QuotedSep                         {end of quoted separator?}
              and (LongDateStr[Index] = '''')
              and (LongDateStr[Index - 1] <> '''')               {a space}
              and (LongDateStr[Index + 1] <> ''''))              {d, m, y}
          or (not QuotedSep                   {end of unquoted separator?}
              and (LongDateStr[Index] in
                ['d','D','m','M','y','Y'])) then break;
        until TheCowsComeHome;
        if x > MaxSepLen then x := MaxSepLen;
        DateSeps[SepNum][x] := #0;
        ParsingSep := false;
      end
      else                 {parsing day of week, day, month, year picture}
      begin
        repeat
          inc(Index);
        until (LongDateStr[Index] = #0)                         {expected}
        or (LongDateStr[Index] <> LongDateStr[First]);
        x := Index - First;                                       {length}
        case UpCase(LongDateStr[First]) of
          'D' :
          begin
            case x of
              1, 2 :
              begin
                Day1Char := x;                           {1=1-31; 2=01-31}
                if DateOrder = 0 then DateOrder := 2;                {dmy}
              end;
              3, 4 :
              begin
                DayOfWeek3Char := ord(x = 4); {false=0=Sun; true=1=Sunday}
                SepNum := 0;          {so it will increment to 1; we just}
              end;             {parsed day of week, so 1st separator next}
            end;
          end;
          'M' :
          begin
            MonthFormat := x;          {1=1-12; 2=01-12; 3=Jan; 4=January}
            if DateOrder = 0 then DateOrder := 1;                    {mdy}
          end;
          'Y' :
          begin
            Year2Char := (x = 2);                   {true=94; false =1994}
            if DateOrder = 0 then DateOrder := 3;                    {ymd}
          end;
        end;
        inc(SepNum);
        if SepNum > 3 then SepNum := 3;
        ParsingSep := true;
        if LongDateStr[Index] = '''' then QuotedSep := true
        else QuotedSep := false;
      end;
      if LongDateStr[Index] = #0 then break
      else
      begin
        if LongDateStr[Index] = '''' then inc(Index);             {skip '}
        First := Index;
      end;
    until HellFreezesOver;

    for Index := 1 to 3 do
    begin                                {be sure end of separator is ' '}
      x := StrLen(DateSeps[Index]);
      if DateSeps[Index][x - 1] <> ' ' then
      begin
        if x < MaxSepLen then StrCat(DateSeps[Index], ' ')
        else DateSeps[Index][x - 1] := ' '; {6 chars from Win 3.0; keep 5}
      end;
    end;
     {bad sLongDate; make it MDY; else Date Order = value 1st given to it}
    if DateOrder = 0 then inc(DateOrder);
    if (MonthFormat < 1) or (MonthFormat >  4) then MonthFormat := 4;
  end;
end;


procedure tLongDateMainWin.ShowDateAndTime;
var          {for demo just concatenate each element into a single string}
  tempDate, tempYear, tempMonth,
  tempDay, tempDayOfWeek, tempHr,
  tempHour, tempMin, tempSecs, tempSecs100 : word;
  DisplayStr : array[0..120] of char;
  tempStr : array[0..9] of char;
  {----------------------------------------}
  procedure AddMonth(Index : integer);
  begin
    with LongDateTimeRec do
    begin
      case MonthFormat of
      1, 2 :                                                   {1=3; 2=03}
        wvsprintf(tempStr, FormatStr[MonthFormat], tempMonth);
      3, 4 : begin                                        {3=Mar; 4=March}
        StrCopy(tempStr, LongMonthNameArray[tempMonth]);
        if MonthFormat = 3 then tempStr[3] := #0;
             end;
      end;
      StrCat(StrCat(DisplayStr, tempStr), DateSeps[Index]);
    end;
  end;
  {----------------------------------------}
  procedure AddDay(Index : integer);
  begin
    with LongDateTimeRec do
    begin
      wvsprintf(tempStr, FormatStr[Day1Char], tempDay);
      StrCat(DisplayStr, tempStr);
      if Index <> 0 then StrCat(DisplayStr, DateSeps[Index]);
    end;
  end;
  {----------------------------------------}
  procedure AddYear(Index : integer);
  begin
    with LongDateTimeRec do
    begin
      if Year2Char then
        tempYear := (tempYear - ((tempYear div 100) * 100));
      wvsprintf(tempStr, '%d', tempYear);
      StrCat(DisplayStr, tempStr);
      if Index <> 0 then StrCat(DisplayStr, DateSeps[2]);
    end;
  end;
  {----------------------------------------}
begin
  GetDate(tempYear, tempMonth, tempDay, tempDayOfWeek);
  GetTime(tempHour, tempMin, tempSecs, tempSecs100);
  tempHr := tempHour;
  with LongDateTimeRec do
  begin
    if not Time24Hour then          {12 hour; else use unmodified 24 hour}
      if tempHour mod 12 > 0 then tempHr := tempHr mod 12
      else tempHr := 12;
    wvsprintf(DisplayStr, FormatStr[HoursLeadingZero], tempHr);
    StrCat(DisplayStr, TimeSep);                    {add hour & separator}
    wvsprintf(tempStr, FormatStr[2], tempMin);
    StrCat(StrCat(DisplayStr, tempStr), ' ');            {add min & space}
    if Time24Hour then
      StrCat(DisplayStr, TimeTrailers[false])             {ex. EST or GMT}
    else
      StrCat(DisplayStr, TimeTrailers[tempHour < 12]);            {ex. AM}
    StrCat(DisplayStr, ' ');
    if DayOfWeek3Char <> -1 then                          {do Day of Week}
    begin
      StrCopy(tempStr, LongDayNameArray[tempDayOfWeek]);
      if DayOfWeek3Char = 0 then tempStr[3] := #0;
      StrCat(DisplayStr, tempStr);
    end;
    StrCat(DisplayStr, DateSeps[1]);
    case DateOrder of
      1 : begin AddMonth(2); AddDay(3); AddYear(0); end;             {MDY}
      2 : begin AddDay(2); AddMonth(3); AddYear(0); end;             {DMY}
      3 : begin AddYear(2); AddMonth(3); AddDay(0); end;             {YMD}
    end;
  end;
  StrCat(StrCat(StrCat(DisplayStr, ' ['), sLongDateStr), ']');
  SetWindowText(hWindow, DisplayStr);          {display as window caption}
end;


procedure tLongDateMainWin.wmWinIniChange(var Msg: tMessage);
begin
  if (Msg.lParam = 0)
  or (StrComp(pChar(Msg.lParam), 'intl') = 0) then
  begin
    ReadWinIni;
    ShowDateAndTime;
    Msg.Result := 0;
  end;
end;


procedure tLongDateMainWin.wmTimeChange(var Msg: tMessage);
begin
  ReadWinIni;
  ShowDateAndTime;
  Msg.Result := 0;
end;

{----------------------------------------}
procedure tLongDateApp.InitMainWindow;
begin
  MainWindow := new(pLongDateMainWin, init(nil, 'LD Demo'));
end;

{========================================}
var
  LongDateApp : tLongDateApp;

begin
  LongDateApp.Init('LDApp');
  LongDateApp.Run;
  LongDateApp.Done;
end.
