//
// This program demonstrates an arithmetic conversion
// problem found in Borland C++ 4.5.  Both the 16- and
// 32-bit compilers run into problems when trying to
// test the enumerated variable Value in the if
// statement in main.
//
// For unknown reasons, the compiler decides to test
// Value by converting both Value and 0 to type foo,
// then using the operator==() defined for objects
// of type foo.  This results in output that looks
// like this:
//
//  C> BUG0895
//  foo(0)
//  foo(1)
//  foo 1 != 0
//  Value is true
//  ~foo(1)
//  ~foo(0)
//  C>
//
//  The output should look like this:
//
//  C> BUG0895
//  Value is true
//  C>
//

#include <iostream.h>

class foo {
    public:
        const int val;
        foo( int i = -1 ) : val( i ) {
            cout << "foo(" << i << ")\n";
        }
        ~foo() {
            cout << "~foo(" << val << ")\n";
         }
};

int operator!=( const foo &a, const foo &b )
{
    cout << "foo "
          << a.val
          << " != "
          << b.val
          << "\n";
    return a.val != b.val;
}

enum { a = 1, b = 0 } Value = a;

enum NotUsed;
int operator|( NotUsed, NotUsed );

int main()
{
    if ( Value )
        cout << "Value is true\n";
    return 0;
}
