/*
 *  filefind.c - a simple filename routine.
 */

#include <windows.h>
#include <commdlg.h>

#include <stdlib.h>     /* size_t   */
#include <string.h>     /* memset() */


BOOL    SimpleGetOpenFileName(HWND ParentWindow,
    char FAR *FileName, size_t MaxPath, char FAR *Filter)
    {
    OPENFILENAME    DialogArgs;

    if(Filter == NULL)
        Filter  = "All file types\0*.*";
    *FileName               = '\0';
    memset(&DialogArgs, 0, sizeof(DialogArgs));
    DialogArgs.lStructSize  = sizeof(DialogArgs);
    DialogArgs.hwndOwner    = ParentWindow;
    DialogArgs.lpstrFilter  = Filter;
    DialogArgs.nFilterIndex = 1;
    DialogArgs.lpstrFile    = FileName;
    DialogArgs.nMaxFile     = MaxPath;
    DialogArgs.Flags        = OFN_FILEMUSTEXIST | OFN_SHOWHELP;

    return GetOpenFileName(&DialogArgs);
    }




