{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMWIN2.PAS
              A tool for reviewing the various window
              styles and settings. Run it & see!
}

program DemWin2;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldAttr, GoldIO, GoldIO2, GoldTint,
              GoldFast, GoldWin, GoldKey, GoldMisc;

type
   WindowCfg = record
      Style: byte;
      Custom:boolean;
      WType: byte;
      Tit:boolean;
      Num:boolean;
   end; {WindowCfg}

var
  WinHandle: integer;
  WinSettings: WindowCfg;
  Finished: boolean;
  ECode: gAction;

procedure SetScreen;
{Paints the background}
begin
   Clear(BlackOnLightGray,' ');
   ClearLine(25,YellowOnBlue);
   Box3d(20,2,60,4,whiteonlightgray,blackonlightgray,1);
   WriteCenter(3,UseTint,' Window Formats and Styles ');
   Box3d(5,5,76,23,whiteonlightgray,blackonlightgray,1);
   GotoXY(1,1);
end; {SetScreen}

procedure InitVars;
{}
begin
   with WinSettings do
   begin
      Style := 7;
      Custom := true;
      WType := 5;
      Tit := true;
      Num := false;
   end;
end; {InitVars}

procedure WriteDemoText;
{}
begin
   WritePlain(1,1,'Press Esc or click the right mouse button to return to the form.');
   WinDrawTop;   {repaint the window}
end; {WriteDemoText}

procedure SetFields;
{Creates the input Form which defines the window characteristics}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   KwikAddField(1,8,7);
   KwikAddField(2,45,7);
   KwikAddField(3,45,12);
   KwikAddField(4,50,21);
   KwikAddLastField(5,62,21);

   RadioField(1,35,10,WinSettings.Style);
   RadioAddItem(1,1,1,'~0~ No border','A window with no border',48);
   RadioAddItem(1,1,2,'~1~ Single line','A plain single line window',49);
   RadioAddItem(1,1,3,'~2~ Double line','A plain double line window',50);
   RadioAddItem(1,1,4,'~3~ Title Bar   (no border)','A "caption" title bar with no border',51);
   RadioAddItem(1,1,5,'~4~ Edge Border (no title bar)','Uses special characters to draw an edge border',52);
   RadioAddItem(1,1,6,'~5~ Menu-Style ','A "Professional Write" style used in menus',53);
   RadioAddItem(1,1,7,'~6~ Title Bar + edge border','Uses custom characters',54);
   RadioAddItem(1,1,8,'~7~ Raised chisel effect','Chiselled single line border ',55);
   RadioAddItem(1,1,9,'~8~ Sunken chisel effect','Chiselled single line border',56);
   RadioAddItem(1,1,10,'~9~ Ring-style Notepad','Used for special effects',57);
   SetLabel(1,LabelTop,LabelTop,' Style ');
   {field 2}
   CheckField(2,28,3);
   CheckAddItem(2,1,1,'~U~se Custom chars','Use Gold''s custom characters when checked',278,WinSettings.Custom);
   CheckAddItem(2,1,2,'~D~isplay example title','Display an example title in the Show Me window',288,WinSettings.Tit);
   CheckAddItem(2,1,3,'Display a ~n~umber','Show an example window number',305,WinSettings.Num);
   SetLabel(2,LabelTop,LabelTop,' Miscellaneous');
   {field 3}
   RadioField(3,28,5,WinSettings.WType);
   RadioAddItem(3,1,1,'~P~lain (no icons)','',48);
   RadioAddItem(3,1,2,'~C~loseable','',48);
   RadioAddItem(3,1,3,'~M~ove and close','',48);
   RadioAddItem(3,1,4,'Move ~n~o close','',48);
   RadioAddItem(3,1,5,'Move, close & ~s~tretch','',48);
   SetLabel(3,LabelTop,LabelTop,' Icons ');
   {field 4 & 5}
   ButtonDefaultField(4,'~S~how me!',Stop1);
   SetHK(4,287);
   SetMessage(4,0,0,'Display an example of the window configuration');
   ButtonField(5,'  E~x~it  ',GoldIO.Finished);
   SetHK(5,301);
   SetMessage(5,0,0,'Terminate the program');
end; {SetFields}

procedure ShowWin;
{}
begin
   SaveScreen(1);
   ClearText(50,21,74,22,7);
   Attrib(1,1,80,25,7);
   CursorOff;
   SetBlinking(false);
   if WinSettings.Custom then
      UseCustomChars;
   {try changing the last argument in the following call
    to any value in the range 0 through 9}
   WinHandle := WinCreate(19,7,62,15,pred(WinSettings.Style));  {creates a window structure, but doesn't draw it}
   WinSetType(WinHandle,WinType(pred(WinSettings.WType)));
   if WinSettings.Tit then
      WinSetTitle(WinHandle,' Window Title ');
   WinSetShowNum(WinHandle,WinSettings.Num);
   if pred(WinSettings.Style) in [7,8] then
   begin
      WinSetColor(WinHandle,WinBody,blackonlightgray);
      WinSetColor(WinHandle,WinIcons,yellowonlightgray);
   end;
   WinDisplay(WinHandle);
   ActivateWindow(WinHandle);
   LineWrap := true;  {instructs gold to wrap the text of too long for window}
   WriteDemoText;
   MouseShow(true);
   Finished := false;
   repeat
      GetInput;
      with KeyVars do
      begin
         if IsWinKey(LastKey,LastX,LastY) then
            WinProcessKey(LastKey,LastX,LastY);
         case LastKey of
            27,600,504: begin
               Finished := true;
               MouseRelease;
            end;
            602: begin    {window was zoomed or stretched -- need to redraw contents}
               WriteDemoText;
               WinDrawAll;
            end;
         end; {case}
      end;
   until Finished;
   WinDispose(WinHandle);
   WinDrawAll;
   RemoveCustomChars;
   RestoreScreen(1);
   DisposeScreen(1);
   MouseShow(true);
end; {ShowWin}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   InitVars;
   SetFields;
   PromptOK('','Choose the window characteristics and then|press "Show Me" to see the window in action!');
   repeat
      Ecode := EditForm(1);
      if Ecode = Stop1 then
         ShowWin;
   until Ecode = GoldIO.Finished;
   MouseShow(false);
   DisposeFields;
   DisposeForms;
   WinDispose(WinHandle);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
