{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DemMen3.PAS
              Shows how to use a Hindhook to display a menus long
              description.
}

program DEMMEN3;

uses CRT, DOS, GoldFast, GoldMenu, GoldAttr, GoldTint,
               GoldMisc, GoldKey, GoldWin;

var
  MainMenu: MenuRecord;
  Choice,Ecode: integer;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlue,chr(176));
   ClearLine(1,WhiteOnBlue);
   ClearLine(23,WhiteOnBlue);
   ClearLine(24,WhiteOnBlue);
   ClearLine(25,WhiteOnBlue);
   WriteCenter(1,LightgrayOnBlue,' Copyright (c) 1995 TechnoJock Software Inc. ');
end; {SetScreen}

procedure SetMenu;
{}
begin
   MenuSet(MainMenu);
   with MainMenu do
   begin
      Heading1     := 'TechnoJock''s Turbo Toolkit';
      Heading2     := 'Avec Hook';
      Topic[1]     := 'Unit Descriptions';
      Topic[2]     := 'Unit Demos';
      Topic[3]     := 'Self-Running Demo';
      Topic[4]     := 'How to register';
      Topic[5]     := 'About GOLD';
      Topic[6]     := '';
      Topic[7]     := 'Exit Demo';
      TotalPicks   := 7;
      Boxtype      := 5;
      AddPrefix    := 3;
      PicksPerLine := 1;
      AllowEsc     := false;
   end;
end; { SetMenu }

{$F+}
procedure LongDesc(Choice:integer; var Ecode:integer);
{Displays a londescription for the highlighted topic}
var Msg: StrScreen;
begin
   ClearLine(24,WhiteOnBlue);
   case Choice of
     1: Msg := 'Provides exciting descriptions of each unit';
     2: Msg := 'Runs demonstrations showing the power of each unit';
     3: Msg := 'Launches into the self-running demo';
     4: Msg := 'Explains how you can register Gold';
     5: Msg := 'Displays program information';
     7: Msg := 'Stops the program';
   end;
   WriteCenter(24,UseTint,Msg);
end; { LongDesc }
{$F-}

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   clrscr;
   SetScreen;
   SetMenu;
   MainMenu.HindHook := LongDesc;
   MouseShow(true);
   Choice := 1;
   repeat
      DisplayMenu(MainMenu,false,Choice,ECode);
      case Choice of
         1: PromptOK(' Pretend ','You chose Unit Descriptions');
         2: PromptOK(' Pretend ','You chose Unit Demos');
         3: PromptOK(' Pretend ','You chose Self-Running Demo');
         4: PromptOK(' Pretend ','How to register');
         5: PromptOK(' About ','^Gold||Copyright 1995 TechnoJock Software, Inc.');
      end;
   until Choice = 7;
   MouseShow(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DEMMEN3 }
