{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMMEMO1.PAS
}

program DemMemo1;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDB, GoldFast, GoldWin, GoldTint, GoldAttr, GoldMemo,
               GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc,
               GoldKey, GoldLink;

const FN = 'DEMMEMO.DBF';
      Msg1 = 'An Example of Browsing and Editing with a Memo Field';
      Msg2 = ' Employee Job Descriptions ';
      Msg5 = ' Top of file ';
      Msg6 = '^Looping to last record';
      Msg7 = ' End of file ';
      Msg8 = '^Looping to first record';
      Msg9 = ' Deleting Record! ';
      Msg10 = '^Are you sure?';
      Msg11 = ' Quitting Program ';
      Msg12 = '^Have you really finished?';
      Msg13 = ' About to cancel! ';
      Msg14 = 'Unable to create all the fields!';
      Msg15 = 'Unable to create data file!';
      Msg16 = ' File Error ';
      EdtBtn = '~E~dit';
      AddBtn = '~A~dd';
      SavBtn = '~S~ave';
      CanBtn = '~C~ancel';
      DelBtn = '~D~el';
      QuiBtn = ' ~Q~uit ';

type EmpRecord = record
       EmpName: string[30];
       Dept: string[30];
       JobDesc: SingleLL;
       MemoFldVar: MemoCfg;
     end;

var I, Win1,
    ActiveField: integer;
    UserTerminates,
    Cancelling, Adding: boolean;
    RecNum, X, SavedX: longint;
    LastAction: gAction;
    SavdEmpRec, EmpRec: EmpRecord;
    NdxFld: integer;
    SavValidate: gValidate;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,Msg1);
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
   Tint[IOLabelNorm] := LightBlueOnLightGray;
   Tint[IOLabelNormHot] := LightBlueOnLightGray;
   Tint[IOLabelHi] := LightBlueOnLightGray;
   Tint[IOLabelHiHot] := LightBlueOnLightGray;
   Tint[IOLabelOff] := LightBlueOnLightGray;
end; { SetScreen }

procedure SaveEmpRec;
{}
begin
   SavdEmpRec := EmpRec;
   SavedX := X;
end; { SaveUserRec }

procedure RestoreEmpRec;
{}
begin
   EmpRec := SavdEmpRec;
   X := SavedX;
end; { RestoreUserRec }

procedure InitData(FirstTime:boolean);
{}
begin
   with EmpRec do
   begin
      EmpName := '';
      Dept := '';
      if FirstTime then
         InitSLLStr(JobDesc)
      else
      begin
         SLLSetActiveList(EmpRec.JobDesc);
         SLLEmptyList;
         if SLLAddStr(MemoVars.EndofParaCode) <> 0 then
            PromptOK(' Memory Error ','Insufficient memory to execute!');
      end;
      MemoSetDirty(MemoFldVar,true);
      MemoSetDirtyFlag(MemoFldVar);
   end;
end; { InitData }

procedure DatabaseToScreen(RecNo:longint);
{}
begin
   with EmpRec do
   begin
      EmpName := DbGetFldString(RecNo,1);
      Dept := DbGetFldString(RecNo,2);
      if DbGetMemoRecNum(RecNo,3) = 0 then  {no memo}
      begin
         SLLSetActiveList(JobDesc);
         SLLEmptyList;
      end
      else
         DbGetFldMemo(RecNo,3,MemoFldVar);
      MemoReAssignSLL(MemoFldVar,JobDesc);
   end;
end; { DatabaseToScreen }

procedure ScreenToDatabase;
{}
var MemRecNum: longint;
begin
   with EmpRec do
   begin
      DbSetFldString(1,EmpName);
      DbSetFldString(2,Dept);
      MemRecNum := DbSetFldMemo(3,JobDesc);
      MemoStoreActiveLine(MemoFldVar);
   end;
   if Adding then
   begin
      DbAddRecord;
      Adding := false;
   end else
      DbPutRecord;
end; { ScreenToRecord }

procedure BuildForm;
{}
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   SetFormWindow(2,3,78,22,7);
   Win1 := FormWinNum;
   WinSetTitle(Win1,Msg2);
   WinSetType(Win1,WMoveNoClose);
   WinSetShowNum(Win1,false);
   SetMessageXY(12,25,false);
   WinDisplay(Win1);
   KwikAddField(1, 30,2);        { EMPNAME C 30 }
   KwikAddField(2, 30,3);        { DEPT C 30 }
   KwikAddField(3, 10,5);        { JOBDESC M 10 }
   KwikAddField(4, 3,17);        { goto top }
   KwikAddField(5, 9,17);        { prev }
   KwikAddField(6, 14,17);       { next }
   KwikAddField(7, 19,17);       { goto end }
   KwikAddField(8, 26,17);       { add }
   KwikAddField(9, 33,17);       { del }
   KwikAddField(10, 40,17);      { edit/save }
   KwikAddLastField(11, 48,17);  { quit/cancel }
   with EmpRec do
   begin
      StringField(1,EmpName,Replicate(30,'*'));
      FieldRules(1,NoRules+EraseDefault,[NoChar],[NoChar]);
      { turns off allowNul, turn on EraseDefault }
      StringField(2,Dept,Replicate(30,'*'));
      MemoField(3,60,8,MemoFldVar);
   end;
   ButtonField(4,'',Stop1);
   ButtonField(5,'',Stop2);
   ButtonField(6,'',Stop3);
   ButtonField(7,'',Stop4);
   ButtonField(8,AddBtn,Stop8);
   ButtonField(9,DelBtn,Stop9);
   ButtonField(10,EdtBtn,Stop5);
   ButtonDefaultField(11,QuiBtn,escaped);
   { define labels }
   SetLabel(1,LabelLeft,LabelLeft,'Employee''s name');
   SetLabel(2,LabelLeft,LabelLeft,'Department');
   SetLabel(3,LabelTop,LabelTop,'Job Description');
   { define messages }
   SetMessage(1,0,0,'Enter the Employee''s name (Last, First MI');
   SetMessage(2,0,0,'Enter the department the employee works in');
   SetMessage(3,0,0,'Enter the employee''s Job Description');
   SetMessage(4,0,0,'Go to first record in database');
   SetMessage(5,0,0,'Go to previous record in database');
   SetMessage(6,0,0,'Go to next record in database');
   SetMessage(7,0,0,'Go to last record in database');
   SetMessage(8,0,0,'Add a new record');
   SetMessage(9,0,0,'Delete current record');
   SetMessage(10,0,0,'Edit or Save record');
   SetMessage(11,0,0,'Cancel or Return to DOS');
   { define hotkeys }
   SetHK(8,286);  { Alt+A } {add button}
   SetHK(9,288);  { Alt+D } {del button}
   SetHK(10,274);  { Alt+E } {edit button}
   SetHK(11,272);  { Alt+Q } {quit button}
   for I := 1 to 3 do  { set for browse }
      FieldSetState(I,FldOff);
end; { BuildForm }

procedure CreateNewDataFile;
{could be built on the fly via I/O form}
var EValue: integer;
begin
   EValue := 0;
   inc(EValue,DbAddDbfField('EMPNAME','C',30,0));
   inc(EValue,DbAddDbfField('DEPT','C',30,0));
   inc(EValue,DbAddDbfField('JOBDESC','M',0,0));
   if EValue <> 0 then
   begin
      PromptOK(Msg16,Msg14);
      Halt;
   end else
   begin
      EValue := DbBuildDataFile(FN,0);
      if EValue <> 0 then
      begin
         PromptOK(Msg16,Msg15);
         Halt;
      end;
   end;
end; { CreateNewDataFile }

procedure PreSetFields;
{}
begin
   if DbGetNumRecs < 2 then
   begin
      for I := 4 to 7 do { turn off VCR buttons }
         FieldSetState(I,FldOff);
      FieldSetState(9,FldOff); { turn off edit button }
      FieldSetState(10,FldOff); { turn off del button }
      ActiveField := 8;  {add button}
   end else
      ActiveField := 6;
end; { PreSetFields }

procedure CompleteStop6or7; { save / cancel }
{}
begin
   for I := 1 to 3 do          { fields }
      FieldSetState(I,FldOff);
   for I := 4 to 11 do
      FieldSetState(I,FldOn);
   ButtonChangeSettings(10,EdtBtn,Stop5);
   SetHK(10,274); {Alt-E}
   ButtonChangeSettings(11,QuiBtn,Escaped);
   SetHK(11,272); {Alt-Q}
   SetDefaultButton(11);
   ActiveField := 6;  { next }
end; { CompleteStop6or7 }

procedure SetValidation;
{}
begin
   SavValidate := IOVars.DefaultValidate;
   IOVars.DefaultValidate := ValidateAtEnd;
end; { SetValidation }

procedure RestoreValidation;
{}
begin
   IOVars.DefaultValidate := SavValidate;
end; { RestoreValidation }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   if not Exist(FN) then
      CreateNewDataFile;
   NdxFld := 1;
   if DbOpenDataSet(FN) <> 0 then
   begin
      if DbIndexedField = 0 then
         if NdxBuildNew(NdxFld) <> 0 then
         begin
            PromptOK(' INDEX ERROR ','Index is missing!');
            halt;
         end;
      Tint[IOWinTitle] := WhiteOnRed;
      InitData(true);
      MemoAssignSLL(Emprec.MemoFldVar,EmpRec.JobDesc);
      SetValidation;
      SetScreen;
      BuildForm;
      MouseShow(true);
      Adding := false;
      PreSetFields;
      UserTerminates := false;
      DbSetFullStrings(false);
      X := NdxGotoFirst;
      repeat
         RecNum := X;
         if (DbGetNumRecs > 0) and (X > 0) then
            DatabaseToScreen(X);
         DisplayForm;
         LastAction := EditForm(ActiveField);
         ActiveField := FieldWithFocus;
         case LastAction of
            Stop1: begin
                      X := NdxGotoFirst;
                      ActiveField := 6;  { next }
                   end;
            Stop2: begin
                      X := NdxGotoPrev;
                      if X = 0 then
                      begin
                         X := NdxGotoLast;
                         PromptOK(Msg5,Msg6)
                      end;
                   end;
            Stop3: begin
                      X := NdxGotoNext;
                      if X = 0 then
                      begin
                         X := NdxGotoFirst;
                         PromptOK(Msg7,Msg8);
                      end;
                   end;
            Stop4: begin
                      X := NdxGotoLast;
                      ActiveField := 5;  { prev }
                   end;
            Stop8,         { add  }
            Stop5: begin   { edit }
                      SaveEmpRec;
                      if (LastAction = Stop8) then
                      begin
                         Adding := true;
                         InitData(false);
                         X := 0; { prevents redisplaying previous data }
                         FieldSetState(8,FldOff); { add }
                         FieldSetState(9,FldOn);  { edit/save }
                      end;

                      for I := 1 to 3 do          { fields }
                         FieldSetState(I,FldOn);
                      for I := 4 to 7 do         { vcr }
                         FieldSetState(I,FldHidden);
                      ButtonChangeSettings(10,SavBTn,Stop6);
                      SetHK(10,287); {Alt-S}
                      ButtonChangeSettings(11,CanBtn,Cancel1);
                      SetHK(11,302); {Alt-C}
                      SetDefaultButton(0);
                      ActiveField := 1;
                      ClearText(1,1,80,25,Tint[IOLabelNorm]);
                   end;
            Stop6: begin   { save }
                      ScreenToDatabase;
                      CompleteStop6or7;
                   end;
          Cancel1: begin   { cancel (Stop7) }
                      Cancelling := true;
                      if PromptYesNo(Msg13,Msg10) = 1 then
                      begin
                         Adding := false;
                         if DbGetNumRecs > 0 then
                            RestoreEmpRec;
                         CompleteStop6or7;
                      end
                   end;
            Stop9: begin   { delete }
                      for I := 12 to 16 do
                         FieldSetState(I,FldHidden);
                      FieldSetState(18,FldHidden);
                      if PromptYesNo(Msg9,Msg10) = 1 then
                      begin
                         DbDeleteRecord(X);
                         X := NdxGotoNext;
                         if X = 0 then
                            X := NdxGotoFirst;
                      end;
                      for I := 12 to 16 do
                         FieldSetState(I,FldOn);
                      FieldSetState(18,FldOn);
                      ActiveField := 14;
                   end;
          Escaped: begin
                      if PromptYesNo(Msg11,Msg12) = 1 then
                         UserTerminates := true;
                   end;
         end;  { case }
      until UserTerminates;
      DisposeFields;
      DisposeForms;
      SLLSetActiveList(EmpRec.JobDesc);
      SLLDestroy;
      MouseShow(false);
      DbCloseAllDatabases;
      RestoreValidation;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
