{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMMEM2.PAS
              Edits a text file with word-wraping activated.
              If the text file does not exist, a empty paragraph is
              displayed. All edits are optionally saved back to the
              text file.
}

program DemMem2;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldMisc, GoldLink, GoldKey, GoldWin, GoldMemo;

const
   TextFileName = 'DEMMEM2.TXT';

var
   TextData: SingleLL;
   MemoSettings: MemoCFG;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightgray);
   WriteCenter(1,UseTInt,'TTT Gold');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure BuildSLL;
{}
begin
   InitSLLStr(TextData);
   SLLSetActiveList(TextData);
   if SLLLoadFromFile(TextFileName) <> 0 then {file not found}
      if SLLAddStr('') <> 0 then
      begin
         PromptOK(' ERROR ','Not enough memory to execute program');
         halt;
      end;
end; {BuildSLL}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   BuildSLL;
   InitMemoCfg(MemoSettings);
   MemoAssignSLL(MemoSettings,TextData);
   MouseShow(true);
   RunMemo(MemoSettings,' Editing a Text File with Word Wrap ');
   MouseShow(false);
   SLLSetActiveList(TextData);
   if MemoIsDirty(MemoSettings)
   and (PromptYesNo(' Save ','Would you like the edits saving back to|the file '+TextFileName+'?') = 1) then
   begin
      if SLLSaveToFile(TextFileName) <> 0 then {save to disk}
         PromptOK('Oops!','Error saving edits to disk');
   end;
   SLLSetActiveList(TextData);
   SLLDestroy;
   ResetStartUpMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
