{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO6.PAS
              Illustrates how to use a Hind hook to modify field settings
}

program DEMIO6;

{$I GOLDFLAG.INC}

uses DOS, CRT, GoldAttr, GoldHard, GoldFast, GoldWin, GoldIO, GoldIO2,
      GoldDate, GoldStr, GoldKey, GoldMisc;

const
    BigFieldwidth = 40;

type
   CustomerRec = record
      Title: string[BigFieldWidth];
      Company: String[BigFieldWidth];
      Addr1: string[BigFieldWidth];
      Addr2: string[BigFieldWidth];
      City: string[BigFieldWidth];
      State: string[2];
      Zip: string[9];
      Number: string[10];
      Check1: boolean;
      Check2: boolean;
      Check3: boolean;
      Check4: boolean;
      Radio: byte;
      ListPick: integer;
   end;

var
  Cust : CustomerRec;

{$F+}
procedure MyHindHook(CurrentField:byte;var Refresh:byte);
{}
begin
   Refresh := RefreshNone;
   if CurrentField = 9 then {radio button}
   begin
      if (Cust.Radio = 4) and (FieldGetState(10) = FldOn) then
      begin
         FieldSetState(10,FldOff);
         Refresh := RefreshOthers;
      end
      else if (Cust.Radio <> 4) and not (FieldGetState(10) = FldOn) then
      begin
         FieldSetState(10,FldOn);
         Refresh := RefreshOthers;
      end;
   end;
end; {MyHindHook}
{$F-}

procedure InitVars;
{}
begin
   fillchar(Cust,sizeof(Cust),#0);
   Cust.Title := 'Bob Ainsbury';
   Cust.Check1 := true;
   Cust.Check4 := true;
   Cust.Radio := 1;
   Cust.ListPick := 1;
end; {InitVars}

procedure SetScreen;
{}
begin
   ClearText(1,1,80,25,WhiteOnBlack);
   Box3D(1,1,80,24,WhiteOnLightGray,BlackOnLightgray,1);
   Box3D(26,2,55,4,BlackOnLightGray,WhiteOnLightgray,1);
   WriteCenter(25,LightgrayOnBlack,' Copyright (c) 1993 TechnoJock Software Inc. ');
   WriteCenter(3,BlackOnLightgray,' Basic Order Entry Screen ');
   GotoXY(1,1);
end; {SetScreen}

procedure SetFields;
{}
var I : Integer;
begin
    CreateForms(1);
    ActivateForm(1);
    AllowEsc(true);
    {Add all the fields}
    KwikAddField(1,  17,6);
    KwikAddField(2,  17,7);
    KwikAddField(3,  17,8);
    KwikAddField(4,  17,9);
    KwikAddField(5,  17,10);
    KwikAddField(6,  17,11);
    KwikAddField(7,  25,11);
    KwikAddField(8,  43,11);
    KwikAddField(9,   7,14);
    KwikAddField(10, 35,14);
    KwikAddField(11,  7,20);
    KwikAddField(12, 65,20);
    KwikAddLastField(13, 65,22);
    {Define each field}
    StringField(1, Cust.Title,   replicate(BigFieldWidth,'*'));
    FieldRules(1,EraseDefault,[NoChar],[NoChar]);
    SetLabel(1,LabelLeft,LabelLeft,'~N~ame');
    SetHK(1,305);
    StringField(2, Cust.Company, replicate(BigFieldWidth,'*'));
    SetLabel(2,LabelLeft,LabelLeft,'~C~ompany');
    SetHK(2,302);
    StringField(3, Cust.Addr1,   replicate(BigFieldWidth,'*'));
    SetLabel(3,LabelLeft,LabelLeft,'Address ~1~');
    SetHK(3,376);
    StringField(4, Cust.Addr2,   replicate(BigFieldWidth,'*'));
    SetLabel(4,LabelLeft,LabelLeft,'Address ~2~');
    SetHK(4,377);
    StringField(5, Cust.City,    replicate(BigFieldWidth,'*'));
    SetLabel(5,LabelLeft,LabelLeft,'Cit~y~');
    SetHK(5,277);
    StringField(6, Cust.State,   '!!');
    SetLabel(6,LabelLeft,LabelLeft,'~S~tate');
    SetHK(6,287);
    StringField(7, Cust.Zip,     '#####-####');
    SetLabel(7,LabelLeft,LabelLeft,'~Z~ip');
    SetHK(7,300);
    StringField(8, Cust.Number, '(###) ###-####');
    SetLabel(8,LabelLeft,LabelLeft,'~T~el #');
    SetHK(8,276);
    {Radio Buttons}
    RadioField(9, 25,4,Cust.Radio);
    RadioAddItem(9, 1,1, 'Corporation','',0);
    RadioAddItem(9, 1,2, 'S Corporation','',0);
    RadioAddItem(9, 1,3, 'DBA','',0);
    RadioAddItem(9, 1,4, 'Individual','',0);
    SetLabel(9,LabelTop,LabelTop,'Business ~T~ype');
    SetHK(9,276);
    {Check Boxes}
    CheckField(10, 25,4);
    CheckAddItem(10, 1,1, 'Small Business','',0,Cust.Check1);
    CheckAddItem(10, 1,2, 'Minority Owned','',0,Cust.Check2);
    CheckAddItem(10, 1,3, 'English Owned','',0,Cust.Check3);
    CheckAddItem(10, 1,4, 'Woman Owned','',0,Cust.Check4);
    CheckRadioSetActive(10,3,false);
    SetLabel(10,LabelTop,LabelTop,'~B~usiness Categeory');
    SetHK(10,304);
    {List Box}
    ListField(11,25,4,Cust.ListPick);
    ListAddItem(11,'Out of State');
    ListAddItem(11,'Tax Exempt');
    ListAddItem(11,'Within State');
    ListAddItem(11,'Within County');
    ListAddItem(11,'Within City');
    ListAddItem(11,'Foreign');
    ListAddItem(11,'Other');
    SetLabel(11,LabelTop,LabelTop,'Ta~x~ Status');
    SetHK(11,301);
    {Buttons}
    ButtonDefaultField(12,'   ~O~K   ',finished);
    ButtonField(13,' C~a~ncel ',escaped);
    SetHK(12,280);
    SetHK(13,286);
end; {SetFields}

begin
{$IFOPT D+}
    HeapRecord;
{$ENDIF}
    InitVars;
    SetScreen;
    SetFields;
    MouseShow(true);
    AssignHindHook(MyHindHook);
    ProcessInput(1);
    DisposeFields;
    DisposeForms;
    GotoXY(1,21);
    MouseShow(false);
    clrscr;
{$IFOPT D+}
    HeapCheck;
{$ENDIF}
end.
