{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMGRD3.PAS
              Displaying a custom data source (in this case a database)
              in a grid window.
}

program DemGrd3;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDb, GoldFast, GoldWin, GoldTint, GoldAttr,
     GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc, GoldGrid,
     GoldKey, GoldLink, GoldList;

const FN = 'DEMCUST.DBF';

type
     UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
     end;

const
   ColumnSep:char = '';
   ColumnEnd:char = '';

var
   GridLayout: ListCfg;
   TabStops: array[1..10] of integer;
   GridHeading: string;
   Ecode: integer;

{$F+}
function GetStrfromDB(P:pointer; Element,Start,Finish: longint): string;
{}
var
   RecNo: longint;
   FullLen: integer;
   WorkStr: string;
begin
   RecNo := NdxGetRecNum(Element);
   FullLen := 1;
   WorkStr := '';
   repeat
      case FullLen of
         1: begin  {date field}
            if FullLen >= Start then
               WorkStr := JulToStr(DbGetFldDate(RecNo,1),DDMMYY)+ColumnSep;
            FullLen := 10;
         end;
         10: begin {client field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,2),30,' ')+ColumnSep;
            FullLen := 41;
         end;
         41: begin {Addr1 field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,3),30,' ')+ColumnSep;
            FullLen := 72;
         end;
         72: begin {Addr2 field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,4),30,' ')+ColumnSep;
            FullLen := 103;
         end;
         103: begin {City field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,5),23,' ')+ColumnSep;
            FullLen := 127;
         end;
         127: begin {ST field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,6),2,' ')+ColumnSep;
            FullLen := 130;
         end;
         130: begin {Zip Field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,7),9,' ')+ColumnSep;
            FullLen := 140;
         end;
         140: begin {Country field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(DbgetFldString(RecNo,8),20,' ')+ColumnSep;
            FullLen := 161;
         end;
         161: begin {Phone field}
            if FullLen >= Start then
               WorkStr := WorkStr+PicFormat(DbgetFldString(RecNo,9),'(###) ###-####',' ',true)+ColumnSep;
            FullLen := 176;
         end;
         176: begin {Units field}
            if FullLen >= Start then
               WorkStr := WorkStr+Padleft(IntToStr(DbgetFldLong(RecNo,10)),8,' ')+ColumnEnd;
            FullLen := Finish;
         end;
      end; {case}
   until (FullLen >= Finish);
   GetStrfromDB := padleft(WorkStr,succ(Finish-Start),' ');
end; { GetStrfromDB }
{$F-}

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,' Listing a database ');
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
end; { SetScreen }

procedure SetGridLayout;
{}
begin
   Gridheading := 'Date|Client|Addr1|Addr2|City|ST|Zip|Country|Tel|Units';
   TabStops[1] := 1;
   TabStops[2] := 10;
   TabStops[3] := 41;
   TabStops[4] := 72;
   TabStops[5] := 103;
   TabStops[6] := 127;
   TabStops[7] := 130;
   TabStops[8] := 140;
   TabStops[9] := 161;
   TabStops[10] := 176;
   InitListCfg(GridLayout);
   ListAssignCustom(GridLayout,NdxCount,GetStrfromDB);
   ListAssignHeader(GridLayout,1,GridHeading);
   ListSetWin(GridLayout,5,5,75,20,7);
   ListSetGaps(GridLayout,1,0,0,1);
   GridAssignTabs(GridLayout,@TabStops,10);
end; { SetGridLayout }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   if DbOpenDataSet(FN) <> 0 then
   begin
      SetScreen;
      MouseShow(true);
      DbSetFullStrings(false);
      ECode := NdxGotoFirst;
      MouseShow(true);
      SetGridLayout;
      CursorOff;
      RunGrid(GridLayout,' List View ');
      CursorOn;
      MouseShow(false);
      DbCloseAllDatabases;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.  {DemGrd3}
