{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DemDir6.pas
              Illustrates how to add custom help to PromptDir.
}

program DemDir6;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldAttr, GoldFast, GoldLink, GoldDir, GoldHard,
               GoldMisc, GoldIO, GoldKey, GoldWin;

var DirName: string;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' File List ');
   GotoXY(1,1);
end; {SetScreen}

{$F+}
procedure NotMuchHelp;
{}
begin
  PromptOK(' Help ','Just imagine this is profoundy useful help text');
end; { NotMuchHelp }
{$F-}

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   AssignDirHelpHook(NotMuchHelp);
   DirName := PromptDir('','Set the Database directory:');
   if DirName = '' then
      PromptOK('','You Cancelled!')
   else
      PromptOK('','You chose '+DirName);
   RemoveDirhelpHook;
   writeln('Press Enter to continue');
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
