{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDIR10.PAS
              Shows how to configured Filelist so that the "root" directory
              isn't listed in the directories.
}

program DemDir10;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldAttr, GoldFast, GoldLink, GoldDir, GoldHard,
               GoldMisc, GoldIO, GoldKey, GoldWin;

var FileName: string;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' File List ');
   GotoXY(1,1);
end; {SetScreen}

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   DirVars.RootNameStr := '';  {don't display the "root" option}
   FileName := FileList('*.pas',' Pick a file -- any file! ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      PromptOK('','You chose '+FileName);
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
