{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{              Copyright 1986-1995  TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMDESK3.PAS
               An extension of DEMDESK2 with a status bar
               and a help hook.
}

program DEMDESK3;

uses DOS, CRT,
     GoldFast, GoldWin, GoldMenu, GoldMisc, GoldDesk,
     GoldKey, GoldCalc, GoldCal, GoldDate, GoldStr;

var
   MainMenu,
   StatusBar: Bar;
   SubMenu: PopUp;
   Action : dAction;

{$F+}
procedure MenuHelp(ID:integer);
{}
begin
   PromptOK(' Help! ','You asked for help on menu item ID: '+IntToStr(ID));
end; { MenuHelp }
{$F-}


procedure DefineSubMenu;
{}
begin
   InitPopUp(SubMenu);
   with SubMenu do
   begin
      PopUpAddItem(SubMenu,'~C~alculator',101,67,'Display a calculator',nil);
      PopUpAddItem(SubMenu,'Ca~l~endar',102,76,'Display a calendar',nil);
      PopUpAddItem(SubMenu,'~A~bout',103,65,'Show version and copyright information',nil);
      PopUpAddItem(SubMenu,'E~x~it',999,88,'~Exit~ this little demo',nil);
   end;
end; { DefineSubMenu }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~T~ools',100,84,276,'Select one of Desktop tools',@SubMenu);
   MainMenu.Style := 2;
   AssignMenuHelpHook(MainMenu,MenuHelp);
end; { DefineMainMenu }

procedure DefineStatusBar;
{}
begin
   InitBar(StatusBar);
   BarAddItem(StatusBar,'~F1~ Help',1001,315,315,'',nil);
   BarAddItem(StatusBar,'~Alt+X~ Exit the demo',999,301,301,'',nil);
end; { DefineStatusBar }

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
   DestroyBar(StatusBar);
end; { DisposeMenus }

{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     101: if LaunchCalculator(' Punch Me ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calculator');
     102: if LaunchCalendar(TodayInJul,' Calendar ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calendar');
     103: PromptOK(' Tools Demo ','^Copyright 1995 TechnoJock Software, Inc.|'+
                     '^All Rights Reserved');
     1001: PromptOK(' Tools Help ','^Honey if you need help, we got problems!');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineSubMenu;
   DefineMainMenu;
   DefineStatusBar;
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   DeskAssignStatusBar(Statusbar);
   UseCustomChars;
   SetBlinking(false);
   MouseShow(true);
   CursorOff;
   Action := DeskProcessInput;
   CursorOn;
   MouseShow(false);
   DisposeMenus;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
