{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDB5.PAS
              Implements a database with browse capabilities only
}

program Demdb5;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDb, GoldFast, GoldWin, GoldTint, GoldAttr, GoldMemo,
     GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc, GoldKey, GoldLink;

const FN = 'DEMCUST.DBF';

type UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
     end;

var I, Win1, Handle,
    ActiveField: integer;
    RecNum, X: longint;
    LastAction: gAction;
    UserRec: UserRecord;
    NdxFld: integer;

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure WatchNDXBuild( KeysWritten, TotRecords: longint; Status: byte );
{}
begin
  WriteProgressLong(18,57,10,KeysWritten,TotRecords,true);
end;
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,' An Example Of Browsing a Database ');
   ClearLine(2,WhiteOnBlue);
   WriteAT(68,2,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
   Tint[IOLabelNorm] := LightBlueOnLightGray;
   Tint[IOLabelNormHot] := LightBlueOnLightGray;
   Tint[IOLabelHi] := LightBlueOnLightGray;
   Tint[IOLabelHiHot] := LightBlueOnLightGray;
   Tint[IOLabelOff] := LightBlueOnLightGray;
end; { SetScreen }

procedure DatabaseToScreen(RecNo:longint);
{}
begin
   with UserRec do
   begin
      Entered := DbGetFldDate(RecNo,1);
      Client := DbGetFldString(RecNo,2);
      Addr1 := DbGetFldString(RecNo,3);
      Addr2 := DbGetFldString(RecNo,4);
      City := DbGetFldString(RecNo,5);
      State := DbGetFldString(RecNo,6);
      Zip := DbGetFldString(RecNo,7);
      Country := DbGetFldString(RecNo,8);
      Phone := DbGetFldString(RecNo,9);
      Units := DbGetFldLong(RecNo,10);
   end;
end; { DatabaseToScreen }

procedure BuildForm;
{}
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   SetFormWindow(10,4,70,22,7);
   Win1 := FormWinNum;
   WinSetTitle(Win1,' Client Profiles ');
   WinSetType(Win1,WMoveNoClose);
   WinSetShowNum(Win1,false);
   SetMessageXY(12,25,false);
   WinDisplay(Win1);
   KwikAddField(1, 48,2);         { ENTERED D 8 }
   KwikAddField(2, 21,4);         { CLIENT C 30 }
   KwikAddField(3, 21,5);         { ADDR1 C 30 }
   KwikAddField(4, 21,6);         { ADDR2 C 30 }
   KwikAddField(5, 21,7);         { CITY C 22 }
   KwikAddField(6, 49,7);         { STATE C 2 }
   KwikAddField(7, 21,8);         { ZIP C 10 }
   KwikAddField(8, 21,11);        { COUNTRY C 20}
   KwikAddField(9, 21,12);        { PHONE C 10}
   KwikAddField(10, 21,13);       { UNITS N 10 }
   KwikAddField(11, 3,16);        { goto top }
   KwikAddField(12, 9,16);        { prev }
   KwikAddField(13, 14,16);       { next }
   KwikAddField(14, 19,16);       { goto end }
   KwikAddField(15, 47,16);       { quit/cancel }
   KwikAddLastField(16, 14,2);    { Record No }
   with UserRec do
   begin
      DateField(1,Entered,MMDDYY,'',0,0);
      StringField(2,Client,Replicate(30,'*'));
      StringField(3,Addr1,Replicate(30,'*'));
      StringField(4,Addr2,Replicate(30,'*'));
      StringField(5,City,Replicate(22,'*'));
      StringField(6,State,'!!');
      StringField(7,Zip,'#####-####');
      StringField(8,Country,Replicate(20,'*'));
      StringField(9,Phone,'(###) ###-####');
      LongIntField(10,Units,'',0,0);
   end;
   ButtonField(11,'',Stop1);
   ButtonField(12,'',Stop2);
   ButtonField(13,'',Stop3);
   ButtonField(14,'',Stop4);
   ButtonDefaultField(15,' ~Q~uit ',escaped);
   LongintField(16,RecNum,'',0,0);
   FieldSetState(16,FldOff); { display only }
   { define labels }
   SetLabel(1,LabelLeft,LabelLeft,'Date');
   SetLabel(2,LabelLeft,LabelLeft,'Clients name');
   SetLabel(3,LabelLeft,LabelLeft,'Address');
   SetLabel(5,LabelLeft,LabelLeft,'City, State');
   SetLabel(7,LabelLeft,LabelLeft,'Zip code');
   SetLabel(8,LabelLeft,LabelLeft,'Country');
   SetLabel(9,LabelLeft,LabelLeft,'Phone #');
   SetLabel(10,LabelLeft,LabelLeft,'Units ordered');
   SetLabel(16,LabelLeft,LabelLeft,'Record No');
   { define messages }
   SetMessage(1,0,0,'Entry date');
   SetMessage(2,0,0,'Client''s name');
   SetMessage(3,0,0,'Street address');
   SetMessage(4,0,0,'Post office box (etc.)');
   SetMessage(5,0,0,'City');
   SetMessage(6,0,0,'State');
   SetMessage(7,0,0,'Zip code');
   SetMessage(8,0,0,'Country');
   SetMessage(9,0,0,'Telephone number');
   SetMessage(10,0,0,'Number of units client has ordered');
   SetMessage(11,0,0,'Go to first record in database');
   SetMessage(12,0,0,'Go to previous record in database');
   SetMessage(13,0,0,'Go to next record in database');
   SetMessage(14,0,0,'Go to last record in database');
   SetMessage(15,0,0,'Cancel or Return to DOS');
   { define hotkeys }
   SetHK(15,272);  { Alt+Q } {quit button}
   for I := 1 to 10 do  { set for browse }
      FieldSetState(I,FldOff);
end; { BuildForm }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   if not Exist(FN) then
      PromptOK(' DATA ERROR ','Unable to open '+FN)
   else
   begin
      NdxFld := 2;
      Handle := DbOpenDataSet(FN); {extremely important assignment}
      if Handle <> 0 then
      begin
         SetScreen;
         if DbIndexedField = 0 then
         begin
            SetShowNdxProgress(WatchNDXBuild);
            Box3D(15,8,65,12,BlackOnCyan,WhiteOnCyan,4);
            WriteAT(18,8,WhiteOnCyan,' Building Index ');
            if NdxBuildNew(NdxFld) <> 0 then
            begin
               PromptOK(' INDEX ERROR ','Index is missing!');
               halt;
            end;
            PromptOK(' Complete! ','^Index was missing|^It has been completely rebuilt,|^You may continue.');
         end;
         Tint[IOWinTitle] := WhiteOnRed;
         BuildForm;
         MouseShow(true);
         DbSetFullStrings(false);
         X := NdxGotoFirst;
         ActiveField := 13;
         repeat
            RecNum := X;
            if (DbGetNumRecs > 0) and (X > 0) then
               DatabaseToScreen(X);
            DisplayAllFields;
            LastAction := EditForm(ActiveField);
            ActiveField := FieldWithFocus;
            case LastAction of
               Stop1: begin
                         X := NdxGotoFirst;
                         ActiveField := 13;  { next }
                      end;
               Stop2: begin
                         X := NdxGotoPrev;
                         if X = 0 then
                         begin
                            X := NdxGotoLast;
                            PromptOK(' Top of file ','^Looping to last record')
                         end;
                      end;
               Stop3: begin
                         X := NdxGotoNext;
                         if X = 0 then
                         begin
                            X := NdxGotoFirst;
                            PromptOK(' End of file ','^Looping to first record');
                         end;
                      end;
               Stop4: begin
                         X := NdxGotoLast;
                         ActiveField := 12;  { prev }
                      end;
            end;  { case }
         until LastAction = Escaped;
         DisposeFields;
         DisposeForms;
         MouseShow(false);
         DbCloseAllDatabases;
      end else
         PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its components');
   end;
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
