{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDB11.PAS

}

program demdb11;

uses crt, dos, GoldFast, GoldStr, GoldLink, GoldList, GoldDb, GoldAttr,
               GoldDate, GoldWin, GoldIO, GoldIO2, GoldKey;

const FN: string[12] = 'DEMCUST.DBF';

var FormWinNum: integer;
    ListFldVar: integer;
    Handle: integer;
    ECode, X: integer;
    RadioFldVar: byte;
    Choice: gAction;
    List: SingleLL;
    ListDetails: ListCfg;

procedure SetScreen;
{}
begin
   Clear(LightGrayOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   ClearLine(25,WhiteOnBlue);
end; { SetScreen }

function BuildList:boolean;
{Returns true if there are deleted records}
begin
   SLLSetActiveList(List);
   Ecode := 0;
   for X := 1 to DbGetNumRecs do
   begin
      if not DbRecordIsActive(X) then
         inc(Ecode,SLLAddStr(PadLeft(IntToStr(X),5,' ')+''+ {include recno}
                    JulToStr(DbGetFldDate(X,1),MMDDYY)+''+
                             DbGetFldString(X,2)+''+
                             DbGetFldString(X,3)+''{+
                             DbGetFldString(X,4)+''+
                             DbGetFldString(X,5)+''+
                             DbGetFldString(X,6)+''+
                             DbGetFldString(X,7)+''+
                             DbGetFldString(X,8)+''}));
   end;
   if List.TotalNodes = 0 then
   begin
      if Ecode = 0 then
         PromptOK(' Message ','There are no deleted records|in database '+FN)
      else
         PromptOK(' Error ','Unable to build list of deleted records');
   end
   else if Ecode <> 0 then
      PromptOK(' Warning ','To many delete records to display them all');
   BuildList := List.TotalNodes > 0;
end; { BuildList }

function TaggedNodes: longint;
{}
var I, X: longint;
begin
   I := 0;
   for X := 1 to List.TotalNodes do
      inc(I,ord(SLLGetTagState(X)));
   TaggedNodes := I;
end;

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}

procedure HindHook(CurrentField:byte;var Refresh:byte);
{}
var On: boolean;
begin
   if (List.TotalNodes > 0) then
   begin
      On := (TaggedNodes <> 0);
      FieldSetState(3, gActiveState(ord(On)));
      FieldSetState(4, gActiveState(ord(On)));
   end;
   Refresh := RefreshAll;
end; { HindHook }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure BuildForm;
{}
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   SetFormWindow(5,3,75,23,2);
   WinSetTitle(FormWinNum,' List of Deleted Records ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   AssignHindHook(HindHook);
   KwikAddField(1, 5,2); { list field }
   KwikAddField(2, 6,18); { button field }
   KwikAddField(3, 15,18); { buttonfield }
   KwikAddField(4, 40,18); { button field }
   KwikAddLastField(5, 54,18); { button field }
   ListAssignSLL(ListDetails,List);
   WrapListField(1,60,1,15,ListDetails);
   ButtonDefaultField(2,'~T~ag',Stop1);
   ButtonField(3,'~U~nTag',Stop2);
   ButtonField(4,'Un~d~elete',Stop3);
   ButtonField(5,'  ~Q~uit  ',Finished);
   SetHK(2,276); {alt-T}
   SetHK(3,278); {alt-U}
   SetHK(4,288); {alt-D}
   SetHK(5,272); {alt-Q}
end; { BuildForm }

procedure SetVars;
{}
begin
   RadioFldVar := 2;
   ListFldVar := 1;
   InitSLLStr(List);
end; { SetVars }

begin
   SetScreen;
   SetVars;
   MouseShow(true);
   CursorOff;
   Handle := DbOpenDataSet(FN);
   if Handle > 0 then
   begin
      InitListCfg(ListDetails);
      ListSetTagging(ListDetails, true);
      DbSetFullStrings(true);
      if BuildList then
      begin
         BuildForm;
         repeat
            Choice := EditForm(1);
            case Choice of
               Stop1: SetTag(ListDetails,true);
               Stop2: SetTag(ListDetails,false);
               Stop3: begin
                         for X := 1 to List.TotalNodes do
                            if SLLGetTagState(X) then
                               DbUnDeleteRecord(StrToLong(
                                  Strip('A',' ',copy(SLLGetStr(X),1,5))));
                         SLLDelAllStatus(TagBit,true);
                         if (List.TotalNodes = 0) then
                            Choice := Finished;
                      end;
            end;
         until (Choice in [Finished,Escaped]);
      end;
      SLLSetActiveList(List);
      SLLDestroy;
   end
   else
      PromptOK(' ERROR ','Unable to open '+FN);
   MouseShow(false);
   ResetStartUpMode;
end.
