{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDATE2.PAS
              Demonstrates some capabilities of the GOLDDATE UNIT.
}

program DEMDATE2;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldCal, GoldDate, GoldMisc, GoldReal,
          GoldHard, GoldKey, GoldIO, GoldIO2, GoldIO3, GoldStr, GoldWin;

var
  TestVar: dates;
  Msg: string;
  DVar,MVar,YVar: longint;
  Action: gAction;

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,RedOnLightGray);
   WriteCenter(1,UseTint,'TTT Gold');
   ClearLine(25,BlackOnLightGray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure SetVars;
{Sets the default values for the fields}
begin
   TestVar := TodayInJul;
   DVar := 0;
   MVar := 0;
   YVar := 0;
end; { SetVars }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}

procedure MyDateHook(CurrentField:byte;var Refresh:byte);
{}
begin
   PartClear(4,9,56,9,BlackOnLightGray,' ');
   WriteBetween(3,57,9,BlackOnLightGray,'The relative date is: '+
   FancyDateStr(StrToJul(RelativeDateYMD(JulToStr(TestVar,MMDDYY),MMDDYY,YVar,MVar,DVar),MMDDYY),true,true));
end; { MyDateHook }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SetFields;
{Defines the form by postioning the fields, linking the fields to
 variables, and adding labels, hotkeys and messages}
begin
   CreateForms(1);
   ActivateForm(1);
   SetFormWindow(10,5,71,19,1);
   WinSetTitle(FormWinNum,'  DATE RELATIVITY DEMO  ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   ActivateWindow(FormWinNum);
   WinDisplay(FormWinNum);
   Box3D(2,8,58,10,WhiteOnLightGray,BlackOnLightGray,1);
   WriteAT(8,6,BlackOnLightGray,'[ adjust the relative Years, Months, and Days ]');
   {all the field, label and message coordinates are now relative
    to the top left corner of the window pane}
   KwikAddField(1,37,2);
   KwikAddField(2,12,4);
   KwikAddField(3,31,4);
   KwikAddField(4,47,4);
   KwikAddField(5,30,12);
   KwikAddLastField(6, 43,12);
   AssignHindHook(MyDateHook);
   {define each field}
   SpinDropDateField(1, TestVar, MMDDYY, '',0,0);
   SetLabel(1, LabelLeft,LabelLeft,'~E~nter the starting date');
   SetHK(1,274);
   SpinLongField(2,YVar,5,0,0,1);
   SetLabel(2,LabelLeft,LabelLeft,'Years');
   SpinLongField(3,MVar,5,0,0,1);
   SetLabel(3,LabelLeft,LabelLeft,'Months');
   SpinLongField(4,DVar,5,0,0,1);
   SetLabel(4,LabelLeft,LabelLeft,'Days');
   ButtonDefaultField(5,WinVars.OKButStr,Finished);
   ButtonField(6,WinVars.CancelButStr,Escaped);
   {buttons}
end; { SetFields }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetVars;
   SetFields;
   MouseShow(true);
   Action := EditForm(1);
   if Action = Finished then
      Msg := '^The relative date is:||^'+
    FancyDateStr(StrToJul(RelativeDateYMD(JulToStr(TestVar,MMDDYY),MMDDYY,YVar,MVar,DVar),MMDDYY),true,true)
   else
      Msg := 'You choose to leave!';
   PromptOK(' Result ',Msg);
   DisposeFormWin;
   DisposeFields;
   DisposeForms;
   MouseShow(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
