{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMBRS4.PAS
              Shows how to display a text file in a browse window and
              have certain lines displayed in a secondary color.
}

Program DEMBRS4;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast,  GoldList, GoldKey, GoldDir,
          GoldWin, GoldLink, GoldStr;

var
  Filename:string;

   procedure SetScreen;
   {}
   begin
      Clear(BlueOnLightRed,' ');
      ClearLine(1,YellowOnLightBlue);
      WriteCenter(1,0,' Browsing Gold-Style ');
      ClearLine(25,BlackOnYellow);
      WriteCenter(25,0,'Press ESC to finish...');
   end; { SetScreen }

   procedure HighlightLine(var DLL:DoubleLL; Str:string; caseSens: boolean);
   {for fun, highlight everyline with contais the substring STR}
   var
      NodePtr: DoubleNodePtr;
      LineCount: string[10];
      Counter: Longint;
      P: byte;
      TempStr: string;
   begin
      GrowMkWin(20,10,60,13,whiteonBlue,4);
      WriteCenter(11,0,'Scanning File');
      LineCount := IntToStr(DLL.TotalNodes);
      NodePtr := DLL.StartNodePtr;
      Counter := 0;
      while NodePtr <> nil do
      begin
         inc(Counter);
         WriteCenter(12,0,'Processing line '+IntToStr(Counter)+' of '+LineCount);
         TempStr := DLLGetNodeStr(NodePtr,0,0);
         if CaseSens then
            P := pos(Str,TempStr)
         else
            P := pos(SetUpper(Str),SetUpper(TempStr));
         if P > 0 then
            DLLSetBit(NodePtr,Colbit,true);
         NodePtr := NodePtr^.NextPtr;
      end;
      RmWin;
   end; {HighlightLine}

   procedure DisplayTheFile;
   {}
   var
      Settings: ListCfg;
      DLL: DoubleLL;
      gResult: integer;
   begin
      {First fill the linked list with the file contents}
      InitDLLStr(DLL);
      DLLSetActiveList(DLL);
      gResult := DLLLoadFromFile(Filename);
      if gResult = 0 then
      begin
         HighLightLine(DLL,'procedure',true);
         HighLightLine(DLL,'function',true);
         {set the state of the browse record}
         InitListCfg(Settings);
         ListAssignDLL(Settings,DLL);
         ListSetWin(Settings,1,2,80,24,1);
         ListSetTwoColors(Settings,True);
         CursorOff;
         RunBrowse(Settings,' Browsing '+FileName);
         CursorOn;
      end
      else
         PromptOK(' Error ','Unable to load the file');
      DLLDestroy;
   end; { DisplayTheFile }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetBlinking(false);
   SetScreen;
   MouseShow(true);
   KeySetFast;
   FileName := FileList('*.pas',' Pick a Pascal file ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      DisplayTheFile;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
