{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {**********************************}
                    {**       Unit:   GOLDMISC       **}
                    {**********************************}

{++++++++++++++++++++++++++++++} unit GOLDMISC;{+++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDMISC}
   {$DEFINE GOLDMISC}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

Uses CRT, DOS, GoldStr;

const
   Illegal: string[15] = ' +=/[]":;,?*<>|';

type
   ErrMsgFunc = function (Ecode:integer):string;

   gCoords = record
      X1,Y1,X2,Y2:shortint;
   end;

   gByteCoords = record
      X1,Y1,X2,Y2:byte;
   end;

   MiscSet = record
      ECode: integer;
      GoldMemBuffer: longint;
      StartMem: longint;
      HeapIsRecorded,
      BeepOn: boolean;
      LPTport:byte;     {0=lpt1, 1=lpt2, 2=lpt3}
      StartTop,      {used to record initial screen state when program is run}
      StartBot: byte;
      StartMode: word;
      EMsgFunc: ErrMsgFunc;
      HeapCheckErrMsg: string[80];
   end;

var
   MiscVars: MiscSet;

function  LastMiscError: integer;
function  GetBitStatus(B:byte;BitPos:byte): boolean;
procedure SetBitStatus(var Val:byte; BitPos:byte; On:boolean);
function  GoldMaxAvail:longint;
function  GoldMemAvail:longint;
procedure Swap(var A,B:longint);
function  WithinRange(Min,Max,Test: longint): boolean;
function  OnBorder(X1,Y1,X,Y,Width,Depth:integer):boolean;
function  WithinBorder(X1,Y1,X,Y,Width,Depth:integer):boolean;
procedure Beep;
procedure Ding;
procedure Thunk;
procedure Trill;
function  FSize(Filename:string): longint;
function  FileDrive(Full:string): string;
function  FileExt(Full:string): string;
function  SlashedDirectory(Dir:string):string;
function  ParentDirectory(Dir:string): string;
function  FileDirectory(Full:string): string;
function  SmartMakeDir(DirectStr: PathStr): integer;
function  FileName(Full:string): string;
function  Exist(Filename:string):boolean;
function  DeleteFile(Filename:string): shortint;
function  RenameFile(Oldname,NewName:string):shortint;
function  CopyFile(SourceFile, TargetFile:string): shortint;
function  PrinterStatus:byte;
function  AlternatePrinterStatus:byte;
function  PrinterReady :boolean;
procedure ResetPrinter;
procedure PrintScreen;
function  ParamLine: String;
function  ParamVal(Marker:string): string;
function  Frequency(Match:string;Source:string): byte;
function  BadCharPos(Str:string): integer;
function  ValidFileName(FN:string): shortint;
function  RunEXECOM(Progname, Params: string):integer;
function  RunDOS(Msg:string):integer;
function  RunAnything(Command: string):integer;
function  GetMin(Value1,Value2:longint): longint;
function  GetMax(Value1,Value2:longint): longint;
procedure HeapRecord;
procedure HeapCheck;

{$IFDEF TTT5}

function  File_Size(Filename:string): longint;
function  File_Drive(Full:string): string;
function  File_Directory(Full:string): string;
function  File_Name(Full:string): string;
function  File_Ext(Full:string): String;
function  Printer_Status:byte;
function  Alternate_Printer_Status:byte;
function  Printer_ready:boolean;
procedure Reset_Printer;

{$ENDIF}

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}
{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}

function MiscEMsg(ECode:integer): string;
{}
begin
   case Ecode of
      1001: MiscEMsg := 'Invalid drive passed to SmartMakeDir';
      1002: MiscEMsg := 'Failure changing directories';
      1003: MiscEMsg := 'Failure making directories';
      else
         MiscEMsg := 'Internal Misc error';
   end; {case}
end; { MiscEMsg }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure MiscSetError(ECode:integer);
{}
{$IFOPT D+}
var Ch: char;
    Msg: string;
{$ENDIF}
begin
   MiscVars.Ecode := ECode;
{$IFOPT D+}  {if debug active display an error message and terminate}
   if Ecode <> 0 then
   begin
      str(Ecode,Msg);
      Msg := Msg+': '+MiscVars.EMsgFunc(Ecode);
      writeln(' GoldMisc Error - ',Msg);
      Ch := ReadKey;
      if Ch = #27 then
         Halt;
   end;
{$ENDIF}
end; { MiscSetError }

function LastMiscError: integer;
{}
begin
   LastMiscError := MiscVars.ECode;
end; { LastMiscError }

procedure Swap(var A,B:longint);
{}
var Temp: longint;
begin
   Temp := A;
   A := B;
   B := Temp;
end; { Swap }

function WithinRange(Min,Max,Test: longint): boolean;
{}
begin
   if Min > Max then
      Swap(Min,Max);
   WithinRange := (Test >= Min) and (Test <= Max);
end; { WithinRange }

function GetBitStatus(B:byte;BitPos:byte): boolean;
{}
begin
   if BitPos > 7 then
      GetBitStatus := false
   else
   begin
     B := B SHR BitPos; {move to end bit}
     GetBitStatus := odd(B);
   end;
end; { GetBitStatus }

procedure SetBitStatus(var Val:byte; BitPos:byte; On:boolean);
{}
var Test: integer;
begin
   if BitPos <= 7 then
   begin
      if On then
      begin
         Test := 1 SHL BitPos;
         Val := Val or Test
      end else
      begin
         Test := not (1 SHL BitPos);
         Val := Val and Test;
      end;
   end;
end; { SetBitStatus }

function GoldMaxAvail:longint;
{}
begin
   GoldMaxAvail := MaxAvail - MiscVars.GoldMemBuffer;
end; { GoldMaxAvail }

function GoldMemAvail:longint;
{}
begin
   GoldMemAvail := MemAvail - MiscVars.GoldMemBuffer;
end; { GoldMemAvail }

function OnBorder(X1,Y1,X,Y,Width,Depth:integer):boolean;
{}
begin
   OnBorder := ( ((X1 >= X) and (X1 < X + Width))
                  and
                 ((Y1 = Y) or (Y1 = pred(Y+Depth)))
               )
               or
               ( ((Y1 >= Y) and (Y1 < Y + Depth))
                 and
                 ((X1 = X) or (X1 = pred(X+Width)))
               );
end; { OnBorder }

function WithinBorder(X1,Y1,X,Y,Width,Depth:integer):boolean;
{}
begin
   WithinBorder := ((X1 >= X) and (X1 < X + Width))
                   and
                   ((Y1 >= Y) and (Y1 < Y + depth));
end; { WithinBorder }

procedure Beep;
{}
begin
   if MiscVars.BeepOn then
   begin
      sound(800);delay(150);
      sound(600);delay(100);
      nosound;
   end;
end; { Beep }

procedure DING;
begin
   if MiscVars.BeepOn then
   begin
      sound(2000);delay(100);nosound;
   end;
end; { Ding }

procedure Thunk;
{}
begin
   if MiscVars.BeepOn then
   begin
      sound(100);delay(150);
      sound(250);delay(10);
      nosound;
   end;
end; { Thunk }

procedure Trill;
{}
begin
   if MiscVars.BeepOn then
   begin
      sound(880); delay(100);
      sound(1320); delay(100);
      sound(1760); delay(100);
      sound(2200); delay(100);
  nosound;
   end;
end; { Trill }


function CopyFile(SourceFile, TargetFile:string): shortint;
{return codes:  0 successful
                1 source and target the same
                2 cannot open source
                3 unable to create target
                4 error during copy
}
var Source,
    Target: file;
    BRead,
    Bwrite: word;
    FileBuf: array[1..2048] of char;
begin
   if SourceFile = TargetFile then
      CopyFile := 1
   else
   begin
      assign(Source,SourceFile);
      {$I-}
      reset(Source,1);
      {$I+}
      if IOResult <> 0 then
          CopyFile := 2
      else
      begin
         Assign(Target,TargetFile);
         {$I-}
         Rewrite(Target,1);
         {$I+}
         if IOResult <> 0 then
            CopyFile := 3
         else
         begin
            repeat
              blockread(Source,FileBuf,SizeOf(FileBuf),BRead);
              blockwrite(Target,FileBuf,Bread,Bwrite);
            until (Bread = 0) or (Bread <> BWrite);
            close(Source);
            close(Target);
            if Bread <> Bwrite then
               CopyFile := 4
            else
               CopyFile := 0;
         end;
      end;
   end;
end; { CopyFile }

function FSize(Filename:string): longint;
{returns  -1   if file not found}
var FileInfo: SearchRec;
begin
   Findfirst(Filename,anyfile,FileInfo);
   if DOSError = 0 then
      FSize := FileInfo.Size
   else
      FSize := -1;
end; { FSize }

function FileSplit(Part:byte;Full:string): string;
{used internally}
var D: DirStr;
    N: NameStr;
    E: ExtStr;
begin
   FSplit(Full,D,N,E);
   Case Part of
      1: FileSplit := D;
      2: FileSplit := N;
      3: FileSplit := E;
   end;
end; { FileSplit }

function FileDirectory(Full:string): string;
{}
var Temp: string;
    P: byte;
begin
   Temp := FileSplit(1,Full);
   P := Pos(':',Temp);
   if P = 2 then
      Delete(Temp,1,2);                 {remove drive}
   if (Temp[length(Temp)]  ='\') and (temp <> '\') then
      Delete(temp,length(Temp),1);      {remove last backslash}
   FileDirectory := Temp;
end; { FileDirectory }

function SmartMakeDir(DirectStr: PathStr): integer;
{creates multi-level subdirectories}
var I, P: byte;
    Drv, Dir, SavedPath: PathStr;
begin
   SmartMakeDir := 1;
   getdir(0,SavedPath);
   if DirectStr[2] = ':' then
   begin
      Drv := copy(DirectStr,1,2);
      {$I-} chdir(Drv); {$I+}
      if IOResult <> 0 then
      begin
         MiscSetError(1001); { invalid drive passed to MakeDir }
         chdir(SavedPath);
         exit;
      end;
      delete(DirectStr,1,2);
   end
   else
     Drv := copy(SavedPath,1,2);
   if DirectStr[1] = '\' then
   begin
      {$I-} chdir(Drv+'\'); {$I+}
      if IOResult <> 0 then
      begin
         MiscSetError(1002); { Failure changing directories }
         chdir(SavedPath);
         exit;
      end;
      delete(DirectStr,1,1);
   end;
   if DirectStr[length(DirectStr)] <> '\' then
      DirectStr := DirectStr + '\';
   while length(DirectStr) > 0 do
   begin
      P := pos('\',DirectStr);
      Dir := copy(DirectStr,1,pred(P));
      delete(DirectStr,1,P);
      {$I-} chdir(Dir); {$I+}
      if IOResult <> 0 then  { if it doesn't exist then make it }
      begin
         {$I-} mkdir(Dir); {$I+}
         if IOResult <> 0 then
         begin
            MiscSetError(1003); { Failure making directories }
            chdir(SavedPath);
            exit;
         end
         else
         begin
           {$I-} chdir(Dir); {$I+}  { then change to it }
           if IOResult <> 0 then
           begin
              MiscSetError(1002); { Failure changing directories }
              chdir(SavedPath);
              exit;
           end;
        end;
      end;
   end;
   {$I-} chdir(SavedPath); {$I+}
   if IOResult <> 0 then     ;
      { Set error }
   SmartMakeDir := 0;
end; { SmartMakeDir }

function FileName(Full:string): string;
{}
begin
   FileName := FileSplit(2,Full);
end; { FileName }

function FileExt(Full:string): string;
{}
var Temp: string;
begin
   Temp := FileSplit(3,Full);
   if (Temp = '') or (Temp = '.') then
      FileExt := temp
   else
      FileExt := copy(Temp,2,3);
end; { FileExt }

function SlashedDirectory(Dir:string):string;
{}
begin
   if (Dir = '') or (Dir[length(Dir)] in [':','\']) then
      SlashedDirectory := Dir
   else
      SlashedDirectory := Dir + '\';
end; { SlashedDirectory }

function ParentDirectory(Dir:string): string;
{}
var L:byte;
begin
   L := length(Dir);
   if L < 4 then
      ParentDirectory := Dir
   else
   begin
      if Dir[L] = '\' then
         delete(Dir,L,1);
      L := lastPos('\',Dir);
      if L = 0 then
         L := pos(':',Dir);
      if L = 0 then
         ParentDirectory := ''
      else
         ParentDirectory := copy(Dir,1,pred(L));
   end;
end; { ParentDirectory }

function FileDrive(Full:string): string;
{}
var Temp: string;
    P: byte;
begin
   Temp := FileSplit(1,Full);
   P := Pos(':',Temp);
   if P <> 2 then
      FileDrive := ''
   else
      FileDrive := upcase(Temp[1]);
end; { FileDrive }

function Exist(Filename:string):boolean;
{returns true if file exists}
var Inf: SearchRec;
begin
  findfirst(Filename,AnyFile,Inf);
  Exist := (DOSError = 0);
end;  { Exist }

function DeleteFile(Filename:string): shortint;
{Return codes:   -1    File not found
                  0    File deleted
                  1    Error - file not deleted.

}
var F: file;
begin
   if not Exist(Filename) then
      DeleteFile := -1
   else
   begin
      assign(F,Filename);
      {$I-}
      Erase(F);
      {$I+}
      if ioresult = 0 then
         DeleteFile := 0
      else
         DeleteFile := 1;
   end;
end; { DeleteFile }

function RenameFile(Oldname,NewName:string):shortint;
{Retcodes:     0 file renamed
               1 file not found
               2 rename failed
}
var F:file;
begin
   if not exist(OldName) then
      RenameFile := 1
   else
   begin
      assign(F,Oldname);
      {$I-}
      Rename(F,Newname);
      {$I+}
      if ioresult = 0 then
         RenameFile := 0
      else
         RenameFile := 2;
   end;
end; { RenameFile }

function PrinterStatus:byte;
{Credits: Robert W. Lewis, VA thanks! Special masking employed for non-
          standard printers, e.g. daisy wheels!!! }
var Recpack : registers;
begin
   with Recpack do
   begin
      Ah := 2;
      Dx := MiscVars.LPTport;
      intr($17,recpack);
      if (Ah and $B8) = $90 then
         PrinterStatus := 0        {all's well}
      else if (Ah and $20) = $20 then
         PrinterStatus := 1        {no Paper}
      else if (Ah and $10) = $00 then
         PrinterStatus := 2        {off line}
      else if (Ah and $80) = $00 then
         PrinterStatus := 3        {busy}
      else if (Ah and $08) = $08 then
         PrinterStatus := 4;       {undetermined error}
   end;
end; { PrinterStatus }

function AlternatePrinterStatus:byte;
{}
var Recpack: registers;
begin
   with recpack do
   begin
      Ah := 2;
      Dx := MiscVars.LPTport;
      intr($17,recpack);
      if (Ah and $20) = $20 then
         AlternatePrinterStatus := 1  {no Paper}
      else if (Ah and $10) = $00 then
            AlternatePrinterStatus := 2  {off line}
      else if (Ah and $80) = $00 then
            AlternatePrinterStatus := 3  {busy}
      else if (Ah and $08) = $08 then
            AlternatePrinterStatus := 4  {undetermined error}
      else
          AlternatePrinterStatus := 0    {all's well}
   end;
end; { AlternatePrinterStatus }

function PrinterReady :boolean;
{}
begin
   PrinterReady := (PrinterStatus = 0);
end; { PrinterReady }

procedure ResetPrinter; {1.1}
{}
var address: ^integer;
    portno,delay: integer;
begin
{$IFDEF DPMI}
   address := ptr(seg0040,$0008);
{$ELSE}
   address := ptr($0040,$0008);
{$ENDIF}
   portno := address^ + 2;
   port[portno] := 232;
   for delay := 1 to 2000 do {nothing};
   port[portno] := 236;
end; { ResetPrinter }

procedure PrintScreen;
{}
var Regpack: registers;
begin
   intr($05,regpack);
end; { PrintScreen }

{IMPORTANT NOTE: You must use the $M compiler directive to instruct Turbo
Pascal to leave some memory for the spawned or child program, e.g.
$M $8192,$8192,$8192. The precise values depend on the size of your program
..experiment. If the child process runs OK, try smaller values.}

function RunAnything(command: string):integer;
{}
var Comspec:string;
begin
   Comspec := GetEnv('COMSPEC');
   swapvectors;
   exec(comspec,'/C '+command);
   SwapVectors;
   RunAnything := doserror;
end; { RunAnything }

function RunEXECOM(Progname, Params: string): integer;
{}
begin
   swapvectors;
   exec(Progname,Params);
   swapvectors;
   RunEXECOM := doserror;
end; { RunEXECOM }

function RunDOS(Msg:string):integer;
{}
var Comspec:string;
begin
   Comspec := GetEnv('COMSPEC');
   swapvectors;
   writeln;
   writeln(Msg);
   exec(comspec,'');
   SwapVectors;
   RunDOS := doserror;
end; { RunDOS }

function ParamLine: String;
{returns the command line as a space delimited string}
var I: integer;
    P: integer;
    Line: string;
begin
   Line := '';
   P := ParamCount;
   if P > 0 then
      for I := 1 to P do
          Line := Line + ParamStr(I) + ' ';
   ParamLine := Line;
end; { ParamLine }

function ParamVal(Marker:string): string;
{searches for Marker in string and returns the characters following}
var ValStr,
    Line: string;
    Loc1, Loc2: integer;
begin
   Line := ParamLine;
   ValStr := '';
   if Line <> '' then
   begin
      Loc1 := pos(SetUpper(Marker),SetUpper(Line));
      if Loc1 = 0 then {not found}
         ValStr := ''
      else
      begin
         Loc1 := Loc1 + length(Marker);
         if (Loc1 > Length(Line))
         or (Line[Loc1] = Marker[1]) then
            ValStr := ''
         else
         begin
            Loc2 := Loc1;
            repeat
               inc(Loc2)
            until (Line[Loc2] = Marker[1])
               or (Loc2 > length(Line));
            ValStr := Copy(Line,Loc1,Loc2-Loc1);
         end;
      end;
   end;
   ParamVal := ValStr;
end; { ParamVal }

function Frequency(Match:string;Source:string): byte;
{returns the number of times that Match occurs in SOURCE}
var Len,Loc, Counter: byte;
begin
   Counter := 0;
   Len := Length(match);
   if (Len <> 0) and (length(Source) > 0) then
      repeat
         Loc := pos(Match,Source);
         if Loc <> 0 then
         begin
            inc(Counter);
            delete(Source,Loc,length(Match));
         end;
      until Loc = 0;
   Frequency := Counter;
end; { Frequency }

function BadCharPos(Str:string): integer;
{Pass either a path or file+ext}
var I: integer;
begin
   with MiscVars do
   begin
      BadCharPos := 0;
      for I := 1 to length(Str) do
         if pos(Str[I],Illegal) <> 0 then
         begin
            BadCharPos := I;
            exit;
         end;
   end;
end; { BadCharPos }

function ValidFileName(FN:string): shortint;
{Validates a file path and name and returns following
 codes:
          -2     Valid path, but no file specified
          -1     Path and name OK but file does not exist
           0     Path and name OK and file exists
           1     Illegal drive specifier
           2     Illegal characters in path
           3     Invalid Path
           4     No file specified
           5     Illegal Characters in name
           6     Name longer than eight characters
           7     Extension longer than three characters
}
var ECode: shortint;
    OldDIR,D,P,F,E: string;
    Loc: byte;
    Inf: SearchRec;                                {1.00b}

    function Legal(Str:string;AllowSlash:boolean): boolean;
    {}
    var I: integer;
    begin
       Legal := BadCharPos(Str) = 0;
       if not AllowSlash then
          if pos('\',Str) > 0 then
             legal := false;
    end;

begin
   ECode := 0;
   Loc := pos(':',FN);
   if Loc = 0 then
   begin
      D := '';
      P := FN;
   end else
   begin
      D := SetUpper(copy(FN,1,Loc));
      P := copy(FN,succ(Loc),255);
      if (Loc <> 2) or ((D[1] in ['A'..'Z'])=false) then
      begin
         ValidFileName := 1;
         exit;
      end;
   end;
   Loc := LastPos('\',P);
   if Loc = 0 then
   begin
      F := P;
      P := '';
   end else
   begin
      F := copy(P,succ(Loc),255);
      P := copy(P,1,pred(Loc));
   end;
   Loc := pos('.',F);
   if Loc = 0 then
      E := ''
   else
   begin
      E := copy(F,succ(Loc),255);
      F := copy(F,1,pred(Loc));
   end;
   if not legal(P,true) then
      Ecode := 2
   else
   begin
      if D+P <> '' then
      begin
         GetDir(0,OldDir);
         {$I-}
         ChDir(D+P);
         {$I+}
         if IOResult <> 0 then
         begin
            ValidFileName := 3;
            ChDir(OldDir);  {1.00d}
            exit;
         end else
            ChDir(OldDir);
      end;
      if (F='') and (E='') then
         Ecode := 4
      else
      begin
         if not Legal(F+E,false) then
            Ecode := 5
         else
         begin
            if length(F) > 8 then
               Ecode := 6
            else if length(E) > 3 then
               Ecode := 7;
         end;
      end;
   end;
   if Ecode = 0 then
   begin
      if not Exist(FN) then
         ECode := -1
      else
      begin
         findfirst(FN,Directory,Inf);
         if (DOSError <> 0) or ((DOSError = 0) and (Inf.Attr = Directory)) then
            ECode := -2;
      end
   end;
   ValidFileName := Ecode;
end; { ValidFileName }

function GetMin(Value1,Value2:longint): longint;
{returns the smallest of two Values}
begin
   if Value1 > Value2 then
      GetMin := Value2
   else
      GetMin := Value1;
end; { GetMin }

function GetMax(Value1,Value2:longint): longint;
{returns the larger of two Values}
begin
   if Value1 > Value2 then
      GetMax := Value1
   else
      GetMax := Value2;
end; { GetMax }

procedure HeapRecord;
{}
begin
   with MiscVars do
   begin
      MiscVars.StartMem := MemAvail;
      HeapIsRecorded := true;
   end;
end; { HeapRecord }

procedure HeapCheck;
{}
var Ch: char;
begin
   with MiscVars do
   begin
      if MemAvail <> MiscVars.StartMem then
      begin
         ClrScr;
         if HeapIsRecorded then
         begin
            writeln('MEMORY ERROR - Starting Free memory: ',MiscVars.StartMem);
            writeln('             - Current  Free memory: ',MemAvail);
            writeln('                              delta: ',MiscVars.StartMem - MemAvail);
            writeln('Press any key ...');
            ch := Readkey;
            halt(99);
         end else
         writeln(HeapCheckErrMsg);
      end;
      HeapIsRecorded := false;
   end;
end; { HeapCheck }

              {*********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N  **}
              {*********************************************}
procedure MiscDefaultSettings;
{}
begin
   with MiscVars do
   begin
      GoldMemBuffer := 10000;
      HeapIsRecorded := false;
      BeepOn := true;
      LPTport := 0;  {LPT1}
      HeapCheckErrMsg := 'HeapCheck ERROR! - Heap was not previously recorded.';
   end;
end; { MiscDefaultSettings }


procedure GoldMiscInit;
{}
begin
   with MiscVars do
   begin
      ECode := 0;
      EMsgFunc := MiscEMsg;
   end;
   MiscDefaultSettings;
end; { GoldMiscInit }

{$IFDEF TTT5}

function  File_Size(Filename:string): longint;
{included for TTT5 compatibility}
begin
   File_Size := FSize(Filename);
end; { FIle_Size }

function  File_Drive(Full:string): string;
{included for TTT5 compatibility}
begin
   File_Drive := FileDrive(Full);
end; { File_Drive }

function  File_Directory(Full:string): string;
{included for TTT5 compatibility}
begin
   File_Directory := FileDirectory(Full);
end; { File_Directory }

function  File_Name(Full:string): string;
{included for TTT5 compatibility}
begin
   File_Name := FileName(Full);
end; { File_Name }

function  File_Ext(Full:string): String;
{included for TTT5 compatibility}
begin
   File_Ext := FileExt(Full);
end; { File_Ext }

function  Printer_Status:byte;
{included for TTT5 compatibility}
begin
   Printer_Status := PrinterStatus;
end; { Printer_Status }

function  Alternate_Printer_Status:byte;
{included for TTT5 compatibility}
begin
   Alternate_Printer_Status := AlternatePrinterStatus;
end; { Alternate_Printer_Status }

function  Printer_ready:boolean;
{included for TTT5 compatibility}
begin
   Printer_Ready := PrinterReady;
end; { Printer_ready }

procedure Reset_Printer;
{included for TTT5 compatibility}
begin
   ResetPrinter;
end; { Reset_Printer }

{$ENDIF}

begin
   GoldMiscInit;
end.
