{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMRD11.PAS
              Customizes the prompt colors
}

program DemRd11;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldAttr, GoldStr, GoldMisc, GoldTint,
     GoldFast, GoldRead, GoldIO, GoldWin, GoldKey;

var TmpMsg, TmpStr: string;

procedure SetScreen;
{}
begin
   Clear(WhiteOnCyan,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,UseTint,' Demo of PromptStr from GOLDREAD ');
   WriteAt(1,2,BlueOnRed,replicate(80,''));
   WriteAT(70,2,WhiteOnBlack,'TTT Gold!');
   ClearLine(25,YellowOnBlue);
end; { SetScreen }

procedure CustomizeColors;
{}
begin
   GoldSetColor(PromptBorder1,LightRedOnRed);
   GoldSetColor(PromptBorder2,LightRedOnRed);
   GoldSetColor(PromptTitle,WhiteOnRed);
   GoldSetColor(PromptBody,LightGrayOnRed);
   GoldSetColor(PromptButtonHiHot,WhiteOnMagenta);
   GoldSetColor(PromptButtonHi,YellowOnMagenta);
   GoldSetColor(PromptButtonNormHot,YellowOnMagenta);
   GoldSetColor(PromptButtonNorm,LightgrayOnMagenta);
   GoldSetColor(PromptButtonDef,LightgrayOnMagenta);
   GoldSetColor(PromptButtonDefHot,LightcyanOnMagenta);
   GoldSetColor(PromptIcons,LightcyanOnRed);
   GoldSetColor(PromptBodyHi,WhiteOnRed);
   GoldSetColor(PromptNormalCmt,YellowOnRed);
   GoldSetColor(PromptHiCmt,WhiteOnRed);
   GoldSetColor(PromptEditErase,WhiteOnGreen);
   GoldSetColor(PromptEditNorm,LightGrayOnMagenta);
   GoldSetColor(PromptEditHi,WhiteOnMagenta);
end; { CustomizeColors }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   ClrScr;
   SetScreen;
   MouseShow(true);
   CustomizeColors;
   TmpStr := PromptStr(0,5,29,'^Enter User Name',' Ugly Input Demo ','Sheeba',true);
   if ReadVars.LastAction = Escaped then
      TmpMsg := 'You choose to leave!'
   else if Strip('A',' ',TmpStr) = '' then
      TmpMsg := 'You didn''t make an entry'
   else
      TmpMsg := 'You entered '+TmpStr;
   PromptOK(' PromptStr ',TmpMsg);
   MouseShow(false);
   clrscr;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
