{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMPMT2.PAS
              Illustrates how to customize the Prompt colors
              and then reinstate the defaults afterwards.
}

program DemPmt2;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldAttr, GoldMisc, GoldHard, GoldFast, GoldWin,
              GoldKey, GoldTint;

var
  Choice: byte;
  OldColors: TintSettings;

procedure CustomizeColors;
{}
begin
   GoldSetColor(PromptBorder1,LightRedOnRed);
   GoldSetColor(PromptBorder2,LightRedOnRed);
   GoldSetColor(PromptTitle,WhiteOnRed);
   GoldSetColor(PromptBody,LightGrayOnRed);
   GoldSetColor(PromptButtonHiHot,WhiteOnMagenta);
   GoldSetColor(PromptButtonHi,YellowOnMagenta);
   GoldSetColor(PromptButtonNormHot,YellowOnMagenta);
   GoldSetColor(PromptButtonNorm,LightgrayOnMagenta);
end; { CustomizeColors }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   Clear(WhiteOnBlack,'');
   OldColors := Tint;                 {save the current default colors}
   CustomizeColors;
   Choice := PromptOKCancel(' Confirmation ','Would you like to rebuild the|database index now?|');
   {if you don't want to reinstate the defaults, just comment out the
    next statement}
   Tint := OldColors;                   {Reinstate the default colors}
   if Choice = 1 then
      PromptOK('','You picked OK!')
   else
      PromptOK('','You picked Cancel!');
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DemPmt2 }
