{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMPLL1.PAS
              Shows how to single component pull down menu
}

program DEMPLL1;

{$I GOLDFLAG.INC}

uses DOS, CRT, GoldFast, GoldKey, GoldMenu, GoldAttr,
               GoldWin, GoldStr, GoldMisc, GoldTint;

var
   MainMenu: Bar;
   SubMenu: PopUp;
   Choice: integer;

procedure DefineSubMenu;
{}
begin
   InitPopUp(SubMenu);
   PopUpAddItem(SubMenu,'~N~ew',101,78,'Create a new file in a new Edit window',nil);
   PopUpAddItem(SubMenu,'~O~pen',102,79,'Locate and open in an Edit window',nil);
   PopUpAddItem(SubMenu,'~S~ave',103,83,'Save the file in the active Edit window',nil);
   PopUpAddItem(SubMenu,'Save ~a~s...',104,65,'Save the current file under a differennt name directory or drive',nil);
   PopUpAddItem(SubMenu,'Save a~l~l',105,76,'Save all modified files',nil);
   PopUpAddItem(SubMenu,'-',0,0,'',nil); {separator}
   PopUpAddItem(SubMenu,'~C~hange dir...',106,67,'Choose a new default directory',nil);
   PopUpAddItem(SubMenu,'~P~rint',107,80,'Print the contents of the active Edit window',nil);
   PopUpAddItem(SubMenu,'P~r~inter setup',108,82,'Choose printer filter to use for printing',nil);
   PopUpAddItem(SubMenu,'~D~os shell',109,68,'Temporily exit to DOS',nil);
   PopUpAddItem(SubMenu,'E~x~it',110,88,'~Exit~ Turbo Pascal',nil);
end; { DefineSubMenu }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~F~ile',100,70,289,'File management commands (open, new, etc).',@SubMenu);
end; { DefineMainMenu }

procedure SetScreen;
{Paints the background}
begin
   FBox(1,2,80,24,LightgrayOnBlue,1);
   ClearLine(1,BlackOnLightgray);
   ClearLine(25,BlackOnLightgray);
   WriteCenter(2,usetint,' Make a menu choice, or press Esc ');
end; {SetScreen}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineSubMenu;
   DefineMainMenu;
   SetScreen;
   DrawBar(MainMenu);
   MouseShow(true);
   Choice := ActivatePullmenu(MainMenu);
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
   if Choice = 0 then
      PromptOK(' Gold ','You escaped!')
   else
      PromptOK(' Gold ','You chose menu ID '+IntToStr(Choice));
   MouseShow(false);
   clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DemPll1 }
