{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMOVIEW.PAS
              A desktop application for viewing the description of
              each of the demo files and optionally browsing the
              source code.
}

program DemoView;

uses DOS, CRT, GoldFast, GoldWin, GoldMenu, GoldMisc, GoldKey,
     GoldAttr, GoldStr, GoldLink, GoldList, GoldGrid, GoldDesk;

const Mask: string[12] = 'DEM*.pas';
      DT = 1;

var
   DemoList: DoubleLL;
   DemoListDetails: ListCfg;
   FName: string[14];
   Desc: string;
   TotalMatches: integer;
   TabStops: array[1..4] of integer;
   Heading: string;
   FileMenu,WinMenu: PopUp;
   MainMenu,StatusBar:Bar;
   Action : dAction;
   FirstHindCall,
   FirstHookCall: boolean;

procedure SetScreen;
{}
begin
   Clear(LightGrayOnBlue,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,UseTint,'TechnoJock Software, Inc.');
end; {SetScreen}

                         {***********************}
                         {**  Read Demo Files  **}
                         {***********************}

function BuildDescription(FileName: pathstr): integer;
{}
var InFile: text;
    I: integer;
    Line, Tmp1: string;
begin
   BuildDescription := 1;
   assign(InFile,FileName);
   {$I-} reset(InFile); {$I+}
   if IOResult <> 0 then
      exit;
   while not EOF(InFile) do
   begin
      readln(InFile,Line);
      if copy(Line,1,13) = '{Description:' then
      begin
         FName := PadLeft(SetUpper(Strip('A',' ',copy(Line,succ(pos(':',Line)),255))),14,' ');
         Tmp1 := '';
         readln(InFile,Line);
         while (pos('}',Line) = 0) and not EOF(InFile) do
         begin
            Tmp1 := Tmp1 + Strip('B',' ',Line)+' ';
            readln(InFile,Line);
         end;
         delete(Tmp1,length(Tmp1),1);
         Desc := Tmp1;
         if DLLAddStr(FName+Desc) = 0 then
            BuildDescription := 0;
         close(InFile);
         exit;
      end;
   end;
   BuildDescription := 0;
   close(InFile);
end; {BuildDescription}

procedure BuildFile;
{}
var SR: SearchRec;
    CurrentMatch: integer;
begin
   if TotalMatches > 0 then
   begin
      CurrentMatch := 0;
      Box3D(10,5,70,10,WhiteOnCyan,BlackOnCyan,4);
      WriteAT(14,6,BlueOnCyan,'Building List of descriptions...');
      findfirst(Mask,AnyFile,SR);
      while doserror = 0 do
      begin
         inc(CurrentMatch);
         WriteProgressLong(15,60,8,CurrentMatch,TotalMatches,true);
         delay(DT); { just so you can see whats going on }
         if BuildDescription(SR.Name) = 0 then
            FindNext(SR)
         else
            exit;
      end;
   end;
   WriteAT(14,6,BlueOnCyan,'Sorting Descriptions...                ');
   DLLSort(0,true);
   PartClear(10,5,70,10,LightGrayOnBlue,'');
end; {BuildFile}

procedure CountMatches;
{}
var SR: SearchRec;
begin
   TotalMatches := 0;
   findfirst(Mask,AnyFile,SR);
   while doserror = 0 do
   begin
      inc(TotalMatches);
      FindNext(SR)
   end;
end; {CountMatches}

                        {**************************}
                        {**  GRID/LIST Routines  **}
                        {**************************}
procedure BrowseTheFile;
{}
var
   DNP: DoubleNodePtr;
   ItemStr: string;
   X1,Y1,X2,Y2: shortint;
   WinFound: boolean;
   Temp: WStructurePtr;
begin
   DNP := DLLNodePtr(DemoListDetails.ActiveNode);
   if DNP <> nil then
   begin
      DLLSetActiveList(DemoList);
      ItemStr := DLLGetNodeStr(DNP,1,255);
      ItemStr := copy(ItemStr,1,pred(pos(' ',ItemStr)));
      WinFound := false;
      Temp := WinVars.FirstWin;
      while (Temp <> nil) and not WinFound do
      begin
         WinFound := Temp^.Title = ' '+ItemStr+' ';
         Temp := Temp^.NextWinPtr;
      end;
      if WinFound then
         PromptOK(' Hey! ', 'You are already browsing that file')
      else
      begin
         DLLSetBit(DNP,ColBit,true);
         {position the window}
         DeskNextWinDim(X1,Y1,X2,Y2,10,7);
         with ListVars do
         begin
            WX1 := X1;
            WY1 := Y1;
            WX2 := X2;
            WY2 := Y2;
         end;
         if LaunchBrowseFile(ItemStr,' '+ItemStr+' ') = 0 then
            PromptOK(' Hey! ', 'Unable to load the file for browsing')
      end;
      DLLActivatePrevList;
   end;
end; { BrowseTheFile }

{$F+}
procedure ListHindHook(ListDetPtr:ListCfgPtr);
{Checks for the enter key, double click on list to browse the window}
begin
   if FirstHookCall then
      FirstHookCall := false
   else
      with ListdetPtr^ do
      with KeyVars do
      begin
         if (LastKey = 13)
         or ((LastKey = 540) and (LastX <> 0)) then
            BrowseTheFile
      end;
end; {ListHindHook}
{$F-}

procedure DefineTheList;
{}
begin
   InitDLLStr(DemoList);
   DLLSetActiveList(DemoList);
   InitListCfg(DemoListDetails);
   with DemoListDetails do
   begin
      WX1 := 2;
      WX2 := 78;
      WY1 := 3;
      WY2 := 23;
      LastCol := 100;
   end;
   CountMatches;
   BuildFile;
   ListAssignDLL(DemoListDetails,DemoList);
   ListAssignHindHook(DemoListDetails,ListHindHook);
   ListSetTwoColors(DemoListDetails,true);
   FirstHookCall := true;
   {set the heading}
   Heading := ' Filename     Description';
   ListAssignHeader(DemoListDetails,1,Heading);
   ListScrollHeader(DemoListDetails,false);
   {lock columns 1 to 14, but no rows}
   GridSetLocks(DemoListdetails,14,0);
end; { DefineTheList }

{$F+}
function GoodbyeList(ListDetailsPtr:ListCfgPtr; Handle:integer):boolean;
{Called when the user closes the list window}
begin
   PopUpSetActive(FileMenu,101,true);
   DLLSetActiveList(DemoList);
   DLLDestroy;
   GoodbyeList := true;
end; { GoodbyeList }
{$F-}

procedure GenerateTheList;
{}
begin
   DefineTheList;
   PopupSetActive(FileMenu,101,false);
   if LaunchGrid(DemoListDetails,' Gold Demo File List ',GoodbyeList) = 0 then
      PromptOK(' NocanDo ', 'Unable to display the demo list');
end; { GenerateTheList }

{$F+}
procedure ListActiveCheck;
{Checks to see if list window still open -- if not, all
 windows are closed}
var
   WinP: WStructurePtr;
begin
   if FirstHindCall then
   begin
      FirstHindCall := false;
      GenerateTheList;
   end
   else
   begin
      if WinVars.TopWin = nil then
         PopUpSetActive(FileMenu,102,false)
      else
      begin
         WinP := WinPtr(1);
         if WinP = nil then
         begin
            if not DeskCloseAllWindows then
               PromptOK(' Message ','Unable to close all windows');
         end
         else
         begin
           PopUpSetActive(FileMenu,102,WinVars.TopWin^.WinNum = 1);
         end;
      end;
   end;
end; { ListActiveCheck }
{$F+}

                        {**************************}
                        {**  Desktop Management  **}
                        {**************************}

procedure BuildTheMenus;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~F~ile',100,84,289,' File management commands',@FileMenu);
   BarAddItem(MainMenu,'~W~indow',900,87,273,' Open, arrange and list windows',@WinMenu);
   BarAddHK(MainMenu,354,905); {Ctrl+F5 - Move}
   BarAddHK(MainMenu,364,906); {Alt+F5 - Stretch}
   BarAddHK(MainMenu,319,907); {F5 - Zoom}
   BarAddHK(MainMenu,320,908); {F6 - Next}
   BarAddHK(MainMenu,345,909); {Shift+F6 - Previous}
   BarAddHK(MainMenu,342,910); {Alt+F3 - Close}
   BarAddHK(MainMenu,385,911); {Alt+0 - List}
   BarAddHK(MainMenu,301,999); {Alt+X}
   InitPopUp(FileMenu);
   PopUpAddItem(FileMenu,'!~L~ist the files',101,76,' Display a list of all the Gold demo files',nil);
   PopUpAddItem(FileMenu,'~B~rowse',102,66,' Browse the highlighted file',nil);
   PopUpAddItem(FileMenu,'E~x~it',999,88,' Exit this program',nil);
   InitPopUp(WinMenu);
   PopUpAddItem(WinMenu,'~T~ile',901,84,' Arrange windows on desktop by tiling',nil);
   PopUpAddItem(WinMenu,'C~a~scade',902,65,' Arrange windows on desktop by cascading',nil);
   PopUpAddItem(WinMenu,'Cl~o~se all',903,79,' Close all windows on the desktop',nil);
   PopUpAddItem(WinMenu,'~R~efresh display',904,82,' Redraw the screen',nil);
   PopUpAddItem(WinMenu,'-',0,0,'',nil);
   PopUpAddItem(WinMenu,'~M~ove:Ctrl+F5',905,83,' Change the size or position of the active window',nil);
   PopUpAddItem(WinMenu,'~S~tretch:',906,83,' Change the size or position of the active window',nil);
   PopUpAddItem(WinMenu,'~Z~oom:F5',907,90,' Enlarge or restore the size of the active window',nil);
   PopUpAddItem(WinMenu,'~N~ext:F6',908,78,' Make the next window active',nil);
   PopUpAddItem(WinMenu,'~P~revious:Shift+F6',909,80,' Make the previous window active',nil);
   PopUpAddItem(WinMenu,'~C~lose:Alt+F3',910,67,' Close the active window',nil);
   PopUpAddItem(WinMenu,'-',0,0,'',nil);
   PopUpAddItem(WinMenu,'~L~ist...:Alt+0',911,76,' Show a list of all open windows',nil);
end; { BuildTheMenus }

procedure DestroyTheMenus;
{}
begin
   DestroyPopUp(FileMenu);
   DestroyPopUp(WinMenu);
   DestroyBar(MainMenu);
   DestroyBar(StatusBar);
end; { DestroyTheMenus }

{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     101: GenerateTheList;
     102: BrowseTheFile;
     {Window options}
     901: if not DeskTile then
        PromptOK(' Message ','Unable to tile the windows');
     902: DeskCascade;
     903: if not DeskCloseAllWindows then
        PromptOK(' Message ','Unable to close all windows');
     904: DeskRefresh;
     905:  if not DeskMoveTopWin then
        PromptOK(' Message ','The top window cannot be moved');
     906:  if not DeskStretchTopWin then
        PromptOK(' Message ','The top window cannot be stretched');
     907:  if not DeskZoomTopWin then
        PromptOK(' Message ','The top window cannot be zoomed');
     908: DeskNextWin;
     909: DeskPrevWin;
     910: Action := DCloseTop;
     911: DeskWinList;
     {help and quite}
     1001: PromptOK(' Tools Help ','^Honey if you need help, we got problems!');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}


begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   BuildTheMenus;
   CursorOff;
   MouseShow(true);
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   FirstHindCall := true;
   DeskAssignHindHook(ListActiveCheck);
   Action := DeskProcessInput;
   DestroyTheMenus;
   ResetStartUpMode;
   MouseShow(false);
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { DemoView }
