{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO5.PAS
              An adaptation of DEMIO4 with the field messages being
              displayed outside the window at the bottom of the display.
}

program DEMIO5;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldFast, GoldCal, GoldDate, GoldMisc, GoldKey, GoldIO,
                    GoldIO2, GoldStr, GoldWin;

var
  Name,Tel:string;
  Age:byte;
  Sex: byte;

procedure SetScreen;
{}
begin
   Clear(LightGrayOnBlack,'');
   ClearLine(1,BlueOnLightgray);
   WriteCenter(1,UseTint,'Displaying a form in a Window');
   WriteAt(1,2,LightgrayOnBlue,replicate(80,''));
   WriteAT(70,2,LightgrayOnBlack,'TTT Gold!');
   ClearLine(25,BlackOnLightgray);
   WritePlain(8,25,'');
end; { SetScreen }

procedure SetVars;
{Sets the default values for the fields}
begin
   Name := 'Jack Palance';
   Tel := '8776542';
   Age  := 41;
   Sex := 1;
end; { SetVars }

procedure SetFields;
{Defines the form by postioning the fields, linking the fields to
 variables, and adding labels, hotkeys and messages}
begin
   CreateForms(1);
   ActivateForm(1);
   {Instruct Gold to display the form in a Window}
   SetFormWindow(15,6,65,19,7);
   {FormWinNum returns the window handle of the active Form}
   WinSetTitle(FormWinNum,' A Dialog Box! ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   {create the 6 fields}
   KwikAddField(1,17,2);
   KwikAddField(2,17,4);
   KwikAddField(3,17,6);
   KwikAddField(4,17,8);
   KwikAddField(5, 23,11);
   KwikAddLastField(6, 36,11);
   {Field 1}
   StringField(1, Name, '******************************'); {Field 1, use variable Name, accept any 30 characters}
   SetLabel(1, LabelLeft,LabelLeft,'Full ~n~ame:');
   SetMessage(1, 0,0,'Enter the full name "First I. Last"');
   SetHK(1,305); {alt-N}
   {Field 2}
   StringField(2, Tel, '(###) ###-####'); {Field 2, use a format mask to define tel. field}
   FieldRules(2,EraseDefault+rightjustify,[#0],[#0]); {set input to right justify}
   SetLabel(2, LabelLeft,LabelLeft,'~T~el:');
   SetMessage(2, 0,0,'Always include the area code');
   SetHK(2,276); {alt-T}
   {Field 3}
   ByteField(3, Age, '##', 13,65);  {two digit number in the range 13 to 65}
   SetLabel(3, LabelLeft,LabelLeft,'Patients ~a~ge:');
   SetHK(3,286); {alt-A}
   SetMessage(3, 0,0,'Age must be in the range 13 to 65');
   {Field 4}
   RadioField(4,15,2,sex);  {single character field; force input to uppercase}
   RadioAddItem(4,1,1,'~M~ale','Patient is male',306);
   RadioAddItem(4,1,2,'~F~emale','Patient is female',289);
   SetLabel(4, LabelLeft,LabelLeft,'Sex:');
   {Fields 4 & 5: buttons}
   ButtonDefaultField(5,'   ~O~K   ',finished);
   SetHK(5,280); {alt-O}
   SetMessage(5, 0,0,'Save the changes and edits');
   ButtonField(6,' ~C~ancel ',escaped);
   SetMessage(6, 0,0,'Abort the changes and edits');
   SetHK(6,302); {alt-C}
   {Set the default location of all the messages}
   SetMessageXY(10,25,false);  {ignore the window, and write at 10,25}
end; { SetFields }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   SetVars;
   SetFields;
   {by default each field is checked as the user tries to move from one field
    to the next -- the following line instructs TTT to check it when OK is pressed}
   SetValidation(ValidateAtEnd);
   MouseShow(true);
   ProcessInput(1);
   DisposeFormWin;
   GotoXY(1,15);
   writeln;
   if FormExitAction = Finished then
   begin
      writeln('Name: ',Name);
      writeln('Tel:  ',PicFormat(Tel,'(###) ###-####',' ',true));
      writeln('Age:  ',Age);
      write('Sex:  ',Sex);
   end
   else
     write('You cancelled!');
   DelayKey(5000);
   DisposeFields;
   DisposeForms;
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
