{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMIO10.PAS
              Shows how to use a memo field to provide text editing with
              wordwrap.
}

program DEMIO10;

{$I GOLDFLAG.INC}

uses  DOS, CRT, GoldAttr, GoldHard, GoldFast, GoldWin, GoldIO, GoldIO2,
                GoldIO3, GoldDate, GoldStr, GoldKey, GoldMisc, GoldMemo,
                GoldLink, GoldTint;

var
  TextData: SingleLL;
  MemoSettings:MemoCfg;
  Source:byte;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightcyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' Memo Field with Word Wrap');
   GotoXY(1,1);
end; {SetScreen}

procedure ShutDown;
{}
begin
   PromptOK(' ERROR! ','Not enough memory to run program!');
   halt;
end; { ShutDown }

procedure SetVars;
{Sets the default values for the fields}
var I: integer;
begin
   {Populate the linked list with the default text}
   I := 0;
   InitSLLStr(TextData);
   SLLSetActiveList(TextData);
   inc(I,SLLAddStr('Turbo Pascal with Objects 7.0 is the highest productivity professional'));
   inc(I,SLLAddStr('programming system for DOS, DOS protected mode (DPMI), and Windows'));
   inc(I,SLLAddStr('development.Features DOS, Windows IDEs; new ObjectBrowsers; object-oriented'));
   inc(I,SLLAddStr('application frameworks; world''s fastest compiler. Exclusive ability to'));
   inc(I,SLLAddStr('create DOS, Windows Dynamic Link Libraries (DLLs) so code can be shared'));
   inc(I,SLLAddStr('across platforms.Better still, the entire product is fully compatible'));
   inc(I,SLLAddStr('with the award-winning TechnoJock''s Turbo Toolkit! One Two Three'));
   if I <> 0 then
      ShutDown;
   {Define the memo settings}
   MemoAssignSLL(MemoSettings,TextData);
   MemoSettings.Col[MemoNorm] := 15; {change the default color}
   {Set default radio button}
   Source := 1;
end; {SetVars}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   {define the form's window}
   SetFormWindow(15,4,67,22,1);
   WinSetTitle(FormWinNum,' Customer Comments ');
   WinSetType(FormWinNum,WMove);
   WinSetShowNum(FormWinNum,false);
   KwikAddField(1,10,2);
   KwikAddField(2,10,14);
   KwikAddField(3,35,14);
   KwikAddField(4,35,16);
   {Memo Field}
   MemoField(1,40,11,MemoSettings);
   WrapFull(MemoSettings);
   SetLabel(1,LabelLeft,LabelLeft,'~R~eview ');
   SetHK(1,281);
   SetMessage(1,0,0,'Enter the critics comments');
   {Check boxes}
   RadioField(2,20,3,Source);
   RadioAddItem(2,1,1,'~M~agazine','Review/comments were published in a magazine',305);
   RadioAddItem(2,1,2,'~N~ewsletter','Review/comments were published in a newsletter',304);
   RadioAddItem(2,1,3,'~B~ook','Review/comments were published in book',279);
   SetLabel(2,LabelLeft,LabelLeft,'Source ');
   ButtonField(3,'   ~O~K   ',finished);
   SetHK(3,280);
   SetMessage(3,0,0,'Accept the settings in this dialog box');
   ButtonField(4,' C~a~ncel ',escaped);
   SetHK(4,302);
   SetMessage(4,0,0,'Close the dialog box without making any changes');
   SetMessageXY(10,25,false);  {ignore the window, and write at 10,25}
end; {SetFields}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   ShadowType := 4;
   SetScreen;
   SetVars;
   SetFields;
   MouseShow(true);
   ProcessInput(1);
   DisposeFields;
   DisposeForms;
   GotoXY(1,21);
   MouseShow(false);
   SLLSetActiveList(TextData);
   SLLDestroy;
{$IFDEF CUTANDPASTE}
   ClearClipboardBuffer;
{$ENDIF}
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
   Clear(LightGrayOnBlack,' ');
end.
