{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMFS7.PAS
              Illustrates virtual screen management using the GoldFast unit.
}

program DemoFastSeven;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldMisc, GoldAttr, GoldFast, GoldKey;

procedure Pause;
{}
begin
   GetInput;
end; {Pause}

procedure Initialize;
{}
begin
   CreateScreen(2,80,25,WhiteOnRed);
   CreateScreen(3,80,25,WhiteOnBlue);
end; {Initialize}

procedure IntroScreen;
{}
const
    Tab = 8;
begin
   Clear(WhiteOnBlue,' '); { white,blue }
   WriteCenter(1,YellowOnBlue,'TechnoJock''s Turbo Toolkit - Gold');
   WriteCenter(2,YellowOnBlue,'Copyright 1993 TechnoJock Software, Inc.');
   WritePlain(Tab,5,'The totFAST unit includes the object ScreenOBJ. The interface');
   WritePlain(Tab,6,'section of the unit includes an instance of ScreenOBJ called');
   WritePlain(Tab,7,'SCREEN. You can create other instances of ScreenOBJ and these');
   WritePlain(Tab,8,'are effectively virtual screens created on the heap. At any');
   WritePlain(Tab,9,'time, the visible screen can be saved to a ScreenOBJ instance,');
   WritePlain(Tab,10,'or a ScreenOBJ instance can be displayed on the visible screen.');
   WritePlain(Tab,12,'You can write to the visible screen with SCREEN methods, or');
   WritePlain(Tab,13,'write to a virtual screen by calling the methods of any other');
   WritePlain(Tab,14,'instance.');
   WritePlain(Tab,16,'While you have been reading this screen, 3 other screens have');
   WritePlain(Tab,17,'been created. Press any key to see these screens slide onto');
   WritePlain(Tab,18,'the display.');
   WriteRight(80,25,YellowOnRed,'Press any key to continue ....');
end; {IntroScreen}

procedure BuildScreen2;
{}
const
   Tab = 8; Tab1 = 10;
begin
   ActivateVirtualScreen(2);
   WriteCenter(1,YellowOnRed,'Screen Writing');
   WritePlain(Tab,5,'The ScreenOBJ object boasts a large number of screen writing');
   WritePlain(Tab,6,'methods, including the following:');
   WriteHi(Tab1,8,YellowOnRed,WhiteOnRed,'~Write~ writes at cursor position in default color'); { yellow,red } { white,red }
   WriteHi(Tab1,9,YellowOnRed,WhiteOnRed,'~WriteHi~ writes at X,Y using highlights');
   WriteHi(Tab1,10,YellowOnRed,WhiteOnRed,'~WritePlain~ writes at X,Y using existing attribute');
   WriteHi(Tab1,11,YellowOnRed,WhiteOnRed,'~WriteAt~ writes at X,Y using a specified color');
   WriteHi(Tab1,12,YellowOnRed,WhiteOnRed,'~WriteCap~ writes highlighting first capital letter');
   WriteHi(Tab1,13,YellowOnRed,WhiteOnRed,'~WriteClick~ writes with a tactile click!');
   WriteHi(Tab1,14,YellowOnRed,WhiteOnRed,'~WriteCenter~ writes text centered on screen');
   WriteHi(Tab1,15,YellowOnRed,WhiteOnRed,'~WriteBetween~ writes centered between two X coords');
   WriteHi(Tab1,16,YellowOnRed,WhiteOnRed,'~WriteRight~ writes right justified');
   WriteHi(Tab1,17,YellowOnRed,WhiteOnRed,'~WriteVert~ writes in a vertical column ');
   WritePlain(Tab,19,'Other methods provide full control of the cursor, the');
   WritePlain(Tab,20,'ability to read characters from any location on a screen');
   WritePlain(Tab,21,'and objects for controlling the physical display');
   WritePlain(Tab,22,'attributes, e.g. set into condensed display. Press any');
   WritePlain(Tab,23,'key to see the box and line drawing capabilities.');
   GotoXY(57,23);
end; {BuildScreen2}

procedure BuildScreen3;
{}
const
   Tab = 8;
begin
   ActivateVirtualScreen(3);
   WritePlain(Tab,4,'The ScreenOBJ objects includes some very easy-to-use box drawing');
   WritePlain(Tab,5,'methods. Boxes can be draw as a frame or filled, and optionally');
   WritePlain(Tab,6,'draw titles at the top, in a drop box, or at the bottom of the box.');
   WritePlain(Tab,21,'There are also methods for drawing single and double lines');
   WritePlain(Tab,22,'that automatically draw "junctions" when another line is ');
   WritePlain(Tab,23,'met or crossed. Press any key to see the smart line facility.');
   FBox(15,8,65,17,WhiteOnRed,2);
   CursorOff;
end; {BuildScreen3}


begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   Initialize;
   IntroScreen;
   BuildScreen2;
   BuildScreen3;
   ActivateVisibleScreen;
   Pause;
   SaveScreen(1);
   SlideRestoreScreen(2,horiz);
   Pause;
   SlideRestoreScreen(3,vert);
   Pause;
   SmartHorizLine(1,80,14,WhiteOnBlack,1);
   SmartVertLine(35,8,19,UseTint,2);
   SmartVertLine(64,10,19,UseTint,2);
   WriteCenter(25,BlackOnWhite,'That''s all Folks!'); { black,white }
   Pause;
   DisposeScreen(1);
   DisposeScreen(2);
   DisposeScreen(3);
   ClrScr;
   CursorOn;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
