{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDIR4.PAS
              Illustrates how to customize PromptFile colors
}

program Demdir4;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldAttr, GoldFast, GoldLink, GoldDir, GoldHard,
               GoldMisc, GoldIO, GoldKey, GoldWin, GoldTint;

var FileName: string;
    gResult: integer;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' File Dialog ');
   GotoXY(1,1);
end; {SetScreen}

procedure CustomizeColors;
{}
begin
   {first the window border}
   GoldSetColor(IOWinTitle,WhiteonMagenta);
   GoldSetColor(IOWinIcons,GreenonMagenta);
   GoldSetColor(IOWinBorder1,YellowonMagenta);
   GoldSetColor(IOWinBody,YellowonMagenta);
   {now the buttons}
   GoldSetColor(IOButtonNormHot,WhiteOnBlue);
   GoldSetColor(IOButtonNorm,YellowOnBlue);
   GoldSetColor(IOButtonDefHot,WhiteonBlue);
   GoldSetColor(IOButtonDef,LightcyanOnBlue);
   GoldSetColor(IOButtonHiHot,WhiteonRed);
   GoldSetColor(IOButtonHi,YellowOnRed);
   {now the list fields}
   GoldSetColor(ListHi1,WhiteOnRed);
   GoldSetColor(ListNorm1,LightcyanOnBlue);
   GoldSetColor(ListScrollBarHi,LightcyanOnBlue);
   {now the edit field}
   GoldSetColor(IOEditNorm,LightcyanOnBlue);
   GoldSetColor(IOEditErase,BlackOnLightgray);
   GoldSetColor(IOEditHi,WhiteOnRed);
   {and finally the spinner icons}
   GoldSetColor(IOIcons,LightcyanOnBlue);
end; { CustomizeColors }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   CustomizeColors;
   FileName := PromptFile('*.pas');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      PromptOK('','You chose '+FileName);
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
