{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDIR11.PAS
              Shows FileList can be configured to only allow
              the user to select files on a certain drive.
}

program DemDir11;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldAttr, GoldFast, GoldLink, GoldDir, GoldHard,
               GoldMisc, GoldIO, GoldKey, GoldWin;

var FileName: string;

procedure SetScreen;
{Paints the background}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,YellowOnBlue);
   ClearLine(25,LightCyanOnBlue);
   WritePlain(8,25,'');
   WriteCenter(1,UseTint,' File List ');
   GotoXY(1,1);
end; {SetScreen}

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   MouseShow(true);
   with DirVars do
   begin
      AllowDirChange := true;
      AllowDrvChange := false;
   end;
   FileName := FileList('*.*',' Pick a file -- any file! ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
      PromptOK('','You chose '+FileName);
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
