{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{              Copyright 1986-1995  TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMDESK4.PAS
               An extension of DEMDESK3 illustrating an
               input form in a modeless window.
               Note: the Form code was taken from DEMIO8
}

program DEMDESK4;

uses DOS, CRT,
     GoldFast, GoldWin, GoldMenu, GoldMisc, GoldDesk,
     GoldKey, GoldCalc, GoldCal, GoldDate, GoldStr,
     GoldIO, GoldIO2, GoldIO3, GoldTint, GoldAttr;
type
   PrintRec = record
      TypefaceID: integer;
      TypeSize: byte;
      Bold: boolean;
      Italic: boolean;
   end; {PrintRec}

var
   MainMenu,
   StatusBar: Bar;
   SubMenu: PopUp;
   Action : dAction;
   PrintInfo: PrintRec;
   Norm: boolean;
   LongVar: longint;

                            {******************}
                            {**  Menu Procs  **}
                            {******************}

{$F+}
procedure MenuHelp(ID:integer);
{}
begin
   PromptOK(' Help! ','You asked for help on menu item ID: '+IntToStr(ID));
end; { MenuHelp }
{$F-}

procedure DefineSubMenu;
{}
begin
   InitPopUp(SubMenu);
   with SubMenu do
   begin
      PopUpAddItem(SubMenu,'~C~alculator',101,67,'Display a calculator',nil);
      PopUpAddItem(SubMenu,'Ca~l~endar',102,76,'Display a calendar',nil);
      PopUpAddItem(SubMenu,'~A~bout',103,65,'Show version and copyright information',nil);
      PopUpAddItem(SubMenu,'E~x~it',999,88,'~Exit~ this little demo',nil);
   end;
end; { DefineSubMenu }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~T~ools',100,84,276,'Select one of Desktop tools',@SubMenu);
   BarAddItem(MainMenu,'~F~orm',200,70,289,'Add a simple form to the desktop',nil);
   MainMenu.Style := 2;
   AssignMenuHelpHook(MainMenu,MenuHelp);
end; { DefineMainMenu }

procedure DefineStatusBar;
{}
begin
   InitBar(StatusBar);
   BarAddItem(StatusBar,'~F1~ Help',1001,315,315,'',nil);
   BarAddItem(StatusBar,'~Alt+X~ Exit the demo',999,301,301,'',nil);
end; { DefineStatusBar }

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
   DestroyBar(StatusBar);
end; { DisposeMenus }

                            {******************}
                            {**  Form Procs  **}
                            {******************}
procedure SetVars;
{Sets the default values for the fields}
begin
   with PrintInfo do
   begin
      TypefaceID := 1;
      TypeSize := 12;
      Bold := false;
      Italic := false;
   end;
   Norm := true;
   LongVar := PrintInfo.TypeSize;
end; {SetVars}

procedure SetFields;
{}
var I : Integer;
begin
   CreateForms(1);
   ActivateForm(1);
   IoSetColor(IOMessage,blackonlightgray);
   {define the form's window}
   KwikAddField(1,15,2);
   KwikAddField(2,15,4);
   KwikAddField(3,15,6);
   KwikAddField(4,25,10);
   KwikAddLastField(5, 38,10);
   {Font List}
   SpinDropListField(1,25,PrintInfo.TypeFaceID);
   ListKwikAddItem(1,'Adelaide|Arial MT|Bookman|Courier|Dom Casual|Freestyle Script|Griffon');
   ListKwikAddItem(1,'Helvetica|Juniper|Kidnap|Lithos Light|Palatino|Symbol|System|Times Roman|Zap Dingbobs');
   SetLabel(1,LabelLeft,LabelLeft,'~T~ypeface');
   SetHK(1,276);
   SetMessage(1,0,0,'Select the typeface for printed output');
   {Font Size}
   SpinLongField(2,Longvar,2,6,72,1);
   SetLabel(2,LabelLeft,LabelLeft,'~P~oint size');
   SetHK(2,281);
   SetMessage(2,0,0,'Enter a point size in the range 6 to 72');
   {Check boxes}
   CheckField(3,15,3);
   CheckAddItem(3,1,1,'~N~ormal','Turns off bold and italic',305,Norm);
   CheckAddItem(3,1,2,'~B~old','Select this field for bold text',304,Printinfo.Bold);
   CheckAddItem(3,1,3,'~I~talic','Select this field for bold text',279,Printinfo.Italic);
   SetLabel(3,LabelLeft,LabelLeft,'Format');
   ButtonDefaultField(4,'   ~O~K   ',finished);
   SetHK(4,280);
   SetMessage(4,0,0,'Accept the settings in this dialog box');
   ButtonField(5,' C~a~ncel ',escaped);
   SetHK(5,286);
   SetMessage(5,0,0,'Close the dialog box without making any changes');
   SetMessageXY(11,25,false);  {ignore the window, and write at 10,25}
end; {SetFields}

{$F+}
function FormShutDown(Form:byte):boolean;
{}
begin
   BarSetActive(MainMenu,200,true);
   DeskRefreshBgnd;
   DisposeFields;
   DisposeForms;
   PrintInfo.TypeSize := Longvar;
   FormShutDown := true;
end; { FormShutDown }
{$F-}

procedure BuildandDisplayForm;
{}
var WinNum: integer;
begin
   SetFields;
   WinNum := LaunchFormInit(15,5,65,17,1,FormShutDown);
   if WinNum = 0 then
      PromptOK(' Error ','^Unable to display the form')
   else
   begin
      BarSetActive(MainMenu,200,false);
      DeskRefreshBgnd;
      WinSetTitle(FormWinNum,' Font Settings ');
      WinSetType(FormWinNum,WMove);
      LaunchForm(1);
   end;
end; { BuildandDisplayForm }

                           {********************}
                           {**  Task Manager  **}
                           {********************}
{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     101: if LaunchCalculator(' Punch Me ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calculator');
     102: if LaunchCalendar(TodayInJul,' Calendar ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calendar');
     103: PromptOK(' Tools Demo ','^Copyright 1995 TechnoJock Software, Inc.|'+
                     '^All Rights Reserved');
     200: BuildandDisplayForm;
     1001: PromptOK(' Tools Help ','^Honey if you need help, we got problems!');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineSubMenu;
   DefineMainMenu;
   DefineStatusBar;
   SetVars;
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   DeskAssignStatusBar(Statusbar);
   UseCustomChars;
   SetBlinking(false);
   MouseShow(true);
   CursorOff;
   Action := DeskProcessInput;
   CursorOn;
   MouseShow(false);
   DisposeMenus;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.

