{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{              Copyright 1986-1995  TechnoJock Software, Inc.              }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description:  DEMDESK2.PAS
               Creates a desktop with a calculator
               and calendar.
}

program DEMDESK2;

uses DOS, CRT,
     GoldFast, GoldWin, GoldMenu, GoldMisc, GoldDesk,
     GoldKey, GoldCalc, GoldCal, GoldDate;

var
   MainMenu: Bar;
   SubMenu: PopUp;
   Action : dAction;

procedure DefineSubMenu;
{}
begin
   InitPopUp(SubMenu);
   with SubMenu do
   begin
      PopUpAddItem(SubMenu,'~C~alculator',101,67,'Display a calculator',nil);
      PopUpAddItem(SubMenu,'Ca~l~endar',102,76,'Display a calendar',nil);
      PopUpAddItem(SubMenu,'~A~bout',103,65,'Show version and copyright information',nil);
      PopUpAddItem(SubMenu,'E~x~it',999,88,'~Exit~ this little demo',nil);
   end;
end; { DefineSubMenu }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~T~ools',100,84,276,'Select one of Desktop tools',@SubMenu);
   BarAddHK(MainMenu,301,999); {Alt-X}
   MainMenu.Style := 2;
end; { DefineMainMenu }

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(SubMenu);
end; { DisposeMenus }

{$F+}
procedure MyActionProc(Choice:integer;var Action:DAction);
{}
begin
   case Choice of
     101: if LaunchCalculator(' Punch Me ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calculator');
     102: if LaunchCalendar(TodayInJul,' Calendar ') = 0 then
        PromptOK(' Error ', 'Unable to display the Calendar');
     103: PromptOK(' Tools Demo ','^Copyright 1995 TechnoJock Software, Inc.|'+
                     '^All Rights Reserved');
     999: Action := DFinished;
   end;
end; { MyActionProc }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   DefineSubMenu;
   DefineMainMenu;
   DeskAssignMainMenu(MainMenu);
   DeskAssignActionProc(MyActionProc);
   (*
   UseCustomChars;
   *)
   SetBlinking(false);
   MouseShow(true);
   CursorOff;
   Action := DeskProcessInput;
   CursorOn;
   MouseShow(false);
   DisposeMenus;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
