{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDB7.PAS

}

program Demdb7;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDb, GoldFast, GoldWin, GoldTint, GoldAttr, GoldMemo,
     GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc,
     GoldKey, GoldLink, GoldList;

const FN = 'DEMCUST.DBF';
      Msg1 =  ' Displaying a Database in a List View';
      Msg2 =  ' Client Profiles ';
      Msg3 =  ' Unable to load the database';
      Msg11 = ' Returning to DOS ';
      Msg12 = '^Have you really finished?';
      Msg13 = ' About to cancel! ';
      QuiBtn = ' ~Q~uit ';

type UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
     end;

var
   UserTerminates: boolean;
   ListDetails: ListCfg;
   Handle, Activefield,
   EC,NdxFld: integer;
   LastAction: gAction;
   X,
   ActiveRecord: longint;

{$F+}
function GetStrfromDB(P:pointer; Element,Start,Finish: longint): string;
{}
var RecNo: longint;
begin
   RecNo := NdxGetRecNum(Element);
   GetStrfromDB := padleft(PadLeft(inttostr(RecNo),4,' ')+' '+copy(DbgetFldString(RecNo,2),Start,succ(Finish-Start)),
                           succ(Finish-Start),' ');
end; { GetStrfromDB }
{$F-}

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,Msg1);
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
   Tint[IOLabelNorm] := LightBlueOnLightGray;
   Tint[IOLabelNormHot] := LightBlueOnLightGray;
   Tint[IOLabelHi] := LightBlueOnLightGray;
   Tint[IOLabelHiHot] := LightBlueOnLightGray;
   Tint[IOLabelOff] := LightBlueOnLightGray;
end; { SetScreen }

procedure PrepareCustomList;
{}
begin
   InitListCFG(Listdetails);
   ListAssignCustom(Listdetails,DbGetNumRecs,GetStrfromDB);
end; { PrepareCustomList }

procedure BuildForm;
{}
var Win1: integer;
begin
   CreateForms(1);
   ActivateForm(1);
   PrepareCustomList;
   AllowEsc(false);
   SetFormWindow(10,4,70,22,7);
   Win1 := FormWinNum;
   WinSetTitle(Win1,Msg2);
   WinSetType(Win1,WMoveNoClose);
   WinSetShowNum(Win1,false);
   SetMessageXY(12,25,false);
   WinDisplay(Win1);
   KwikAddField(1, 2,2);        { the list }
   KwikAddLastField(2, 47,16);    { Quit }
   WrapListField(1,54,1,13,ListDetails);
   ButtonDefaultField(2,QuiBtn,escaped);
   { define hotkeys }
   SetHK(1,272);  { Alt+Q } {quit button}
end; { BuildForm }


begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   NdxFld := 2;
   Handle := DbOpenDataSet(FN); {extremely important assignment}
   if Handle <> 0 then
   begin
      if DbIndexedField = 0 then
      begin
         EC := NdxBuildNew(NdxFld);
         if EC <> 0 then
         begin
            PromptOK(' INDEX ERROR ','^Index is missing!|^Error Code - '+IntToStr(EC));
            halt;
         end;
      end;
      Tint[IOWinTitle] := WhiteOnRed;
      SetScreen;
      BuildForm;
      MouseShow(true);
      UserTerminates := false;
      DbSetFullStrings(false);
      ActiveRecord := 1;
      X := NdxGotoFirst;
      repeat
         DisplayForm;
         LastAction := EditForm(ActiveField);
         ActiveField := FieldWithFocus;
         case LastAction of
            Stop1: begin

            end;
            Stop2: begin

            end;
            Escaped: begin
              if PromptYesNo(Msg11,Msg12) = 1 then
                 UserTerminates := true;
            end;
         end;  { case }
      until UserTerminates;
      DisposeFields;
      DisposeForms;
      MouseShow(false);
      DbCloseAllDatabases;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
