{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMDB6.PAS
              Shows each functional part of an actual database application
}

program Demdb6;

{$I GOLDFLAG.INC}

uses CRT, DOS, GoldDb, GoldFast, GoldWin, GoldTint, GoldAttr, GoldMemo,
     GoldStr, Goldio, Goldio2, Goldio3, GoldDate, GoldMisc, GoldKey, GoldLink;

const FN: string[12] = 'DEMCUST';
      Msg1 = ' An Example Of Browsing And Editing a Database ';
      Msg2 = ' Client Profiles ';
      Msg5 = ' Top of file ';
      Msg6 = '^Looping to last record';
      Msg7 = ' End of file ';
      Msg8 = '^Looping to first record';
      Msg9 = ' Deleting Record! ';
      Msg10 = '^Are you sure?';
      Msg11 = ' Returning to DOS ';
      Msg12 = '^Have you really finished?';
      Msg13 = ' About to cancel! ';
      EdtBtn = '~E~dit';
      AddBtn = '~A~dd';
      SavBtn = '~S~ave';
      CanBtn = '~C~ancel';
      DelBtn = '~D~el';
      QuiBtn = ' ~Q~uit ';

type UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
     end;

var I, Win1, Handle,
    ActiveField: integer;
    UserTerminates,
    Saving, Editing,
    Cancelling, Adding: boolean;
    RecNum, X, SavedX: longint;
    LastAction: gAction;
    UserRec, SavdUserRec: UserRecord;
    EC, NdxFld: integer;
    SavValidate: gValidate;

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure WatchNDXBuild( KeysWritten, TotRecords: longint; Status: byte );
{}
begin
  WriteProgressLong(18,57,10,KeysWritten,TotRecords,true);
end;
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SetScreen;
{}
begin
   Clear(WhiteOnBlack,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,WhiteOnBlue,Msg1);
   WriteAT(68,1,YellowOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnRed);
   Tint[IOLabelNorm] := LightBlueOnLightGray;
   Tint[IOLabelNormHot] := LightBlueOnLightGray;
   Tint[IOLabelHi] := LightBlueOnLightGray;
   Tint[IOLabelHiHot] := LightBlueOnLightGray;
   Tint[IOLabelOff] := LightBlueOnLightGray;
end; { SetScreen }

procedure SaveUserRec;
{}
begin
   SavdUserRec := UserRec;
   SavedX := X;
end; { SaveUserRec }

procedure RestoreUserRec;
{}
begin
   UserRec := SavdUserRec;
   X := SavedX;
end; { RestoreUserRec }

function DataHasChanged: boolean;
{}
begin
   DataHasChanged := Different(UserRec,SavdUserRec,sizeof(UserRec));
end; { DataHasChanged }

procedure InitData;
{}
begin
   with UserRec do
   begin
      Entered := TodayInJul;
      Client := '';
      Addr1 := '';
      Addr2 := '';
      City := '';
      State := '';
      Zip := '';
      Country := '';
      Phone := '';
      Units := 0;
   end;
end; { InitData }

procedure DatabaseToScreen(RecNo:longint);
{}
begin
   with UserRec do
   begin
      Entered := DbGetFldDate(RecNo,1);
      Client := DbGetFldString(RecNo,2);
      Addr1 := DbGetFldString(RecNo,3);
      Addr2 := DbGetFldString(RecNo,4);
      City := DbGetFldString(RecNo,5);
      State := DbGetFldString(RecNo,6);
      Zip := DbGetFldString(RecNo,7);
      Country := DbGetFldString(RecNo,8);
      Phone := DbGetFldString(RecNo,9);
      Units := DbGetFldLong(RecNo,10);
   end;
end; { DatabaseToScreen }

procedure ScreenToDatabase;
{}
begin
   with UserRec do
   begin
      DbSetFldDate(1,Entered);
      DbSetFldString(2,Client);
      DbSetFldString(3,Addr1);
      DbSetFldString(4,Addr2);
      DbSetFldString(5,City);
      DbSetFldString(6,State);
      DbSetFldString(7,Zip);
      DbSetFldString(8,Country);
      DbSetFldString(9,Phone);
      DbSetFldInt(10,Units);
   end;
   if Adding then
   begin
      DbAddRecord;
      Adding := false;
   end else
      DbPutRecord;
end; { ScreenToRecord }

procedure BuildForm;
{}
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(false);
   SetFormWindow(10,4,70,22,7);
   Win1 := FormWinNum;
   WinSetTitle(Win1,Msg2);
   WinSetType(Win1,WMoveNoClose);
   WinSetShowNum(Win1,false);
   SetMessageXY(12,25,false);
   WinDisplay(Win1);
   KwikAddField(1, 43,2);         { ENTERED D 8 }
   KwikAddField(2, 21,4);         { CLIENT C 30 }
   KwikAddField(3, 21,5);         { ADDR1 C 30 }
   KwikAddField(4, 21,6);         { ADDR2 C 30 }
   KwikAddField(5, 21,7);         { CITY C 22 }
   KwikAddField(6, 49,7);         { STATE C 2 }
   KwikAddField(7, 21,8);         { ZIP C 10 }
   KwikAddField(8, 21,11);        { COUNTRY C 20}
   KwikAddField(9, 21,12);        { PHONE C 10}
   KwikAddField(10, 21,13);       { UNITS N 10 }
   KwikAddField(11, 3,16);        { goto top }
   KwikAddField(12, 9,16);        { prev }
   KwikAddField(13, 14,16);       { next }
   KwikAddField(14, 19,16);       { goto end }
   KwikAddField(15, 25,16);       { add }
   KwikAddField(16, 32,16);       { del }
   KwikAddField(17, 39,16);       { edit/save }
   KwikAddField(18, 47,16);       { quit/cancel }
   KwikAddLastField(19, 14,2);    { Record No }
   with UserRec do
   begin
      SpinDropDateField(1,Entered,MMDDYY,'',0,0);
      StringField(2,Client,Replicate(30,'*'));
      FieldRules(2,NoRules+EraseDefault,[NoChar],[NoChar]);
      { turns off allowNul, turn on EraseDefault }
      StringField(3,Addr1,Replicate(30,'*'));
      StringField(4,Addr2,Replicate(30,'*'));
      StringField(5,City,Replicate(22,'*'));
      StringField(6,State,'!!');
      StringField(7,Zip,'#####-####');
      StringField(8,Country,Replicate(20,'*'));
      StringField(9,Phone,'(###) ###-####');
      SpinLongField(10,Units,10,0,0,1);
   end;
   ButtonField(11,'',Stop1);
   ButtonField(12,'',Stop2);
   ButtonField(13,'',Stop3);
   ButtonField(14,'',Stop4);
   ButtonField(15,AddBtn,Stop8);
   ButtonField(16,DelBtn,Stop9);
   ButtonField(17,EdtBtn,Stop5);
   ButtonDefaultField(18,QuiBtn,escaped);
   LongintField(19,RecNum,'',0,0);
   FieldSetState(19,FldOff); { display only }
   { define labels }
   SetLabel(1,LabelLeft,LabelLeft,'Date');
   SetLabel(2,LabelLeft,LabelLeft,'Clients name');
   SetLabel(3,LabelLeft,LabelLeft,'Address');
   SetLabel(5,LabelLeft,LabelLeft,'City, State');
   SetLabel(7,LabelLeft,LabelLeft,'Zip code');
   SetLabel(8,LabelLeft,LabelLeft,'Country');
   SetLabel(9,LabelLeft,LabelLeft,'Phone #');
   SetLabel(10,LabelLeft,LabelLeft,'Units ordered');
   SetLabel(19,LabelLeft,LabelLeft,'Record No');
   { define messages }
   SetMessage(1,0,0,'Entry date');
   SetMessage(2,0,0,'Client''s name');
   SetMessage(3,0,0,'Street address');
   SetMessage(4,0,0,'Post office box (etc.)');
   SetMessage(5,0,0,'City');
   SetMessage(6,0,0,'State');
   SetMessage(7,0,0,'Zip code');
   SetMessage(8,0,0,'Country');
   SetMessage(9,0,0,'Telephone number');
   SetMessage(10,0,0,'Number of units client has ordered');
   SetMessage(11,0,0,'Go to first record in database');
   SetMessage(12,0,0,'Go to previous record in database');
   SetMessage(13,0,0,'Go to next record in database');
   SetMessage(14,0,0,'Go to last record in database');
   SetMessage(15,0,0,'Add a new record');
   SetMessage(16,0,0,'Delete current record');
   SetMessage(17,0,0,'Edit current record');
   SetMessage(18,0,0,'Return to DOS');
   { define hotkeys }
   SetHK(15,286);  { Alt+A } {save button}
   SetHK(16,288);  { Alt+D } {del button}
   SetHK(17,274);  { Alt+E } {edit button}
   SetHK(18,272);  { Alt+Q } {quit button}
   for I := 1 to 10 do  { set for browse }
      FieldSetState(I,FldOff);
end; { BuildForm }

procedure CreateNewDataFile;
{could be built on the fly via I/O form}
var EValue: integer;
begin
   EValue := 0;
   inc(EValue,DbAddDbfField('DATE','D',8,0));       { DATE  D  8 }
   inc(EValue,DbAddDbfField('CLIENT','C',30,0));    { LAST  C 15 }
   inc(EValue,DbAddDbfField('ADDR1','C',30,0));     { ADDR1 C 30 }
   inc(EValue,DbAddDbfField('ADDR2','C',30,0));     { ADDR2 C 30 }
   inc(EValue,DbAddDbfField('CITY','C',22,0));      { CITY  C 22 }
   inc(EValue,DbAddDbfField('STATE','C',2,0));      { STATE C  2 }
   inc(EValue,DbAddDbfField('ZIP','C',10,0));       { ZIP   C 10 }
   inc(EValue,DbAddDbfField('COUNTRY','C',20,0));   { COUNTRY C 20 }
   inc(EValue,DbAddDbfField('PHONE','C',10,0));     { PHONE C 10 }
   inc(EValue,DbAddDbfField('UNITS','N',10,0));     { UNITS C 14 }
   inc(EValue,DbBuildDataFile(FN,1));
   if EValue <> 0 then
   begin
      PromptOK(' File Error ','Unable to create data file!');
      Halt;
   end;
end; { CreateNewDataFile }

procedure PreSetFields;
{}
begin
   if DbGetNumRecs = 0 then
   begin
      for I := 11 to 14 do { turn off VCR buttons }
         FieldSetState(I,FldOff);
      FieldSetState(17,FldOff); { turn off edit button }
      FieldSetState(16,FldOff); { turn off del button }
      ActiveField := 15;  {add button}
   end else
      ActiveField := 13;
end; { PreSetFields }

procedure CompleteStop6or7;
{}
begin
   for I := 1 to 10 do          { fields }
      FieldSetState(I,FldOff);
   for I := 11 to 18 do
      FieldSetState(I,FldOn);
   ButtonChangeSettings(17,EdtBtn,Stop5);
   SetMessage(17,0,0,'Edit current record');
   SetHK(17,274);  { Alt+E } {edit button}
   ButtonChangeSettings(18,QuiBtn,Escaped);
   SetMessage(18,0,0,'Return to DOS');
   SetHK(18,272);  { Alt+Q } {quit button}
   ActiveField := 13;  { next }
end; { CompleteStop6or7 }

procedure SetValidation;
{}
begin
   SavValidate := IOVars.DefaultValidate;
   IOVars.DefaultValidate := ValidateAtEnd;
end; { SetValidation }

procedure RestoreValidation;
{}
begin
   IOVars.DefaultValidate := SavValidate;
end; { RestoreValidation }

procedure InitVars;
{}
begin
   NdxFld := 2;
   EC := 0;
   Adding := false;
   Saving := false;
   Editing := false;
   Cancelling := false;
end; { InitVars }

begin { main }
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   if not DBFExist(FN) then
      CreateNewDataFile;
   InitVars;
   Handle := DbOpenDataSet(FN); {extremely important assignment}
   if Handle <> 0 then
   begin
      if DbIndexedField = 0 then
      begin
         SetShowNdxProgress(WatchNDXBuild);
         Box3D(15,8,65,12,BlackOnCyan,WhiteOnCyan,4);
         WriteAT(18,8,WhiteOnCyan,' Building Index ');
         if NdxBuildNew(NdxFld) <> 0 then
         begin
            PromptOK(' INDEX ERROR ','Index is missing!');
            halt;
         end;
         PromptOK(' Complete! ','^Index was missing|^It has been completely rebuilt,|^You may continue.');
      end;
      Tint[IOWinTitle] := WhiteOnRed;
      SetValidation;
      SetScreen;
      BuildForm;
      MouseShow(true);
      PreSetFields;
      UserTerminates := false;
      DbSetFullStrings(false);
      InitData;
      X := NdxGotoFirst;
      repeat
         RecNum := X;
         if ((DbGetNumRecs > 0) and (X > 0)) and
            (not Saving) and
            (not Editing) and
            (not Cancelling) then
            DatabaseToScreen(X);
         DisplayForm;
         LastAction := EditForm(ActiveField);
         ActiveField := FieldWithFocus;
         Editing := false;
         Saving := false;
         Cancelling := false;
         case LastAction of
            Stop1: begin
                      X := NdxGotoFirst;
                      ActiveField := 13;  { next }
                   end;
            Stop2: begin
                      X := NdxGotoPrev;
                      if X = 0 then
                      begin
                         X := NdxGotoLast;
                         PromptOK(Msg5,Msg6)
                      end;
                   end;
            Stop3: begin
                      X := NdxGotoNext;
                      if X = 0 then
                      begin
                         X := NdxGotoFirst;
                         PromptOK(Msg7,Msg8);
                      end;
                   end;
            Stop4: begin
                      X := NdxGotoLast;
                      ActiveField := 12;  { prev }
                   end;
            Stop8,         { add  }
            Stop5: begin   { edit }
                      SaveUserRec;
                      if (LastAction = Stop8) then
                      begin
                         Adding := true;
                         InitData;
                         X := 0; { prevents redisplaying previous data }
                         FieldSetState(15,FldOff); { add }
                         FieldSetState(17,FldOn);  { edit/save }
                      end
                      else Editing := true;

                      for I := 1 to 10 do          { fields }
                         FieldSetState(I,FldOn);
                      for I := 11 to 14 do         { vcr }
                         FieldSetState(I,FldOff);
                      FieldSetState(15,FldOff);    { add }
                      FieldSetState(16,FldOff);    { del }
                      ButtonChangeSettings(17,SavBtn,Stop6);
                      SetMessage(17,0,0,'Saves edited information');
                      SetHK(17,287);
                      ButtonChangeSettings(18,CanBtn,Cancel1);
                      SetMessage(18,0,0,'Cancels current operation');
                      SetHK(18,302);
                      ActiveField := 2;
                   end;
            Stop6: begin   { save }
                      if DataHasChanged then
                      begin
                         ScreenToDatabase;
                         Saving := true;
                      end;
                      CompleteStop6or7;
                   end;
          Cancel1: begin   { cancel }
                      Cancelling := true;
                      if PromptYesNo(Msg13,Msg10) = 1 then
                      begin
                         Adding := false;
                         if DbGetNumRecs > 0 then
                            RestoreUserRec;
                         CompleteStop6or7;
                      end
                   end;
            Stop9: begin   { delete }
                      for I := 11 to 15 do
                         FieldSetState(I,FldOff);
                      FieldSetState(17,FldOff);
                      if PromptYesNo(Msg9,Msg10) = 1 then
                      begin
                         DbDeleteRecord(X);
                         X := NdxGotoNext;
                         if X = 0 then
                            X := NdxGotoFirst;
                      end;
                      for I := 11 to 15 do
                         FieldSetState(I,FldOn);
                      FieldSetState(17,FldOn);
                      ActiveField := 13;
                   end;
          Escaped: begin
                      if PromptYesNo(Msg11,Msg12) = 1 then
                         UserTerminates := true;
                   end;
         end;  { case }
      until UserTerminates;
      DisposeFields;
      DisposeForms;
      MouseShow(false);
      DbCloseAllDatabases;
      RestoreValidation;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
