{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMCAL7.PAS
              Shows how to use the Calendar "hooks" to create a 3 month
              Calendar.
}

Program DemCal7;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc,
     GoldFast, GoldKey, GoldTint, GoldCal, GoldDate, GoldStr;

var
   Answer : Dates;
   MiddleMonth,
   MiddleYear: word;

procedure RefreshAdjacentMonths;
{Draws the left and right months}
const
    LX = 1;
    RX = 48;
    Y = 2;
var RetVal: Dates;
begin
   case MiddleMonth of
      1: begin
         RetVal := DrawMonth(12,pred(MiddleYear),LX,Y,false);
         RetVal := DrawMonth(2,MiddleYear,RX,Y,false);
      end;
      12: begin
         RetVal := DrawMonth(11,MiddleYear,LX,Y,false);
         RetVal := DrawMonth(1,succ(MiddleYear),RX,Y,false);
      end;
      else begin
         RetVal := DrawMonth(pred(MiddleMonth),MiddleYear,LX,Y,false);
         RetVal := DrawMonth(succ(MiddleMonth),MiddleYear,RX,Y,false);
      end;
   end; {case}
end; {RefreshAdjacentMonths}

{$F+}
procedure CustomCalChangeHook(CType:gCalChange;Val1,Val2:longint);
{MUST BE A FAR PROC -
    Keeps the left and right months refreshed when the middle month
    changes
}
begin
   case CType of
      Paint,
      ChangeMonth: begin
          MiddleMonth := Val1;
          MiddleYear := Val2;
          RefreshAdjacentMonths;
      end;
      ChangeDay: begin {write the active Day}
         WriteCenter(11,WhiteOnBlue,PadCenter(FancyDateStr(Val2,true,true),30,' '));
      end;
   end; {case}
end; {CustomCalChangeHook}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   Clear(WhiteOnBlue,chr(178));
   ClearLine(1,YellowOnBlue);
   WriteCenter(1,UseTint,'TTT Gold!');
   ClearLine(25,YellowOnRed);
   WriteCenter(25,UseTint,'.....COMING SOON!.....');
   with CALVars do   {position the active month in the middle of a wide window}
   begin
      WX1 := 4;
      WY1 := 5;
      WX2 := 76;
      WY2 := 17;
      CX1 := 25;
      CY1 := 2;
      CalChangeHook := CustomCalChangeHook;
      GoldSetColor(CalEdgeMonth,23);
   end;
   MouseShow(true);
   Answer := RunCalendar(TodayInJul,' Three Month At-A-Glance ');
   clrscr;
   MouseShow(false);
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
