{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMCAL2.PAS
              Shows how to customize the colors used by RunCalendar.
}

program DEMCAL2;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldWin,GoldStr, GoldFast, GoldCal, GoldDate,
          GoldMisc, GoldKey, GoldTint;

var
   Answer : Dates;

procedure SetScreen;
{Paints the background}
begin
   SetBlinking(false);
   Clear(BlueOnLightred,' ');
   ClearLine(1,BlackOnYellow);
   ClearLine(2,BlackOnYellow);
   WriteAT(1,3,LightredOnYellow,replicate(80,''));
   WriteAT(68,3,WhiteOnBlack,' TTT Gold! ');
   ClearLine(25,BlackOnYellow);
   WriteCenter(25,0,'Press ESC to finish...');
end; {SetScreen}

procedure CustomizeColors;
{}
begin
   GoldSetColor(CalBorder,WhiteOnMagenta);
   GoldSetColor(CalIcons,GreenOnMagenta);
   GoldSetColor(CalTitle,YellowOnMagenta);
   GoldSetColor(CalActiveMonth,YellowOnMagenta);
   GoldSetColor(CalEdgeMonth,LightgrayOnMagenta);
   GoldSetColor(CalToday,GreenOnMagenta);
   GoldSetColor(CalHiday,LightMagentaOnBlack);
end; { CustomizeColors }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   CustomizeColors;
   MouseShow(true);
   Answer := RunCalendar(TodayInJul,' A Calendar! ');
   if CalVars.ChooseDay then
   begin
      if Answer = 0 then
         PromptOK('','You escaped!')
      else
         PromptOK('',' You selected '+FancyDateStr(Answer,false,false));
   end;
   ResetStartupMode;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
