{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMBRS7.PAS
              Shows how to display a text file in a browse
              field in a form window.
}

Program DEMBRS7;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast, GoldList, GoldKey, GoldDir,
          GoldWin, GoldLink, GoldStr, GoldIO, GoldIO2, GoldIO3, GoldTint;

var
   Filename:string;
   DirFormat: ListCfg;
   DLL: DoubleLL;

procedure SetScreen;
{}
begin
   Clear(BlueOnLightRed,' ');
   ClearLine(1,YellowOnLightBlue);
   WriteCenter(1,0,' Browsing Gold-Style ');
   ClearLine(25,BlackOnYellow);
   WriteCenter(25,0,'Press ESC to finish...');
end; { SetScreen }

procedure SetFields;
{}
var
  I : Integer;
  W: byte;
begin
   CreateForms(1);
   ActivateForm(1);
   AllowEsc(true);
   {Add all the fields}
   SetFormWindow(2,2,79,23,6);
   W := FormWinNum;
   WinSetTitle(W,' Tag Your Favorites ');
   WinSetType(W,WMove);
   WinSetShowNum(W,false);
   {customize the colors}
   WinSetColor(W,WinBody,blackoncyan);
   WinSetColor(W,WinBorder,whiteoncyan);
   IOSetColor(IOButtonNorm,cyanonblue);
   IOSetColor(IOButtonNormHot,lightcyanonblue);
   IOSetColor(IOButtonHi,cyanonred);
   IOSetColor(IOButtonHiHot,whiteonred);
   IOSetColor(IOButtonDef,cyanonblue);
   IOSetColor(IOButtonDefHot,whiteonblue);
   {define the fields}
   KwikAddField(1, 1,1);
   KwikAddField(2, 49,19);
   KwikAddLastField(3, 62,19);
   {The List}
   BrowseField(1,76,17,DirFormat);  {15 character columns, 3 columns wide, 4 rows deep}
   {Buttons}
   ButtonField(2,' ~P~rint ',Stop1);
   ButtonDefaultField(3,'   ~O~K   ',finished);  {OK selected if user presses Enter}
end; {SetFields}

procedure DisplayTheFile;
{}
var
   Result: integer;
   EditAction: gAction;
begin
   {First fill the linked list with the file contents}
   InitDLLStr(DLL);
   DLLSetActiveList(DLL);
   Result := DLLLoadFromFile(Filename);
   if Result = 0 then
   begin
      InitListCfg(DirFormat);
      ListAssignDLL(Dirformat,DLL);
      SetFields;
      repeat
         DisplayAllFields;
         EditAction := EditForm(1);
         if EditAction = Stop1 then
            PromptOK('Gimme a break','Just pretend it was printed');
      until EditAction in [Finished,Escaped];
      DisposeFields;
      DisposeForms;
   end
   else
      PromptOK(' Error ','Unable to load the file');
   DLLDestroy;
end; { DisplayTheFile }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetBlinking(false);
   BBtop := 1;  {delete for beta}
   BBbot := 1;
   SetScreen;
   UseCustomChars;
   MouseShow(true);
   KeySetFast;
   FileName := FileList('*.pas',' Pick a Pascal file ');
   if Filename = '' then
      PromptOK('','You Cancelled!')
   else
   begin
      CursorOff;
      DisplayTheFile;
      CursorOn;
   end;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
