***
*   Language    : Clipper 5.0 VF
*   Date        : 01/02/95
*   Version     : 1.0
*   Author      : Philippe Bonnardel     <<< FREEWARE >>>
*   Compil      : /W/L
*   Link        : None
*   Description : Return DataBases informations in your application
*
*   Information : Questions, problems... ? My CIS-ID : 100604,1637
*
***

#define MY_OUTPUT(cLine)    (cText += cLine + CRLF)
#define CRLF                CHR(13) + CHR(10)

#define _LEFT               SPACE(12)

#define YESNO(lVal)         IF(lVal, "Yes", "No ")
#define NTRIM(nVal)         LTRIM(STR(nVal))
#define NPADC(nVal , nLen)  PADC(NTRIM(nVal), nLen)
#define NPADR(nVal , nLen)  PADR(NTRIM(nVal), nLen)
#define DPADC(dDate, nLen)  PADC(DTOC(dDate), nLen)
#define LPADC(lVal , nLen)  PADC(YESNO(lVal), nLen)           


FUNCTION INFO_DB ()
LOCAL i, j, xVar, cCurAlias, nCurIndex, nAliasRSel
LOCAL cText := "DataBases Informations" + CRLF + CRLF

IF !EMPTY(cCurAlias := ALIAS())
  MY_OUTPUT("  + DataBases Description")
  MY_OUTPUT("     Ŀ") 
  MY_OUTPUT("        Alias     Zone     Last                  Record            ")
  MY_OUTPUT("                          Update   Current   Last   Size Fields ")
  MY_OUTPUT("     Ĵ") 

  i := 0
  DO WHILE ! EMPTY(ALIAS(++i))
    MY_OUTPUT("     " + IF (ALIAS(i) == cCurAlias, " * ", "   ") + PADR(ALIAS(i), 9) +;
              "" + NPADC(i, 6) + "" + ;
              DPADC((ALIAS(i))->(LUPDATE()), 12) + "" +;
              NPADC((ALIAS(i))->(RECNO())  , 8) + "" +;
              NPADC((ALIAS(i))->(LASTREC()), 8) + "" +;
              NPADC((ALIAS(i))->(RECSIZE()), 6) + "" +;
              NPADC((ALIAS(i))->(FCOUNT()) , 7) + "")
  ENDDO
  MY_OUTPUT("     ") 
  MY_OUTPUT("     * : Current Alias")
  MY_OUTPUT("")
  
  i := 0
  DO WHILE ! EMPTY(ALIAS(++i))
    xVar := (ALIAS(i))->(DBSTRUCT())
    MY_OUTPUT("  + Description of Alias " +  "'" + ALIAS(i) + "'")
    MY_OUTPUT("     -> Fields")
    MY_OUTPUT(_LEFT + "Ŀ") 
    MY_OUTPUT(_LEFT + "    Name        Type       Length     Decimals  ")
    MY_OUTPUT(_LEFT + "Ĵ") 
  
    FOR j := 1 TO LEN(xVar)
      MY_OUTPUT(_LEFT + "" + ;
                PADC(xVar[j,1],  12) + "" +; 
                PADC(xVar[j,2],  12) + "" +;  
                NPADC(xVar[j,3], 12) + "" +;
                IF (xVar[j,2] == "N", NPADC(xVar[j,4], 12), _LEFT) + "" )
    NEXT
    MY_OUTPUT(_LEFT + "") 
  
    MY_OUTPUT("     -> Index                    ? " + ;
              IF((nCurIndex := (ALIAS(i))->(INDEXORD())) == 0, "No ", "yes"))
    
    IF (nCurIndex != 0)
      MY_OUTPUT("         - Extension             : " + (ALIAS(i))->(INDEXEXT()))
      j := 0
      DO WHILE (!EMPTY(xVar := (ALIAS(i))->(INDEXKEY(++j))))
      MY_OUTPUT("         - Key of the index n" + NPADR(j, 3) + ": " +;
                  + xVar + IF(j == nCurIndex, " (Current)", ""))
      ENDDO
    ENDIF
    
    MY_OUTPUT("     -> Filter                   : " + ;
              IF (EMPTY(xVar := (ALIAS(i))->(DBFILTER())), "None", xVar))
    
    MY_OUTPUT("     -> Relation                 ? " + ;
              IF((nAliasRSel := (ALIAS(i))->(DBRSELECT())) == 0, "None", "Yes"))
    
    IF (nAliasRSel != 0)
      MY_OUTPUT(_LEFT + "Ŀ") 
      MY_OUTPUT(_LEFT + "  N   With Alias             Relation           ")
      MY_OUTPUT(_LEFT + "Ĵ") 
      j := 0
      DO WHILE (! EMPTY(xVar := (ALIAS(i))->(DBRELATION(++j))))
        MY_OUTPUT(_LEFT   + "" + ;
                  NPADC(j, 5) + "" + ; 
                  PADC(ALIAS((ALIAS(i))->(DBRSELECT(j))), 14) + "" +;  
                  PADC(xVar, 30) + "" )
      ENDDO
      MY_OUTPUT(_LEFT + "") 
    ENDIF
    MY_OUTPUT("")
  
  ENDDO
  
  xVar := NIL
  
  MY_OUTPUT("  + Flags")
  MY_OUTPUT(_LEFT + "Ŀ")
  MY_OUTPUT(_LEFT + "   Alias     Eof()  Bof()  Deleted()  Found() ")
  MY_OUTPUT(_LEFT + "Ĵ") 
  
  i := 0
  DO WHILE ! EMPTY(ALIAS(++i))
    MY_OUTPUT(_LEFT + "" + IF (ALIAS(i) == cCurAlias, " * ", SPACE(3)) +; 
              PADR(ALIAS(i), 9) + "" +;
              LPADC((ALIAS(i))->(EOF()), 7) + "" +;
              LPADC((ALIAS(i))->(BOF()), 7) + "" +;
              LPADC((ALIAS(i))->(DELETED()), 11)  + "" +;
              LPADC((ALIAS(i))->(FOUND()), 9) + "")
  ENDDO
  MY_OUTPUT(_LEFT + "") 
  MY_OUTPUT(_LEFT + "* : Current Alias")
  MY_OUTPUT("")
ELSE
  MY_OUTPUT("  -> No current DataBase")
ENDIF

RETURN(cText)
