/*
 Function Ŀ
         Name: g_insert()            Docs: Greg Rice                      
  Description: Insert a record in a DBF file                              
               This function will insert a new record at the current      
               record pointer location or at a record number passed in.   
               It will also handle undeleting and redeleting the records  
               as they are moved. It is a simple easy way to insert a     
               record.                                                    
               It will handle index(s) also                               
                                                                          
                                                                          
                                                                          
       Author: Greg Rice                                                  
 Date created: 03-10-93                                                   
 Time created: 08:43:45am                                                 
    Copyright: National Computer Consultants                              
Ĵ
    Arguments: cFile           File to insert new record                  
             : nRecordNo       Variable to use instead of current record  
             : nIndexOrderNo   Index order number                         
 Return Value: lRetVal                                                    

*/
FUNCTION g_Insert( cFile, nRecordNo, nIndexOrderNo )

   LOCAL nSelect := Select()        // Save old work area
         lRetVal := .F.             // Retval if insert worked or not
         nCurr_rec, ;               // Current record number where to insert
         nTmp[ Fcount() ], ;        // Array to store field data to move
         i, ;                       // Loop counter
         lTo_dele                   // To store if record is deleted

   // Check if file is already opened if not open it exclusive
   // You may need to pass in the RDD also
   IF Select( cFile ) == 0
      DbUseArea( .T., "DBFNTX", cFile, , .F. )
      // Append a blank record
      DbAppend()
   ELSE
      // Select area and lock file so as to append a new record
      // can only append records in current work area
      // I am doing alot of aliasing but since you have selected
      // the work area you really do not need to just preparing
      // for the future
      DbSelectArea( cFile )
      IF ( cFile )->( Flock() )
         // Append a new record at the bottom of the file
         // probably need more error checking in some places
         // like for network errors
         DbAppend()
      ELSE
         // Could not lock file get out of here and return false
         // probably need more error checking in some places
         Select( nSelect )
         RETURN( lRetVal )
      ENDIF
   ENDIF

   // Save current record number or where you want to
   // insert new record
   IF nRecordNo == NIL
      nCurr_rec := ( cFile )->( Recno() )
   ELSE
      nCurr_rec := nRecordNo
   ENDIF

   // If you have opened index(s)
   // Do not close index(s) just set order to 0 so as
   // to use natural record order and still update
   // the index(s)
   IF nIndexOrderNo != NIL
      ( cFile )->( DbSetOrder( 0 ) )
   ENDIF

   // Process all records greater than the position
   // that you are inserting at record number since
   // your starting at the last record or bottom of file
   // Like I said above all of the Aliasing is not needed
   DO WHILE nCurr_rec < ( cFile )->( Recno() )

      // Skip back one from the bottom
      ( cFile )->( DbSkip( -1 ) )

      // Get the data from the fields into an array
      // Could use DbEval also
      FOR i := 1 to ( cFile )->( Fcount() )
         nTmp[i] := ( cFile )->( Fieldget( i ) )
      NEXT

      // Check to see if file is deleted. Need to recall
      // before moving the record to new record number.
      // New record number will be redeleted later
      lTo_dele := ( cFile )->( Deleted() )

      ( cFile )->( DbRecall() )

      // First time you move a record you skip back to the
      // last record
      ( cFile )->( DbSkip() )

      // Put the new data from previous record in this record
      // Could use DbEval also
      FOR i := 1 to ( cFile )->( Fcount() )
         ( cFile )->( Fieldput( i, nTmp[i] ) )
      NEXT

      // If record was deleted above redelete it
      IF lTo_dele
         ( cFile )->( DbDelete() )
      ENDIF

      // Skip back a record
      // Will skip back another record at to of DO WHILE LOOP
      ( cFile )->( DbSkip( -1 ) )

   ENDDO

   // If you have opened index(s)
   // Reset index order back before updating the record
   // at the insertation place
   IF nIndexOrderNo != NIL
      ( cFile )->( DbSetOrder( nIndexOrderNo ) )
   ENDIF

   // Go to bottom or last record
   ( cFile )->( DbGoBottom() )

   // Skip to fantom record which has blank fields
   // to get blank fields that go into the inserted record
   ( cFile )->( DbSkip() )

   FOR i := 1 to ( cFile )->( Fcount() )
      nTmp[i] := ( cFile )->( Fieldget( i ) )
   NEXT

   // Go to inserted record position
   ( cFile )->( DbGoTo( nCurr_rec ) )

   // Blank out fields with data from fantom record
   FOR i := 1 to ( cFile )->( Fcount() )
      ( cFile )->( Fieldput( i, nTmp[i] ) )
   NEXT

   // Be sure to recall this record in case the record that
   // was previously here at this record number was deleted
   // The new inserted record will not be deleted
   ( cFile )->( DbRecall() )

   // ( cFile )->( DbGoTo( nCurr_rec ) )

   lRetVal := .T.

RETURN( lRetVal )

