
/*
 *  Function:     GetPropertyIndex()
 *
 *  Description:  Gets index of named Visual Basic control property
 *
 *  Parameters:   hctl         -- handle to control
 *                lpszPropName -- property name
 *
 *  Returns:      index of property; returns -1 if property not found
 */

short GetPropertyIndex (HCTL hctl, LPSTR lpszPropName)
{
   PPROPINFO FAR * PropertyArray;
   LPPROPINFO lpPropInfo;
   short i;
   LPSTR lpsz;

   PropertyArray = GetPropertyArray(hctl);
   if (!PropertyArray)
      return -1;
   for (i = 0; ; i++)
   {
      lpPropInfo = GetProperty(PropertyArray, i);
      if (!lpPropInfo)
         break;  // have reached end of PropertyArray[]
      lpsz = (LPSTR)MAKELONG(lpPropInfo->npszName, (_segment)lpPropInfo);
      if (!lstrcmp(lpsz, lpszPropName))
         return i;
   }
   
   return -1;
}

