// MODAL2, MODALDLG's behaviour
//////////////////////////////////////////////////////
#include "MODALDLG.HPP"
#include "KW.HPP"
#include <assert.h>

const char far MODALDLG::A_HPTR[] = "a";
const char far MODALDLG::A_LPTR[] = "b";

BOOL CALLBACK _export
MODALDLG::_DlgProc(HWND hWnd, UINT iMsg,
				WPARAM wParam, LPARAM lParam)
{
MODALDLG* p = HWIN2this(hWnd);
if(p == 0){
	if(iMsg != WM_INITDIALOG)
		return FALSE;
	SetProp(hWnd, A_HPTR, (HANDLE)(HIWORD(lParam)));
	SetProp(hWnd, A_LPTR, (HANDLE)(LOWORD(lParam)));
	((MODALDLG*)lParam)->_hDlg = hWnd;
	p = HWIN2this(hWnd);
	}
assert(hWnd == p->_hDlg);
return p->proc(iMsg, wParam, lParam);
}

BOOL MODALDLG::proc(UINT iMsg,
					WPARAM wParam, LPARAM lParam)
{
int i;
STR Buf;
WORD wId, wCmd;
CTL* Last = 0;
switch(iMsg){
	case WM_INITDIALOG:
		_thinFontJob();
		SetWindowText(_hDlg,
					_dlgline.value(KW::LABEL, Buf));
		Buf[0] = 0;
		SetDlgItemText(_hDlg, IDOK,
					_dlgline.value(KW::OK, Buf));
		Buf[0] = 0;
		SetDlgItemText(_hDlg, IDCANCEL,
					_dlgline.value(KW::CANCEL, Buf));
		for(i = 0; i < _ng; i++)
			SetDlgItemText(_hDlg, i+3, _pGXY[i].name);
		for(i = _xOffset; i < _xOffset +_nCtls; i++){
			CTL* pCtl = _ctab[i].ctl;
			if(pCtl != 0 && pCtl != Last){
				pCtl->initScreen(_hDlg);
				Last = pCtl;
				}
			}
		_nActiveGroup = -1;
		_forceActiveGroup(_guru->get(_dsect, 0));
		_centerOnScreen();
		break;

	case WM_DRAWITEM:
		_drawTab((LPDRAWITEMSTRUCT)lParam);
		break;

	case WM_COMMAND:
		wId = LOWORD(wParam);
#if defined(WIN32)
		wCmd = HIWORD(wParam);
#else
		wCmd = HIWORD(lParam);
#endif
		if(wId >= _ng + 3){
			CTL* pCtl = _ctab[wId].ctl;
			if(pCtl)
				return pCtl->wm_command(wId, wCmd);
			}
		switch(wId){
			case IDOK:
				_endDialog(SHOWDATA::OK);
				break;
			case IDCANCEL:
				_endDialog(SHOWDATA::CANCEL);
				break;
			default:
				_setActiveGroup(wId-3);
				break;
			}
		break;

	default:
		return FALSE;
	}
return TRUE;
}

void MODALDLG::_endDialog(SHOWDATA::RET Result)
{
if(Result == SHOWDATA::OK){
	int i;
	CTL *Last = 0;
	// check consistency first:
	for(i = _xOffset; i < _xOffset + _nCtls; i++){
		CTL* pCtl = _ctab[i].ctl;
		if(pCtl != 0  && pCtl != Last){
			if(!pCtl->isDataOk()){
				_forceActiveGroup(_ctab[i].group);
				SetFocus(GetDlgItem(_hDlg, i));
				return;
				}
			Last = pCtl;
			}
		}
	// save data:
	for(i = _xOffset; i < _xOffset + _nCtls; i++){
		CTL* pCtl = _ctab[i].ctl;
		if(pCtl != 0  && pCtl != Last){
			pCtl->saveData();
			Last = pCtl;
			}
		}
	// save last active group for next dialog show:
	((SHOWDATA*)_guru)->set(_dsect, _nActiveGroup);
	}
RemoveProp(_hDlg, A_HPTR);
RemoveProp(_hDlg, A_LPTR);
EndDialog(_hDlg, (int)Result);
}

void MODALDLG::_forceActiveGroup(int nG)
{
_setActiveGroup(nG);
InvalidateRect(_hDlg, NULL, TRUE);
}

void MODALDLG::_setActiveGroup(int nG)
{
if(_nActiveGroup == nG || !_ng)
	return;
int Last = _nActiveGroup;
_nActiveGroup = nG;
InvalidateRect(GetDlgItem(_hDlg, 3 + nG), NULL, TRUE);
InvalidateRect(GetDlgItem(_hDlg, 3 + Last), NULL, TRUE);
for(int i = _xOffset; i < _xOffset + _nCtls; i++){
	HWND hItem = GetDlgItem(_hDlg, i);
	if(_ctab[i].group == _nActiveGroup)
		ShowWindow(hItem, SW_RESTORE);
	else
		ShowWindow(hItem, SW_HIDE);
	}
}

SHOWDATA::RET MODALDLG::run()
{
HGLOBAL hMem;
DLGPROC lpfn;

hMem = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT,
					_template.len());
if(!hMem)
	return SHOWDATA::MEMORYOUT;
char* lpTempl = (char*)GlobalLock(hMem);
memcpy(lpTempl, _template.get(), _template.len());
GlobalUnlock(hMem);
lpfn = (DLGPROC)MakeProcInstance((FARPROC)_DlgProc,
								_hI);
int res = DialogBoxIndirectParam(_hI, hMem, _hP,
							lpfn, (LPARAM)this);
FreeProcInstance((FARPROC)lpfn);
GlobalFree(hMem);
if(res == -1)
	return SHOWDATA::SYNTAXERR;
return (SHOWDATA::RET)res;
}

