////////////////////////////////////////////////////////////////////////////
// MEMBLOCK implementation
////////////////////////////////////////////////////////////////////////////
#include "MEMBLOCK.HPP"
#include <mem.h>

MEMBLOCK::MEMBLOCK()
{
_len = _space = _maxAdd = 0;
_buf = 0;
}

MEMBLOCK::~MEMBLOCK()
{
if(_buf != 0){
	delete _buf;
	_buf = 0;
	}
}

short MEMBLOCK::add(const unsigned char Slot[], unsigned long SlotLength)
{
if(_maxAdd < SlotLength)
	_maxAdd = SlotLength;
if(_len + SlotLength <= _space){
	for(unsigned long k = 0; k < SlotLength; k++)
		_buf[k+_len] = Slot[k];
	_len += SlotLength;
	return 1;
	}
if(!addSpace(60000UL))
	return 0;
for(unsigned long k = 0; k < SlotLength; k++)
	_buf[k+_len] = Slot[k];
_len += SlotLength;
return 1;
}

unsigned long MEMBLOCK::space() const
{
return _space;
}

short MEMBLOCK::addSpace(unsigned long ExtraLength)
{
unsigned long lNew =_len + ExtraLength;
unsigned char huge *  pNew = new huge unsigned char[lNew];
if(pNew == 0)
	return 0;
for(unsigned long k = 0; k < _len; k++)
	pNew[k] = _buf[k];
delete _buf;
_buf = pNew;
_space = lNew;
return 1;
}
