// CTLRADIO implementation
//////////////////////////////////////////////////////
#include "CONTROLS.HPP"
#include "KW.HPP"

CTLRADIO::CTLRADIO(const DESCRIPT& Desc,
			SHOWDATA* Guru,
			const CTLMAPPER* Map)
	: CTL(Desc, Guru), _map(Map)

{
STR Label;
_desc.value(KW::LABEL, Label);
_duwText = _map->duwText(Label);

MULTIPARAM Iter(&_desc, KW::R);
_nR = Iter.no();
int duwMaxText = 0;
for(int i = 0; i < _nR; i++){
	STR Rad;
	Iter.value(i, Rad);
	duwMaxText = max(duwMaxText, _map->duwText(Rad));
	}
_duwCombo = duwMaxText + _map->duSquareBox() + 8;
_bInOneLine = (_duwText + _duwCombo) <
				((2*_map->duwScreen()) / 3);
if(_bInOneLine){
	_duw = 1 + _duwText + _duwCombo;
	_duh = _map->duSquareBox();
	}
else{
	_duw = max(_duwText, _duwCombo);
	_duh = 1 + _map->duhText() + _map->duSquareBox();
	}
}

CTLRADIO::~CTLRADIO()
{
}

int CTLRADIO::addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplate,
						int duX, int duY)
{
CTL::DLGITEM text(CTL::_Text);
CTL::DLGITEM comb(CTL::_Combo);

text.dtilCX = _duwText;
text.dtilCY = _map->duhText();

comb.dtilCX = _duwCombo;
comb.dtilCY = _map->duSquareBox() + _nR * 8;

text.dtilX = duX;
text.dtilY = duY;
if(_bInOneLine){
	text.dtilY += 1;
	comb.dtilX = duX + _duwText + 1;
	comb.dtilY = duY;
	}
else{
	comb.dtilX = duX;
	comb.dtilY = duY + _map->duhText() + 1;
	}
_idT = nFirstFreeId;
_idCB = nFirstFreeId + 1;

text.dtilID = _idT;
comb.dtilID = _idCB;

pTemplate->add((unsigned char*)&text, sizeof(text));
pTemplate->add((unsigned char*)&comb, sizeof(comb));
return 2;
}

void CTLRADIO::dataToScreen()
{
STR Label;
_desc.value(KW::LABEL, Label);
SetDlgItemText(_hDlg, _idT, Label);

MULTIPARAM Iter(&_desc, KW::R);
for(int i = 0; i < _nR; i++){
	STR Rad;
	Iter.value(i, Rad);
	SendDlgItemMessage(_hDlg, _idCB, CB_INSERTSTRING,
						i, (LPARAM)(const char*)Rad);
	}

STR Var;
_desc.value(KW::VAR, Var);
int val = _guru->get(Var);
if(val < 0 || _nR <= val)
	val = 0;
SendDlgItemMessage(_hDlg, _idCB, CB_SETCURSEL, val, 0);
}

void CTLRADIO::saveData()
{
int val = SendDlgItemMessage(_hDlg, _idCB,
				CB_GETCURSEL, 0, 0);
STR Var;
_desc.value(KW::VAR, Var);
_guru->set(Var, val);
}

