// CTLEDIT implementation
//////////////////////////////////////////////////////
#include "CONTROLS.HPP"
#include "KW.HPP"

CTLEDIT::CTLEDIT(const DESCRIPT& Desc,
			SHOWDATA* Guru,
			const CTLMAPPER* Map
			)
	: CTL(Desc, Guru), _map(Map)
{
STR Label;
_desc.value(KW::LABEL, Label);
_duwText = _map->duwText(Label);
int nAvChars = _desc.value(KW::WIDTH, 8);
STR Edit(nAvChars+2);
for(int i = 0; i < nAvChars; i++)
	Edit += 'X';
_duwEdit = _map->duwText(Edit);
_bInOneLine = (_duwText + _duwEdit) <
				((2*_map->duwScreen()) / 3);
if(_bInOneLine){
	_duw = 1 + _duwText + _duwEdit;
	_duh = _map->duhEdit();
	}
else{
	_duw = max(_duwText, _duwEdit);
	_duh = 1 + _map->duhText() + _map->duhEdit();
	}
}

CTLEDIT::~CTLEDIT()
{
}

int CTLEDIT::addToDlg(int nFirstFreeId,
						MEMBLOCK *pTemplate,
						int duX, int duY)
{
CTL::DLGITEM text(CTL::_Text);
CTL::DLGITEM edit(CTL::_Edit);

text.dtilCX = _duwText;
text.dtilCY = _map->duhText();

edit.dtilCX = _duwEdit;
edit.dtilCY = _map->duhEdit();

text.dtilX = duX;
text.dtilY = duY;
if(_bInOneLine){
	text.dtilY += 1;
	edit.dtilX = duX + _duwText + 1;
	edit.dtilY = duY;
	}
else{
	edit.dtilX = duX;
	edit.dtilY = duY + _map->duhText() + 1;
	}
_idT = nFirstFreeId;
_idE = nFirstFreeId + 1;

text.dtilID = _idT;
edit.dtilID = _idE;

pTemplate->add((unsigned char*)&text, sizeof(text));
pTemplate->add((unsigned char*)&edit, sizeof(edit));
return 2;
}


void CTLEDIT::dataToScreen()
{
STR Label;
_desc.value(KW::LABEL, Label);
SetDlgItemText(_hDlg, _idT, Label);

STR Var;
_desc.value(KW::VAR, Var);
_guru->get(Var, _contents);
if(!isOkOnTheFly(_contents))
	_contents[0] = 0;
SetDlgItemText(_hDlg, _idE, _contents);

int nMaxChar;
if(0 != (nMaxChar = _desc.value(KW::MAXLEN)))
	SendDlgItemMessage(_hDlg, _idE,
						EM_LIMITTEXT, nMaxChar, 0);
}

void CTLEDIT::saveData()
{
STR Var;
_desc.value(KW::VAR, Var);
_guru->set(Var, _contents);
}

BOOL CTLEDIT::isDataOk()
{
if(0 != _desc.value(KW::NOEMPTY) && !_contents.len())
	return FALSE;
return TRUE;
}

BOOL CTLEDIT::wm_command(int , int nCommand)
{
switch(nCommand){
	case EN_CHANGE:{
		STR Current;
		int i = 100;
		while(TRUE){
			STR Buf(i);
			if(i > GetDlgItemText(_hDlg, _idE,
					(char*)(const char*)Buf, i)){
				Current = Buf;
				break;
				}
			else
				i *= 2;
			}
		if(isOkOnTheFly(Current)){
			_contents = Current;
			}
		else{
			SetDlgItemText(_hDlg, _idE, _contents);
			MessageBeep(0);
			}
		return TRUE;
		}
	default:
		return FALSE;
	}
}

