////////////////////////////////////////////////////////////////////////////
// MEMBLOCK, an extensible memory block
////////////////////////////////////////////////////////////////////////////
#if !defined(MEMBLOCK_HPP)
#define MEMBLOCK_HPP
#if !defined(RC_INVOKED)	// no Windows RC compiler, real C++ stuff below
class MEMBLOCK {
public:
	MEMBLOCK();
	~MEMBLOCK();

	short add(const unsigned char Slot[], unsigned long SlotLength);
		//returns 1 if ok
	unsigned long len() const { return _len; }
	const unsigned char huge* get() const { return _buf; }
	unsigned long maxAdd() const { return _maxAdd; }

protected:
	unsigned long space() const;
	short addSpace(unsigned long ExtraLength);
		//returns 1 if ok

private:
	MEMBLOCK(const MEMBLOCK&);
	MEMBLOCK& operator=(const MEMBLOCK&);

	unsigned char huge * _buf;
	unsigned long _space;
	unsigned long _len;
	unsigned long _maxAdd;
};
#endif
#endif
