//͸
//  Program:      DEMO.PR1                                                   
//  Created:      06/19/95    19:59:22                                       
//                                                                           
//         Written By:  Mark H. Kania                                        
//         Builder v2.3 Demo Program                                         
//       Copyright (c) 1995 Aeolus Software                                  
//                                                                           
//  Compile:      Clipper Demo /n /w                                         
//     Link:      {linker} Fi Demo,BMouse Li Builder,BldrAsm                 
//                                                                           
//      --- Source Created Automatically by the Aeolus BUILDER v2.3 ---      
//͵
//                               FUNCTION MAP:                               
//                                                                           
//          Funcs are not in 'map order' in the program.  This is a          
//         listing of the order funcs are executed.  In other words          
//                           a logic flow diagram.                           
//                                                                           
//  MENU - Root Menu                                                         
//      MENU002 - Builder Menu                                               
//        MENU006 - Menus Menu                                               
//          HAND022 - View BDEMO002.TXT (Menus)                              
//        MENU005 - Dialogs Menu                                             
//          HAND023 - View BDEMO003.TXT (Dialogs)                            
//          DLOG035 - Dialog Sample                                          
//            HAND036 - Dialog Prompt                                        
//              DLOG037 - Show Progress Thermometer                          
//                HAND038 - Display Progress Thermometer                     
//          DLOG153 - Sample Dialog All Controls                             
//        MENU003 - Picklist Menu                                            
//          HAND102 - Picklist No Options Setup                              
//            PLST027 - No Options Picklist                                  
//              HAND032 - No Opts Picklist Selection                         
//          DLOG028 - Bounded by Picklist (By State)                         
//            HAND056 - Setup Bounded by Picklist                            
//              PLST029 - Picklist Bounded by Sample                         
//                HAND033 - Bounded Picklist Selection                       
//          HAND103 - QWERTY Scroll Option Setup                             
//            PLST030 - QWERTY Picklist Sample                               
//              HAND031 - QWERTY Picklist Selection                          
//          HAND024 - View BDEMO004.TXT (PickLists)                          
//          DLOG128 - Lateral Scroll Picklist Sample                         
//            HAND129 - Lateral Scroll Picklist Sample                       
//              PLST130 - Lateral Scroll Picklist Sample                     
//                HAND133 - Lateral Scroll Picklist Sample                   
//        MENU004 - File Maintenance Menu                                    
//          HAND025 - View BDEMO005.TXT (F Maint)                            
//          HAND104 - File Maintenance Setup                                 
//            FMNT034 - City File Maintenance                                
//        HAND150 - Initialize Parm Passing                                  
//          DLOG020 - Builder Desc Text File View                            
//            HAND021 - View BDEMO001.TXT                                    
//        MENU008 - BMOUSE Menu                                              
//          HAND026 - View BDEMO006.TXT (bMouse)                             
//        HAND138 - View BDEMO019.TXT (Incentives)                           
//        MENU147 - TBrowse Menu                                             
//          HAND148 - View BDEMO020.TXT (Incentives)                         
//          HAND149 - Position TBrowse Database                              
//            BRWS146 - TBrowse Demo                                         
//              BRWS152 - Related TBrowse Test                               
//      MENU007 - Breport Menu                                               
//        HAND039 - View BDEMO007.TXT (Breport)                              
//      MENU009 - Library Menu                                               
//        HAND040 - View BDEMO008.TXT (Lib Funcs)                            
//        MENU017 - Screen Menu                                              
//          DLOG041 - Winpush/Pop Sample                                     
//          DLOG042 - Center() Sample                                        
//            HAND043 - Center() Sample                                      
//          DLOG044 - Message Sample                                         
//            HAND045 - Message Sample                                       
//          MENU046 - MsgBox() Menu                                          
//            HAND047 - Plain MsgBox() Sample                                
//            HAND048 - Array MsgBox() Sample                                
//            HAND049 - Menu MsgBox() Sample                                 
//            HAND050 - Prompt MsgBox() Sample                               
//          DLOG051 - SetMsgLin() Sample                                     
//            HAND105 - SetMsgLin() Sample                                   
//          DLOG052 - Thermometr() Sample                                    
//            HAND053 - Thermometr() Sample                                  
//          HAND054 - View BDEMO009.TXT (Screen)                             
//          DLOG064 - AddPrompt() Sample                                     
//          DLOG065 - Ask() Sample                                           
//            HAND066 - Ask() Sample                                         
//          DLOG067 - AskMenu() Sample                                       
//            HAND068 - AskMenu() Sample                                     
//          HAND134 - aPop() Sample                                          
//          DLOG141 - GetEdit() Sample                                       
//            DLOG140 - AbGetEdit() Sample                                   
//        MENU016 - Database Menu                                            
//          DLOG057 - Gen_Maint() Lib Func                                   
//            HAND142 - Parm Pass mOpts                                      
//              FMNT058 - City File Maintenance                              
//          DLOG059 - Rel_Maint() Sample                                     
//            HAND060 - Rel_Maint() Sample                                   
//              DLOG063 - Rel_Maint() Sample                                 
//                HAND139 - Rel_Maint() Sample                               
//                  PLST061 - Rel_Maint() Sample                             
//                    RMNT062 - Rel_Maint() Sample (Maint)                   
//          DLOG069 - Plist() Sample                                         
//          DLOG072 - Save_It() Sample                                       
//          DLOG070 - Browser() Sample                                       
//            HAND071 - Browser() Sample                                     
//          DLOG073 - Fld_Repl() Sample                                      
//          DLOG074 - iSeek() Sample                                         
//          DLOG082 - Open_Fil() Sample                                      
//          HAND055 - View BDEMO010.TXT (Database)                           
//        MENU015 - Valid Menu                                               
//          DLOG077 - Show_Text() Sample                                     
//          DLOG075 - PckVld() Sample                                        
//          DLOG076 - ChkChk() Sample                                        
//          DLOG078 - InFile() Sample                                        
//          DLOG079 - DupChk() Sample                                        
//          DLOG080 - GenVld() Sample                                        
//          DLOG081 - Req() Sample                                           
//          DLOG083 - Rght_Jst() Sample                                      
//            HAND084 - Rght_Jst() Sample                                    
//          HAND085 - View BDEMO011.TXT (Valid)                              
//        MENU014 - DOS Menu                                                 
//          DLOG089 - ChgDir() Sample                                        
//            HAND090 - ChgDir() Sample                                      
//          DLOG091 - ChgDsk() Sample                                        
//          DLOG092 - MakDir() Sample                                        
//            HAND093 - MakDir() Sample                                      
//          DLOG094 - InPath() Sample                                        
//            HAND095 - InPath() Sample                                      
//          DLOG096 - MaxHndls() Sample                                      
//            HAND097 - MaxHndls() Sample                                    
//          HAND086 - View BDEMO012.TXT (DOS)                                
//          DLOG160 - Shift States Dialog                                    
//            HAND161 - Shift State Demo                                     
//          DLOG162 - DrvTst() Sample Dialog                                 
//            HAND163 - DrvTst() function hand code                          
//        MENU013 - Text Menu                                                
//          DLOG098 - fEof() Sample                                          
//          DLOG099 - fGets() Sample                                         
//          DLOG100 - fGetsR() Sample                                        
//          DLOG101 - TextView() Sample                                      
//          HAND087 - View BDEMO013.TXT (Text Files)                         
//        MENU012 - Memo Menu                                                
//          DLOG106 - Edt_Memo() Sample                                      
//            HAND107 - Edt_Memo() Sample                                    
//          DLOG108 - Show_Memo() Sample                                     
//          HAND088 - View BDEMO014.TXT (Memo Files)                         
//        MENU011 - Control Menu                                             
//          DLOG111 - TimeOut() Sample                                       
//            HAND112 - TimeOut() Sample                                     
//              DLOG113 - TimeOut() Sample                                   
//          DLOG110 - TotalKeyOn()/TotalKeyOff()                             
//          HAND109 - View BDEMO015.TXT (Control)                            
//        MENU010 - Conversion Menu                                          
//          DLOG115 - Hex2Dec() Sample                                       
//            HAND116 - Hex2Dec() Sample                                     
//          DLOG117 - Dec2Hex() Sample                                       
//            HAND118 - Dec2Hex() Sample                                     
//          DLOG125 - Asc2Bin() Sample                                       
//          HAND114 - View BDEMO016.TXT (Convrsn)                            
//        MENU018 - Other Lib Funcs Menu                                     
//          DLOG121 - ErrTone() Sample                                       
//            HAND124 - ErrTone() Sample                                     
//          DLOG122 - WaitKey() Sample                                       
//            HAND123 - WaitKey() Sample                                     
//          DLOG131 - Between() Sample                                       
//          DLOG132 - Numeric() Sample                                       
//          DLOG135 - DbState() Sample                                       
//          HAND120 - View BDEMO018.TXT (Other)                              
//        MENU019 - Mouse Lib Funcs Menu                                     
//          DLOG126 - AddMPad()/DelMPad() Sample                             
//            HAND127 - AddMPad()/DelMPad() Sample                           
//          HAND119 - View BDEMO017.TXT (Mouse)                              
//          DLOG136 - MouseInit() Sample                                     
//        MENU154 - Pop Ups Menu                                             
//          HAND155 - Display BDEMO021.TXT                                   
//          HAND156 - Main Color Change Demo                                 
//          HAND157 - TBrowse Colors Demo                                    
//          HAND158 - Calendar Popup Demo                                    
//          HAND159 - Calculator Pop Up Demo                                 
//͵
//  Additional Procs/Funcs in this Source File:                              
//                                                                           
//  CHKNTXS       - Verify All System Indexes, Build if Missing.             
//  OPENFILES     - Open All System Database and Indexes.                    
//  DBINIT1       - Initialize Database Field Arrays.                        
//                                                                           
//;

#include "Demo.ch"
#include "Builder.ch"
#include "Inkey.ch"
#include "Set.ch"
#include "SetCurs.ch"


// Static Arrays to Hold Database Field Data
STATIC aCities := {},aFriends := {}

PROCEDURE Start()
   // This just branches around Dbinit1().  So that you have the
   // opportunity to read the Dbinit1() comments.
   Main()
   SETCOLOR( "W/N" )
   CLS
   RETURN

//͸
// Initialize All Database Static Arrays                                    
//͵
//                                                                          
//  Builder places database field data into STATIC arrays allowing more     
//  control for field edits etc.  This, however, means that access to the   
//  database fields in other modules will require that the proper array(s)  
//  are passed as parameters into those modules.  Note that all code        
//  within this .PRG does not require this parameter passing, only outside  
//  modules.  Outside modules should also #include the Builder created      
//  header file that contains the manifest constants which access the       
//  database field arrays.                                                  
//                                                                          
//  Each of the array elements for the database arrays created in this      
//  procedure has its own unique manifest constant defined.  Using the      
//  manifest constants instead of array syntax makes for more readable      
//  code.  See the header file Demo.ch for the constants to                 
//  access database data in this program.                                   
//                                                                          
//  REMEMBER:  Manifest constants are CASE SENSITIVE!!                      
//                                                                          
//;
PROCEDURE DbInit1()
   aCities := ARRAY(Cities->(FCOUNT()))
   Cities->(DbStor(aCities,"EMPTY"))

   aFriends := ARRAY(Friends->(FCOUNT()))
   Friends->(DbStor(aFriends,"EMPTY"))

   RETURN

PROCEDURE Main()
LOCAL I,GetList := {},e,oOldErrBlk

// Initialize Clipper SET's 
ALTD( 0 )          // Need Alt+D for Menus
SET(_SET_SOFTSEEK,.T.)
SET(_SET_DELETED,.T.)
SET(_SET_SCOREBOARD,.F.)
SET(_SET_WRAP,.T.)
SET(_SET_CONFIRM,.F.)
SET(_SET_EPOCH,1964)
SETCURSOR(SC_NONE)

// Post the Builder Errorblock with error outuput to be sent to
// BLDRERR.DBF.  Change "FILE" to "SCREEN" to redirect output
// to the screen.
oOldErrBlk := ERRORBLOCK( {|e| BldrErr(e,"FILE") } )

SET DATE AMERICAN
SET CENTURY OFF

// Initialize System Variables 
USE Options NEW SHARED ALIAS Options VIA "DBFNTX"

Options->(SetColors())                         // set Builder defaults
Var(WNDW_STYLE,Options->WndwStyle)             // Set Default Window Style
// set up defaults from OPTIONS.DBF
SET(_SET_PRINTFILE,"LPT"+Options->Prt_Port)
Var(NETWORK,(Options->NtWrk="Y"))              // tell library if shared environment
Var(XPLODE,(Options->wXPlde="Y"))              // tell library if exploding windows
Var(B_HELP_EDIT,(Options->Help_Edit=="Y"))     // Allow/Disallow Editting of Help File
Var(B_HELP_ON,(Options->Help_On=="Y"))         // set to .T. if Help System On
Var(B_HMAX_LINS,Options->HMax_Lins)            // max lines editable if QHELP_EDIT is

// Display Background Screen 
DISPBOX(00,00,MAXROW(),MAXCOL(),REPLICATE(CHR(176),9),Var(BKGD_CLR_))

// Display Company/System Name in Screen Header Box
SETCOLOR(Var(HDR_CLR_))
@ 00,00,03,79 WINDOW NOSHADOW NOSAVE
Message(" F1-Help ",00,70,00,Var(HDR_CLR_))
Center(ALLTRIM(Options->Sys_Name),01,01,78,Var(HDR_MSG_))
Center(ALLTRIM(Options->Appl_Name),02,01,78,Var(HDR_MSG_))

// Turn on Mouse Awareness
MouseInit()

// Open All Application Files 

// Verify Existence of All Application Indexes and Create if Missing
ChkNtxs()

// Open All System Files and Indexes
OpenFiles()
DbInit1()

//͸
//  Main Program Loop - Calls Root Menu                                      
//;
// Turn on Mouse Awareness
MouseInit()
SETKEY(K_F1,{|p,l,v|ABHelp(p,l,v)})
AddMPad(00,71,00,77,0,{||Kybd(CHR(K_F1))},TRUE)
DO WHILE .T.
   RootMenu()
   SetMsgLin(" Press Y-Yes or N-No ",TRUE)
   IF MsgBox("Exit System?",Var(BRWS_CLR_),,{"< Yes >","< No >"}) == 1
      EXIT
   ENDIF
ENDDO

// Clean Up and Exit to OS 
EXIT PROCEDURE MainExit()
   LOCAL nRow := ROW()
   LOCAL nCol := COL()

   SETCOLOR(Var(BRWS_CLR_))
   @ 10,29,14,51 WINDOW STYLE "3+"
   @ 02,03 WINSAY "Closing Files..."
   DBCLOSEALL()
   SETCOLOR("W/N")
   SETCURSOR(SC_NORMAL)
   WINDOW REMOVE
   DEVPOS( nRow, nCol )
   RETURN

//͸
//  >>>>>>>>>>>>>>>>>>>>>>>>>>>> Menuing Sytem <<<<<<<<<<<<<<<<<<<<<<<<<<<<  
//;

//͸
//  ROOT MENU OF MENUING SYSTEM                                              
//;
PROCEDURE RootMenu()
   LOCAL aMenuArray := {}
   LOCAL nOpt := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 03,00,03,79 WINDOW STYLE "  " NOSHADOW
   VarPush("MENU001")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 00,01 WINPROMPT " About Builder " TO aMenuArray EXECUTE Menu002()
   @ 00,16 WINPROMPT " About Breport " TO aMenuArray EXECUTE Menu007()
   @ 00,31 WINPROMPT " Library Functions " TO aMenuArray EXECUTE Menu009()

   nOpt := Menu(aMenuArray,nOpt)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Root Menu Selection << About Builder >>                       
//;
PROCEDURE Menu002()
   LOCAL aMenuArray := {}
   LOCAL nOpt1 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 04,01,15,20 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU002")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description      " TO aMenuArray EXECUTE Hand150()
   @ 02,00 WINSAY "Ĵ"
   @ 03,01 WINPROMPT " Menus            " TO aMenuArray EXECUTE Menu006()
   @ 04,01 WINPROMPT " Dialogs          " TO aMenuArray EXECUTE Menu005()
   @ 05,01 WINPROMPT " Picklists        " TO aMenuArray EXECUTE Menu003()
   @ 06,01 WINPROMPT " File Maintenance " TO aMenuArray EXECUTE Menu004()
   @ 07,01 WINPROMPT " TBrowse          " TO aMenuArray EXECUTE Menu147()
   @ 08,00 WINSAY "Ĵ"
   @ 09,01 WINPROMPT " BMOUSE.OBJ       " TO aMenuArray EXECUTE Menu008()
   @ 10,01 WINPROMPT " Incentives       " TO aMenuArray EXECUTE Hand138()

   TtlKeyOn()                 // enable left/right menu movement
   nOpt1 := Menu(aMenuArray,nOpt1)
   TtlKeyOff()                // disable left/right menu movement

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Picklists >> in Proc:  MENU002                   
//;
PROCEDURE Menu003()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 09,20,15,43 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU003")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description          " TO aMenuArray EXECUTE Hand024()
   @ 02,01 WINPROMPT " No Options           " TO aMenuArray EXECUTE Hand102()
   @ 03,01 WINPROMPT " Bounded by Option    " TO aMenuArray EXECUTE Dlog028()
   @ 04,01 WINPROMPT " QWERTY Scroll Option " TO aMenuArray EXECUTE Hand103()
   @ 05,01 WINPROMPT " Lateral Scrolling    " TO aMenuArray EXECUTE Dlog128()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << File Maintenance >> in Proc:  MENU002            
//;
PROCEDURE Menu004()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 10,20,13,34 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU004")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand025()
   @ 02,01 WINPROMPT " Sample      " TO aMenuArray EXECUTE Hand104()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Dialogs >> in Proc:  MENU002                     
//;
PROCEDURE Menu005()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 08,20,12,38 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU005")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description     " TO aMenuArray EXECUTE Hand023()
   @ 02,01 WINPROMPT " Sample Dialog 1 " TO aMenuArray EXECUTE Dlog035()
   @ 03,01 WINPROMPT " Sample Dialog 2 " TO aMenuArray EXECUTE Dlog153()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Menus >> in Proc:  MENU002                       
//;
PROCEDURE Menu006()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 07,20,09,34 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU006")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand022()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Root Menu Selection << About Breport >>                       
//;
PROCEDURE Menu007()
   LOCAL aMenuArray := {}
   LOCAL nOpt1 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 04,16,06,30 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU007")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand039()

   TtlKeyOn()                 // enable left/right menu movement
   nOpt1 := Menu(aMenuArray,nOpt1)
   TtlKeyOff()                // disable left/right menu movement

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << BMOUSE.OBJ >> in Proc:  MENU002                  
//;
PROCEDURE Menu008()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 13,20,15,34 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU008")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand026()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Root Menu Selection << Library Functions >>                   
//;
PROCEDURE Menu009()
   LOCAL aMenuArray := {}
   LOCAL nOpt1 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 04,31,17,46 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU009")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description  " TO aMenuArray EXECUTE Hand040()
   @ 02,01 WINPROMPT " Screen       " TO aMenuArray EXECUTE Menu017()
   @ 03,01 WINPROMPT " Database     " TO aMenuArray EXECUTE Menu016()
   @ 04,01 WINPROMPT " Valid        " TO aMenuArray EXECUTE Menu015()
   @ 05,01 WINPROMPT " DOS/Assembly " TO aMenuArray EXECUTE Menu014()
   @ 06,01 WINPROMPT " Text Files   " TO aMenuArray EXECUTE Menu013()
   @ 07,01 WINPROMPT " Memo         " TO aMenuArray EXECUTE Menu012()
   @ 08,01 WINPROMPT " Control      " TO aMenuArray EXECUTE Menu011()
   @ 09,01 WINPROMPT " Conversion   " TO aMenuArray EXECUTE Menu010()
   @ 10,01 WINPROMPT " Mouse        " TO aMenuArray EXECUTE Menu019()
   @ 11,01 WINPROMPT " Pop Ups      " TO aMenuArray EXECUTE Menu154()
   @ 12,01 WINPROMPT " Other        " TO aMenuArray EXECUTE Menu018()

   TtlKeyOn()                 // enable left/right menu movement
   nOpt1 := Menu(aMenuArray,nOpt1)
   TtlKeyOff()                // disable left/right menu movement

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Conversion >> in Proc:  MENU009                  
//;
PROCEDURE Menu010()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 13,46,18,60 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU010")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand114()
   @ 02,01 WINPROMPT " Hex2Dec()   " TO aMenuArray EXECUTE Dlog115()
   @ 03,01 WINPROMPT " Dec2Hex()   " TO aMenuArray EXECUTE Dlog117()
   @ 04,01 WINPROMPT " Asc2Bin()   " TO aMenuArray EXECUTE Dlog125()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Control >> in Proc:  MENU009                     
//;
PROCEDURE Menu011()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 12,46,16,71 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU011")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description            " TO aMenuArray EXECUTE Hand109()
   @ 02,01 WINPROMPT " TimeOut()              " TO aMenuArray EXECUTE Dlog111()
   @ 03,01 WINPROMPT " TtlKeyOn()/TtlKeyOff() " TO aMenuArray EXECUTE Dlog110()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Memo >> in Proc:  MENU009                        
//;
PROCEDURE Menu012()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 11,46,15,60 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU012")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand088()
   @ 02,01 WINPROMPT " Edt_Memo()  " TO aMenuArray EXECUTE Dlog106()
   @ 03,01 WINPROMPT " Show_Memo() " TO aMenuArray EXECUTE Dlog108()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Text Files >> in Proc:  MENU009                  
//;
PROCEDURE Menu013()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 10,46,16,60 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU013")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand087()
   @ 02,01 WINPROMPT " fEof()      " TO aMenuArray EXECUTE Dlog098()
   @ 03,01 WINPROMPT " fGets()     " TO aMenuArray EXECUTE Dlog099()
   @ 04,01 WINPROMPT " fGetsR()    " TO aMenuArray EXECUTE Dlog100()
   @ 05,01 WINPROMPT " TextView()  " TO aMenuArray EXECUTE Dlog101()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << DOS/Assembly >> in Proc:  MENU009                
//;
PROCEDURE Menu014()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 09,46,18,61 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU014")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description  " TO aMenuArray EXECUTE Hand086()
   @ 02,01 WINPROMPT " ChgDir()     " TO aMenuArray EXECUTE Dlog089()
   @ 03,01 WINPROMPT " ChgDsk()     " TO aMenuArray EXECUTE Dlog091()
   @ 04,01 WINPROMPT " MakDir()     " TO aMenuArray EXECUTE Dlog092()
   @ 05,01 WINPROMPT " InPath()     " TO aMenuArray EXECUTE Dlog094()
   @ 06,01 WINPROMPT " MaxHndls()   " TO aMenuArray EXECUTE Dlog096()
   @ 07,01 WINPROMPT " Shift States " TO aMenuArray EXECUTE Dlog160()
   @ 08,01 WINPROMPT " DrvTst()     " TO aMenuArray EXECUTE Dlog162()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Valid >> in Proc:  MENU009                       
//;
PROCEDURE Menu015()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 08,46,18,60 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU015")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand085()
   @ 02,01 WINPROMPT " Show_Text() " TO aMenuArray EXECUTE Dlog077()
   @ 03,01 WINPROMPT " PckVld()    " TO aMenuArray EXECUTE Dlog075()
   @ 04,01 WINPROMPT " ChkChr()    " TO aMenuArray EXECUTE Dlog076()
   @ 05,01 WINPROMPT " InFile()    " TO aMenuArray EXECUTE Dlog078()
   @ 06,01 WINPROMPT " DupChk()    " TO aMenuArray EXECUTE Dlog079()
   @ 07,01 WINPROMPT " GenVld()    " TO aMenuArray EXECUTE Dlog080()
   @ 08,01 WINPROMPT " Req()       " TO aMenuArray EXECUTE Dlog081()
   @ 09,01 WINPROMPT " Rght_Jst()  " TO aMenuArray EXECUTE Dlog083()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Database >> in Proc:  MENU009                    
//;
PROCEDURE Menu016()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 07,46,17,60 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU016")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand055()
   @ 02,01 WINPROMPT " Gen_Maint() " TO aMenuArray EXECUTE Dlog057()
   @ 03,01 WINPROMPT " Rel_Maint() " TO aMenuArray EXECUTE Dlog059()
   @ 04,01 WINPROMPT " Plist()     " TO aMenuArray EXECUTE Dlog069()
   @ 05,01 WINPROMPT " Browser()   " TO aMenuArray EXECUTE Dlog070()
   @ 06,01 WINPROMPT " Save_It()   " TO aMenuArray EXECUTE Dlog072()
   @ 07,01 WINPROMPT " Fld_Repl()  " TO aMenuArray EXECUTE Dlog073()
   @ 08,01 WINPROMPT " iSeek()     " TO aMenuArray EXECUTE Dlog074()
   @ 09,01 WINPROMPT " Open_Fil()  " TO aMenuArray EXECUTE Dlog082()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Screen >> in Proc:  MENU009                      
//;
PROCEDURE Menu017()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 06,46,19,69 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU017")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description          " TO aMenuArray EXECUTE Hand054()
   @ 02,01 WINPROMPT " WinPush()/WinPop()   " TO aMenuArray EXECUTE Dlog041()
   @ 03,01 WINPROMPT " Center()             " TO aMenuArray EXECUTE Dlog042()
   @ 04,01 WINPROMPT " Message()            " TO aMenuArray EXECUTE Dlog044()
   @ 05,01 WINPROMPT " MsgBox()             " TO aMenuArray EXECUTE Menu046()
   @ 06,01 WINPROMPT " SetMsgLin()          " TO aMenuArray EXECUTE Dlog051()
   @ 07,01 WINPROMPT " Thermometr()         " TO aMenuArray EXECUTE Dlog052()
   @ 08,01 WINPROMPT " AddPrompt()/AbMenu() " TO aMenuArray EXECUTE Dlog064()
   @ 09,01 WINPROMPT " Ask()                " TO aMenuArray EXECUTE Dlog065()
   @ 10,01 WINPROMPT " AskMenu()            " TO aMenuArray EXECUTE Dlog067()
   @ 11,01 WINPROMPT " aPop()               " TO aMenuArray EXECUTE Hand134()
   @ 12,01 WINPROMPT " GetEdit()            " TO aMenuArray EXECUTE Dlog141()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Other >> in Proc:  MENU009                       
//;
PROCEDURE Menu018()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 15,46,22,60 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU018")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand120()
   @ 02,01 WINPROMPT " ErrTone()   " TO aMenuArray EXECUTE Dlog121()
   @ 03,01 WINPROMPT " WaitKey()   " TO aMenuArray EXECUTE Dlog122()
   @ 04,01 WINPROMPT " Between()   " TO aMenuArray EXECUTE Dlog131()
   @ 05,01 WINPROMPT " Numeric()   " TO aMenuArray EXECUTE Dlog132()
   @ 06,01 WINPROMPT " DbState()   " TO aMenuArray EXECUTE Dlog135()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Mouse >> in Proc:  MENU009                       
//;
PROCEDURE Menu019()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 14,46,18,68 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU019")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description         " TO aMenuArray EXECUTE Hand119()
   @ 02,01 WINPROMPT " MouseInit()         " TO aMenuArray EXECUTE Dlog136()
   @ 03,01 WINPROMPT " AddMPad()/DelMPad() " TO aMenuArray EXECUTE Dlog126()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << MsgBox() >> in Proc:  MENU017                    
//;
PROCEDURE Menu046()
   LOCAL aMenuArray := {}
   LOCAL nOpt3 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 11,68,16,77 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU046")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Plain  " TO aMenuArray EXECUTE Hand047()
   @ 02,01 WINPROMPT " Array  " TO aMenuArray EXECUTE Hand048()
   @ 03,01 WINPROMPT " Menu   " TO aMenuArray EXECUTE Hand049()
   @ 04,01 WINPROMPT " Prompt " TO aMenuArray EXECUTE Hand050()

   nOpt3 := Menu(aMenuArray,nOpt3)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << TBrowse >> in Proc:  MENU002                     
//;
PROCEDURE Menu147()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 11,20,14,34 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU147")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description " TO aMenuArray EXECUTE Hand148()
   @ 02,01 WINPROMPT " Sample      " TO aMenuArray EXECUTE Hand149()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Pop Ups >> in Proc:  MENU009                     
//;
PROCEDURE Menu154()
   LOCAL aMenuArray := {}
   LOCAL nOpt2 := 0

   SETCOLOR(Var(MENU_CLR_))
   @ 15,46,21,64 WINDOW STYLE "--" NOSHADOW
   VarPush("MENU154")
   SetMsgLin(" Up/Down, Left/Right-Move Pointer  ENTER-Select  ESC-Exit ",TRUE)

   @ 01,01 WINPROMPT " Description     " TO aMenuArray EXECUTE Hand155()
   @ 02,01 WINPROMPT " MainColors()    " TO aMenuArray EXECUTE Hand156()
   @ 03,01 WINPROMPT " TBrowseColors() " TO aMenuArray EXECUTE Hand157()
   @ 04,01 WINPROMPT " Calendar()      " TO aMenuArray EXECUTE Hand158()
   @ 05,01 WINPROMPT " PopCalc()       " TO aMenuArray EXECUTE Hand159()

   nOpt2 := Menu(aMenuArray,nOpt2)

   VarPop()
   WINDOW REMOVE

// ENDMENU End of Menu System 

//͸
//  >>>>>>>>>>>>>>>>>>>>>>>>> Hand Coded by User <<<<<<<<<<<<<<<<<<<<<<<<<<< 
//;

//͸
//  CALLED BY: Dialog Window:  DLOG020   Builder Desc Text File View         
//    Comment: View BDEMO001.TXT                                             
//;
FUNCTION Hand021(cViewFile)   // declaring Hand021 will be replace with
                               // Handnnn() in the program
   LOCAL cOldClr,nUpIdx,nDnIdx,nRtIdx,nLfIdx
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()
   STATIC cTextDir

   IF cViewFile == NIL ; cViewFile := "BDEMO001.TXT" ; ENDIF
   IF cTextDir == NIL
      cTextDir := "\" + CURDIR() + "\"
   ENDIF

   IF !FILE(cTextDir + cViewFile)
      ErrTone()
      MsgBox("ERROR: File "+cViewFile+" is Missing!")
      RETURN(FALSE)
   ENDIF

   SetMsgLin(" Arrows/PgUp/PgDn-Scroll  Alt+P-Print"+ ;
             " ESC-Exit ")
   cOldClr := SETCOLOR(AbVar(WMSG_CLR_))

   // Set up mouse pads on window borders
   nUpIdx := AddMPad(nDr1,nDc1,nDr1,nDc2,1,{||__KEYBOARD(CHR(K_UP))})
   nDnIdx := AddMPad(nDr2,nDc1,nDr2,nDc2,1,{||__KEYBOARD(CHR(K_DOWN))})
   nLfIdx := AddMPad(nDr1,nDc1,nDr2,nDc1,1,{||__KEYBOARD(CHR(K_LEFT))})
   nRtIdx := AddMPad(nDr1,nDc2,nDr2,nDc2,1,{||__KEYBOARD(CHR(K_RIGHT))})

   TextView(nDr1+1,nDc1+1,nDr2-1,nDc2-1,cTextDir + cViewFile,.t.)

   // Remove mouse pads
   DelMPad(nUpIdx)
   DelMPad(nDnIdx)
   DelMPad(nLfIdx)
   DelMPad(nRtIdx)

   SETCOLOR(cOldClr)
   RETURN(TRUE)

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU006                 
//    Comment: View BDEMO002.TXT (Menus)                                     
//;
PROCEDURE Hand022()
   Dlog020("BDEMO002.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU005                 
//    Comment: View BDEMO003.TXT (Dialogs)                                   
//;
PROCEDURE Hand023()
   Dlog020("BDEMO003.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU003                 
//    Comment: View BDEMO004.TXT (PickLists)                                 
//;
PROCEDURE Hand024()
   Dlog020("BDEMO004.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU004                 
//    Comment: View BDEMO005.TXT (F Maint)                                   
//;
PROCEDURE Hand025()
   Dlog020("BDEMO005.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU008                 
//    Comment: View BDEMO006.TXT (bMouse)                                    
//;
PROCEDURE Hand026()
   Dlog020("BDEMO006.TXT")
   RETURN

//͸
//  CALLED BY: Pick List Window:  PLST030   QWERTY Picklist Sample           
//    Comment: QWERTY Picklist Selection                                     
//;
PROCEDURE Hand031()
   MsgBox("You Selected City: "+Cities->City,AbVar(MSG_CLR_))
   RETURN

//͸
//  CALLED BY: Pick List Window:  PLST027   No Options Picklist              
//    Comment: No Opts Picklist Selection                                    
//;
PROCEDURE Hand032()
   MsgBox("You Selected City: "+Cities->City,AbVar(MSG_CLR_))
   RETURN

//͸
//  CALLED BY: Pick List Window:  PLST029   Picklist Bounded by Sample       
//    Comment: Bounded Picklist Selection                                    
//;
PROCEDURE Hand033()
   MsgBox("You Selected City: "+Cities->City,AbVar(MSG_CLR_))
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG035   Dialog Sample                       
//    Comment: Dialog Prompt                                                 
//;
PROCEDURE Hand036()
   LOCAL p := "Ready to Start? ",a := {"Yes","No"}
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()

   // Present Prompt, Return to Previous Window Unless "Yes" is Selected
   SetMsgLin(" Press Y-Yes or N-No ")
   IF AskMenu(p,a,nDr2-1,nDc1+2,,nDc2-nDc1-3,AbVar(WMSG_CLR_)) != "Y"
      // "No" Selected
      RETURN
   ENDIF

   // "Yes" Selected
   Dlog037()                    // Execute Next Window in Chain
   KEYBOARD CHR(K_ESC)         // Remove Previous Window from Screen
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG037   Show Progress Thermometer           
//    Comment: Display Progress Thermometer                                  
//;
PROCEDURE Hand038()
   LOCAL J,cThm,cOThm := " "

   // Display a Progression Thermometer
   FOR J := 1 TO 500
      cThm := Thermometr(40,1,500,J)
      IF cThm != cOThm
         @ WinBott()-1,WinLeft()+2 SAY cThm
         cOThm := cThm
      ENDIF
   NEXT

   KEYBOARD(K_ESC)            // Remove Previous Window
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU007                 
//    Comment: View BDEMO007.TXT (Breport)                                   
//;
PROCEDURE Hand039()
   Dlog020("BDEMO007.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU009                 
//    Comment: View BDEMO008.TXT (Lib Funcs)                                 
//;
PROCEDURE Hand040()
   Dlog020("BDEMO008.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG042   Center() Sample                     
//    Comment: Center() Sample                                               
//;
PROCEDURE Hand043()
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()

   Center(">> This is Centered <<",nDr1+4,nDc1+1,nDc2-nDc1-3)
   WaitKey()
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG044   Message Sample                      
//    Comment: Message Sample                                                
//;
PROCEDURE Hand045()
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()

   Message("Press a Key for the Next Message",nDr2-1,nDc1+2, ;
           nDc2-nDc1-3,AbVar(WERR_CLR_))
   WaitKey()

   Message("This One Blinks, Press a Key",nDr2-1,nDc1+2, ;
           nDc2-nDc1-3,"*"+AbVar(WERR_CLR_))
   WaitKey()

   Message("Last One!  Goodbye",nDr2-1,nDc1+2,nDc2-nDc1-3,AbVar(WMSG_CLR_))
   WaitKey()

   RETURN

//͸
//  CALLED BY: Selection << Plain >> in Proc:  MENU046                       
//    Comment: Plain MsgBox() Sample                                         
//;
PROCEDURE Hand047()
   MsgBox("Plain MsgBox() Sample")
   RETURN

//͸
//  CALLED BY: Selection << Array >> in Proc:  MENU046                       
//    Comment: Array MsgBox() Sample                                         
//;
PROCEDURE Hand048()
   MsgBox({"An Array Can Be Passed", ;
           "To the MsgBox() Function", ;
           "To Create Multi Line" , ;
           "Boxed Messages."})
   RETURN

//͸
//  CALLED BY: Selection << Menu >> in Proc:  MENU046                        
//    Comment: Menu MsgBox() Sample                                          
//;
PROCEDURE Hand049()
   LOCAL nAnswer

   SetMsgLin(" Use Arrows-Move Pointer  ENTER-Select  ESC-Exit ")
   nAnswer := MsgBox({"How Much Wood Would", ;
                      "a Woodchuck Chuck", ;
                      "If a Woodchuck Could", ;
                      "Chuck Wood?"},AbVar(MSG_CLR_),, ;
                      {"Little","Some","Lots","Gobs"})

   DO CASE
   CASE nAnswer == 1
      MsgBox("Your Answer: LITTLE")
   CASE nAnswer == 2
      MsgBox("Your Answer: SOME")
   CASE nAnswer == 3
      MsgBox("Your Answer: LOTS")
   CASE nAnswer == 4
      MsgBox("Your Answer: GOBS")
   ENDCASE
   RETURN

//͸
//  CALLED BY: Selection << Prompt >> in Proc:  MENU046                      
//    Comment: Prompt MsgBox() Sample                                        
//;
PROCEDURE Hand050()
   LOCAL cAnswer

   SetMsgLin(" Press L-Little, S-Some, O-lOts, or G-Gobs  ESC-Exit ")
   cAnswer := MsgBox({"How Much Wood Would", ;
                      "a Woodchuck Chuck", ;
                      "If a Woodchuck Could", ;
                      "Chuck Wood?", ;
                      "[L]ittle [S]ome L[O]ts [G]obs"}, ;
                      AbVar(MSG_CLR_),,"LSOG")

   DO CASE
   CASE cAnswer == "L"
     MsgBox("Your Answer: LITTLE")
   CASE cAnswer == "S"
      MsgBox("Your Answer: SOME")
   CASE cAnswer == "O"
      MsgBox("Your Answer: LOTS")
   CASE cAnswer == "G"
      MsgBox("Your Answer: GOBS")
   ENDCASE
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG052   Thermometr() Sample                 
//    Comment: Thermometr() Sample                                           
//;
PROCEDURE Hand053()
   LOCAL J,cThm,cOThm := " "

   // Display a Progression Thermometer
   FOR J := 1 TO 500
      cThm := Thermometr(40,1,500,J)
      IF cThm != cOThm
         @ WinBott()-1,WinLeft()+2 SAY cThm
         cOThm := cThm
      ENDIF
   NEXT

   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU017                 
//    Comment: View BDEMO009.TXT (Screen)                                    
//;
PROCEDURE Hand054()
   Dlog020("BDEMO009.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU016                 
//    Comment: View BDEMO010.TXT (Database)                                  
//;
PROCEDURE Hand055()
   Dlog020("BDEMO010.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG028   Bounded by Picklist (By State)      
//    Comment: Setup Bounded by Picklist                                     
//;
PROCEDURE Hand056(mState)

   SELECT Cities
   SET ORDER TO 3
   IF !iSeek(mState,"CITIES",3)
      ErrTone()
      MsgBox("That State Not Found")
      RETURN
   ENDIF
   // a call the the next window will automatically be generated
   // here

   Plst029()

//͸
//  CALLED BY: Dialog Window:  DLOG059   Rel_Maint() Sample                  
//    Comment: Rel_Maint() Sample                                            
//;
PROCEDURE Hand060()
   LOCAL nKeyPress

   DO WHILE .T.
      nKeyPress := WaitKey()

      IF nKeyPress == K_SPACE
         // The Dlog063() gets replaced with a call to the
         // next window during code gen
         Dlog063()
         EXIT
      ENDIF

      IF nKeyPress == K_ESC
         EXIT
      ENDIF
   ENDDO
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG065   Ask() Sample                        
//    Comment: Ask() Sample                                                  
//;
PROCEDURE Hand066()
   LOCAL cAnswer
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()

   cAnswer := Ask("Do You Like the Builder System? (Y/N)","YN", ;
          nDr2-1,nDc1+2,nDc2-nDc1-3,AbVar(WMSG_CLR_),"ESC")

   IF cAnswer == "Y"
      MsgBox({"WONDERFUL!  By the Way...", ;
              "Registration is Only $59", ;
              "or $99 with Library Source!"},AbVar(MSG_CLR_))
   ENDIF

   IF cAnswer == "N"
      MsgBox({"WELL Then You'll Just Have", ;
              "to Examine This Demo Until", ;
              "You See the Light!"},AbVar(MSG_CLR_))
   ENDIF
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG067   AskMenu() Sample                    
//    Comment: AskMenu() Sample                                              
//;
PROCEDURE Hand068()
   LOCAL cAnswer
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()

   cAnswer := AskMenu("It is: ", ;
                      {"Assembler","BASIC","C","Clipper","FoxPro"}, ;
                      nDr2-1,nDc1+2,"A",nDc2-nDc1-3,AbVar(WMSG_CLR_),"ESC")

   DO CASE
   CASE cAnswer == "A"
      MsgBox({"Fun Stuff","But Your Still a Bit-Twiddler!"})
   CASE cAnswer == "B"
      MsgBox({"I'll Keep this Demo","Simple for You"})
   CASE cAnswer == "C"
      MsgBox({"Bit-Twiddler!  Which is OK", ;
             "As Long as You Don't Use UNIX"})
   Case cAnswer == "L"
      MsgBox("When Your Right, You're RIGHT!")
   CASE cAnswer  == "F"
      MsgBox({"You are Completely","H O P E L E S S !"})
   ENDCASE
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG070   Browser() Sample                    
//    Comment: Browser() Sample                                              
//;
PROCEDURE Hand071()
   DO WHILE .T.
     WaitKey()

     IF LASTKEY() == K_ESC .or. LastKey() == K_SPACE
       EXIT
     ENDIF
   ENDDO

   IF LASTKEY() == K_ESC
     RETURN
   ENDIF

   SELECT Cities
   GO TOP
   SETCOLOR("+"+ABVar(HELP_CLR_))

   SetMsgLin(" Arrows/PgUp/PgDn-Scroll  ESC-Exit ")
   Browser(07,07,20,50)

   SETCOLOR(AbVar(WNDW_CLR_))
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG083   Rght_Jst() Sample                   
//    Comment: Rght_Jst() Sample                                             
//;
PROCEDURE Hand084()
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()

   Message("Press Any Key to Try Again.  ESC Exits",nDr2-1,nDc1+2, ;
           nDc2-nDc1-3,AbVar(WMSG_CLR_))
   WaitKey()

   IF LASTKEY() == K_ESC
     KEYBOARD CHR(K_ESC)
   ENDIF

   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU015                 
//    Comment: View BDEMO011.TXT (Valid)                                     
//;
PROCEDURE Hand085()
   Dlog020("BDEMO011.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU014                 
//    Comment: View BDEMO012.TXT (DOS)                                       
//;
PROCEDURE Hand086()
   Dlog020("BDEMO012.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU013                 
//    Comment: View BDEMO013.TXT (Text Files)                                
//;
PROCEDURE Hand087()
   Dlog020("BDEMO013.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU012                 
//    Comment: View BDEMO014.TXT (Memo Files)                                
//;
PROCEDURE Hand088()
   Dlog020("BDEMO014.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG089   ChgDir() Sample                     
//    Comment: ChgDir() Sample                                               
//;
PROCEDURE Hand090(cDrctry)

   MsgBox("ChgDir() Return Code: "+ALLTRIM(STR(ChgDir(cDrctry),4,0)))
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG092   MakDir() Sample                     
//    Comment: MakDir() Sample                                               
//;
PROCEDURE Hand093(cDrctry)

   MsgBox("MakDir() Result Code: "+ALLTRIM(STR(MakDir(cDrctry),4,0)))
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG094   InPath() Sample                     
//    Comment: InPath() Sample                                               
//;
PROCEDURE Hand095(mFile)

   LOCAL cPath := InPath(mFile)

   DO CASE
   CASE EMPTY(cPath)
     MsgBox("File Not in DOS PATH")
   CASE cPath == "."
     MsgBox("File is in Current Directory")
   OTHERWISE
     MsgBox({"File is Located in Subdirectory:",cPath})
   ENDCASE
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG096   MaxHndls() Sample                   
//    Comment: MaxHndls() Sample                                             
//;
PROCEDURE Hand097()
   @ WinBott()-2,WinLeft()+28 SAY STR(MaxHndls(),3,0)
   WaitKey()
   RETURN

//͸
//  CALLED BY: Selection << No Options >> in Proc:  MENU003                  
//    Comment: Picklist No Options Setup                                     
//;
PROCEDURE Hand102()
   SELECT Cities
   SET ORDER TO 1
   GO TOP

   Plst027()

//͸
//  CALLED BY: Selection << QWERTY Scroll Option >> in Proc:  MENU003        
//    Comment: QWERTY Scroll Option Setup                                    
//;
PROCEDURE Hand103()
   SELECT Cities
   SET ORDER TO 2
   GO TOP

   Plst030()

//͸
//  CALLED BY: Selection << Sample >> in Proc:  MENU004                      
//    Comment: File Maintenance Setup                                        
//;
PROCEDURE Hand104()
   SELECT Cities
   SET ORDER TO 2
   GO TOP

   Fmnt034()

//͸
//  CALLED BY: Dialog Window:  DLOG051   SetMsgLin() Sample                  
//    Comment: SetMsgLin() Sample                                            
//;
PROCEDURE Hand105()
   LOCAL cMsgLin

   SetMsgLin(" Press a Key to Save This Text ")
   WaitKey()
   cMsgLin := SetMsgLin(" Previous Text Saved  Press a Key to Restore ")
   WaitKey()
   SetMsgLin(cMsgLin)
   WaitKey()

   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG106   Edt_Memo() Sample                   
//    Comment: Edt_Memo() Sample                                             
//;
PROCEDURE Hand107()
   LOCAL mTstTxt

   DO WHILE .T.

      WaitKey()

      IF LASTKEY() == K_ENTER .OR. LASTKEY() == K_ESC
         EXIT
      ENDIF
   ENDDO

   IF LASTKEY() == K_ENTER
      SET CURSOR ON
      mTstTxt := Options->TstTxt
      mTstTxt := Options->(Edt_Memo(10,01,22,78,mTstTxt,, ;
               " TEST COMMENTS ",AbVar(WNDW_CLR_),AbVar(WMSG_CLR_),20))
      Options->(Fld_Repl("TSTTXT",mTstTxt))
      SET CURSOR OFF
   ENDIF
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU011                 
//    Comment: View BDEMO015.TXT (Control)                                   
//;
PROCEDURE Hand109()
   Dlog020("BDEMO015.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG111   TimeOut() Sample                    
//    Comment: TimeOut() Sample                                              
//;
PROCEDURE Hand112()
   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ENTER
         EXIT
      ENDIF

      IF LASTKEY() == K_ESC
         RETURN
      ENDIF
   ENDDO

   SET KEY KP_ALT_MINUS TO TimO_Test
   TimeOut(5,Hex2Dec("4A00"))         // Set a 5 Second Timeout
   Dlog113()
   SET KEY KP_ALT_MINUS TO
   TimeOut(0,0)                       // Turn TimeOut() Off/Reset
   RETURN

   PROCEDURE TimO_Test(Prc,Lin,Var)
      IF TimeOut() == "Y"
         MsgBox("No System Activity for 5 Consecutive Seconds!")
         KEYBOARD CHR(K_ESC)
      ENDIF
      RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU010                 
//    Comment: View BDEMO016.TXT (Convrsn)                                   
//;
PROCEDURE Hand114()
   Dlog020("BDEMO016.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG115   Hex2Dec() Sample                    
//    Comment: Hex2Dec() Sample                                              
//;
PROCEDURE Hand116(mHexNbr)
   MsgBox({"The Decimal Equivalant of "+ALLTRIM(mHexNbr), ;
          "is "+ALLTRIM(STR(Hex2Dec(ALLTRIM(mHexNbr)),10,0))})
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG117   Dec2Hex() Sample                    
//    Comment: Dec2Hex() Sample                                              
//;
PROCEDURE Hand118(mDecnbr)

   MsgBox({"The Hexidecimal Equivalent to "+ALLTRIM(STR(mDecNbr,10,0)), ;
          "is "+Dec2Hex(mDecNbr)})
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU019                 
//    Comment: View BDEMO017.TXT (Mouse)                                     
//;
PROCEDURE Hand119()
   Dlog020("BDEMO017.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU018                 
//    Comment: View BDEMO018.TXT (Other)                                     
//;
PROCEDURE Hand120()
   Dlog020("BDEMO018.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG122   WaitKey() Sample                    
//    Comment: WaitKey() Sample                                              
//;
PROCEDURE Hand123()
   MsgBox("LastKey() == "+AllTrim(Str(WaitKey())))
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG121   ErrTone() Sample                    
//    Comment: ErrTone() Sample                                              
//;
PROCEDURE Hand124(mToneNbr)

   ErrTone(mToneNbr)
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG126   AddMPad()/DelMPad() Sample          
//    Comment: AddMPad()/DelMPad() Sample                                    
//;
PROCEDURE Hand127()
   LOCAL nDr1 := WinTop()
   LOCAL nDc1 := WinLeft()
   LOCAL nDr2 := WinBott()
   LOCAL nDc2 := WinRight()
   LOCAL nTstIdx1, nTstIdx2

   nTstIdx1 := AddMPad(nDr2-3,nDc1+1,nDr2,nDc2-1,1,{||MousePrss()})
   nTstIdx2 := AddMPad(nDr2-3,nDc1+1,nDr2,nDc2-1,0,{||MouseRlse()})

   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF
   ENDDO

   DelMPad(nTstIdx1)
   DelMPad(nTstIdx2)

   RETURN

   FUNCTION MousePrss()
      LOCAL nDr1 := WinTop()
      LOCAL nDc1 := WinLeft()
      LOCAL nDr2 := WinBott()
      LOCAL nDc2 := WinRight()

      Message("LEFT MOUSE BUTTON PRESSED",nDr2-1,nDc1+2,nDc2-nDc1-3, ;
              AbVar(WERR_CLR_))
      RETURN(NIL)

   FUNCTION MouseRlse()
      LOCAL nDr1 := WinTop()
      LOCAL nDc1 := WinLeft()
      LOCAL nDr2 := WinBott()
      LOCAL nDc2 := WinRight()

      Message("LEFT MOUSE BUTTON RELEASED",nDr2-1,nDc1+2,nDc2-nDc1-3, ;
              Abvar(WMSG_CLR_))
      RETURN(NIL)

//͸
//  CALLED BY: Dialog Window:  DLOG128   Lateral Scroll Picklist Sample      
//    Comment: Lateral Scroll Picklist Sample                                
//;
PROCEDURE Hand129()
   LOCAL nMouseIdx := AddMPad(0,0,24,79,0,{||__KEYBOARD(CHR(13))})

   DO WHILE .T.
      WaitKey()

      IF LASTKEY() == K_ENTER .OR. LASTKEY() == K_ESC
         EXIT
      ENDIF
   ENDDO

   DelMPad(nMouseIdx)

   IF LASTKEY() == K_ENTER
      Plst130()
   ENDIF
   RETURN

//͸
//  CALLED BY: Pick List Window:  PLST130   Lateral Scroll Picklist Sample   
//    Comment: Lateral Scroll Picklist Sample                                
//;
PROCEDURE Hand133()
   MsgBox({" City: "+Cities->City, ;
           "State: "+Cities->State, ;
           "  Zip: "+Cities->Zip, ;
           "Selected Record"})
   RETURN

//͸
//  CALLED BY: Selection << aPop() >> in Proc:  MENU017                      
//    Comment: aPop() Sample                                                 
//;
PROCEDURE Hand134()
   LOCAL Settings := {" Auto Save"," Print Headings"," Color Screen", ;
                      " Network Mode"," Display Clock"}, ;
                      MsgTxt := {"Settings You Selected:",}

   aPop(08,40,14,58,@Settings)

   AEVAL(Settings,{|x|IF(LEFT(x,1) == CHR(251), ;
         AADD(MsgTxt,"@C"+SUBSTR(x,2)),NIL)})
   MsgBox(MsgTxt,AbVar(MSG_CLR_))

   RETURN

//͸
//  CALLED BY: Selection << Incentives >> in Proc:  MENU002                  
//    Comment: View BDEMO019.TXT (Incentives)                                
//;
PROCEDURE Hand138()
   Dlog020("BDEMO019.TXT")
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG063   Rel_Maint() Sample                  
//    Comment: Rel_Maint() Sample                                            
//;
PROCEDURE Hand139()
   SELECT Cities
   SET ORDER TO 2
   GO TOP
   WaitKey()

   Plst061()

//͸
//  CALLED BY: Dialog Window:  DLOG057   Gen_Maint() Lib Func                
//    Comment: Parm Pass mOpts                                               
//;
PROCEDURE Hand142(mOpts)
       Fmnt058(mOpts)

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU147                 
//    Comment: View BDEMO020.TXT (Incentives)                                
//;
PROCEDURE Hand148()
   Dlog020("BDEMO020.TXT")
   RETURN

//͸
//  CALLED BY: Selection << Sample >> in Proc:  MENU147                      
//    Comment: Position TBrowse Database                                     
//;
PROCEDURE Hand149()
   Friends->( DBSETORDER( 1 ) )
   Cities->( DBSETORDER( 2 ) )
   DBSELECTAREA( "Cities" )
   SET RELATION TO Cities->City INTO Friends
   Cities->( DBGOTOP() )

   Brws146()

   DBSELECTAREA( "Cities" )
   SET RELATION TO

//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU002                 
//    Comment: Initialize Parm Passing                                       
//;
PROCEDURE Hand150()
   LOCAL cViewFile
   // This Hand Code Section will only get call once, when the menu option
   // "About Builder"/"Description" is selected.  Its purpose is to create
   // the next procedure (Dlog020) with a parameter.  That way the other 19
   // Hand Code Sections that call Dlog020 will be able to send it a parm!
   Dlog020(cViewFile)


//͸
//  CALLED BY: Selection << Description >> in Proc:  MENU154                 
//    Comment: Display BDEMO021.TXT                                          
//;
PROCEDURE Hand155()
   Dlog020( "BDEMO021.TXT" )
   RETURN

//͸
//  CALLED BY: Selection << MainColors() >> in Proc:  MENU154                
//    Comment: Main Color Change Demo                                        
//;
PROCEDURE Hand156()
   Options->( MainColors() )
   RETURN

//͸
//  CALLED BY: Selection << TBrowseColors() >> in Proc:  MENU154             
//    Comment: TBrowse Colors Demo                                           
//;
PROCEDURE Hand157()
   Options->( TBrowseColors() )
   RETURN

//͸
//  CALLED BY: Selection << Calendar() >> in Proc:  MENU154                  
//    Comment: Calendar Popup Demo                                           
//;
PROCEDURE Hand158()
   Calendar()
   RETURN

//͸
//  CALLED BY: Selection << PopCalc() >> in Proc:  MENU154                   
//    Comment: Calculator Pop Up Demo                                        
//;
PROCEDURE Hand159()
   PopCalc()
   RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG160   Shift States Dialog                 
//    Comment: Shift State Demo                                              
//;
PROCEDURE Hand161()
     LOCAL nKey
     LOCAL cSaveArea := SAVESCREEN( 23, 00, 23, 79 )
     LOCAL nCursor   := SETCURSOR()

     // Call ShftDisp() continually during all WaitKey() calls.
     SetWaitBlock( {|| ShftDisp() } )

     DO WHILE TRUE
       nKey := WaitKey()
       DO CASE
       CASE nKey == K_ESC
         EXIT
       CASE CHR( nKey ) == "1"
         SetCaps( TRUE )
       CASE CHR( nKey ) == "2"
         SetNum( TRUE )
       CASE CHR( nKey ) == "3"
         SetScroll( TRUE )
       ENDCASE
     ENDDO

     SetWaitBlock( {|| NIL } )

     RESTSCREEN( 23, 00, 23, 79, cSaveArea )
     SETCURSOR( nCursor )

     RETURN

   PROCEDURE ShftDisp()
     LOCAL cText := " "
     LOCAL lLeft
     LOCAL lRight
     LOCAL lCtrl
     LOCAL lAlt
     LOCAL lNum
     LOCAL lCaps
     LOCAL lScroll

     ShftSt( @lLeft, @lRight, @lCtrl, @lAlt )
     lNum    := SetNum()
     lCaps   := SetCaps()
     lScroll := SetScroll()

     cText += IF( lLeft,   "Left ",   "     "  )
     cText += IF( lRight,  "Right ",  "      " )
     cText += IF( lCtrl,   "Ctrl ",   "     "  )
     cText += IF( lAlt,    "Alt ",    "    "   )
     cText += IF( lNum,    "Num ",    "    "   )
     cText += IF( lCaps,   "Caps ",   "     "  )
     cText += IF( lScroll, "Scroll ", "       " )

     cText := PADR( cText, 70 ) + TIME()

     BiosDisp( PADR( cText, 80 ), 23, 00, 116 )

     RETURN

//͸
//  CALLED BY: Dialog Window:  DLOG162   DrvTst() Sample Dialog              
//    Comment: DrvTst() function hand code                                   
//;
PROCEDURE Hand163( cDrive )
     LOCAL nDosError := DrvTst( cDrive )

     MsgBox( "DOS ERROR: " + ALLTRIM( STR( nDosError ) ) )
     RETURN

// ENDHAND End of Hand Code 

//͸
//  >>>>>>>>>>>>>>>>>>>>>>>>>>>> Dialog Boxes <<<<<<<<<<<<<<<<<<<<<<<<<<<<<  
//;

//͸
//  CALLED BY: Hand Code:  HAND150   Initialize Parm Passing                 
//    Comment: Builder Desc Text File View                                   
//;
PROCEDURE Dlog020(cViewFile)

   VarPush("DLOG020")

   SETCOLOR(Var(WNDW_CLR_))
   @ 05,00,22,78 WINDOW STYLE "3+"

   @ 01,02 WINSAY "Loading File..."

   //SetMsgLin(" Enter Your Own Message Line Here  ESC-Exit ",TRUE)

   Hand021(cViewFile)

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Bounded by Option >> in Proc:  MENU003           
//    Comment: Bounded by Picklist (By State)                                
//;
PROCEDURE Dlog028()
   LOCAL GetList := {}
   LOCAL mState

   VarPush("DLOG028")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,24,19,67 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Following Picklist Will Only Display"
   @ 02,02 WINSAY "Records From the State You Select."
   SETCOLOR(Var(WNDW_CLR_))
   @ 04,02 WINSAY "State Code:"

   mState := Space(02)

   DO WHILE .T.
      SetMsgLin(" Enter State Code  ESC-Exit ",TRUE)

      @ 04,14 WINGET mState PICTURE "!!" VALIDBLOCK ;
      {|| ;
          GenVld(In_Usa(GETACTIVE():varGet()), ;
                 "Enter a Valid U.S. State Code", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.T.,Var(WERR_CLR_))} ;
         HELPKEY "MSTATE"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand056(mState)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Sample Dialog 1 >> in Proc:  MENU005             
//    Comment: Dialog Sample                                                 
//;
PROCEDURE Dlog035()
   LOCAL GetList := {}
   LOCAL mDummy1,mDummy2,mDummy3,mDummy4,mDummy5, ;
          mDummy6
   LOCAL mDummy,mColor,nColor

   VarPush("DLOG035")

   SETCOLOR(Var(WNDW_CLR_))
   @ 00,26,22,74 WINDOW STYLE "3+"

   @ 01,02 WINSAY "Display Text In Your Dialog Box..."
   @ 02,02 WINSAY "Display"

   SETCOLOR(Var(WMSG_CLR_))
   @ 02,10 WINSAY "Highlighted"
   SETCOLOR(Var(WNDW_CLR_))
   @ 02,22 WINSAY "Text also..."
   @ 04,02 WINSAY "Issue SAYs and/or GETS"
   @ 06,02 WINSAY "You Can Only Exit With ESC Until ALL Valids"
   @ 07,02 WINSAY "are Satisfied.  Each of the Following Must be"
   @ 08,02 WINSAY "Y or N.  Try Bypassing Using PgDn or Mouse!"

   SETCOLOR(Var(WMSG_CLR_))
   @ 12,02 WINSAY "Issue a MENU type GET that Will Return"
   @ 13,02 WINSAY "Either a Unique Character or Numeric Value:"
   SETCOLOR(Var(WNDW_CLR_))
   @ 14,02 WINSAY "What is Your Favorite Color?"
   @ 17,02 WINSAY "Or a Drop Down List:"
   @ 17,31 WINSAY "(Press Alt+Down)"
   @ 19,02 WINSAY "Follow Up a Dialog with Hand Code to"
   @ 20,02 WINSAY "Take a Confirmation Prompt."

   mDummy := Space(04)
   mDummy1 := " "
   mDummy2 := " "
   mDummy3 := " "
   mDummy4 := " "
   mDummy5 := " "
   mDummy6 := " "
   mColor := Space(01)
   nColor := 1

   DO WHILE .T.
      SetMsgLin(" A Dialog is a General Purpose Window  ESC-Exit ",TRUE)

      @ 04,25 WINGET mDummy PICTURE "!!!!" ;
         HELPKEY "MDUMMY"
      @ 10,03 WINGET mDummy1 PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MDUMMY1"
      @ 10,07 WINGET mDummy2 PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MDUMMY2"
      @ 10,11 WINGET mDummy3 PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MDUMMY3"
      @ 10,15 WINGET mDummy4 PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MDUMMY4"
      @ 10,19 WINGET mDummy5 PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MDUMMY5"
      @ 10,23 WINGET mDummy6 PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("YN", ;
                 "Y-Yes or N-No Onl", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MDUMMY6"
      @ 15,02 WINGET mColor MENU USING {"Red","Green","Blue","Yellow","Orange"} ;
         HELPKEY "MCOLOR"
      @ 17,23 WINGET nColor DROPDOWN USING {"Red","Green","Blue","Yellow","Orange"} ;
         HELPKEY "NCOLOR"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand036()
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Hand Code:  HAND036   Dialog Prompt                           
//    Comment: Show Progress Thermometer                                     
//;
PROCEDURE Dlog037()

   VarPush("DLOG037")

   SETCOLOR(Var(WNDW_CLR_))
   @ 19,24,22,67 WINDOW STYLE "3+"

   @ 01,02 WINSAY "Processing..."

   SetMsgLin(" Processing--Please Wait  ESC-Exit ",TRUE)

   Hand038()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << WinPush()/WinPop() >> in Proc:  MENU017          
//    Comment: Winpush/Pop Sample                                            
//;
PROCEDURE Dlog041()

   VarPush("DLOG041")

   SETCOLOR(Var(WNDW_CLR_))
   @ 09,21,16,68 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "WinPush()ing Displays Windows on the Screen"
   @ 02,02 WINSAY "WinPop()ing Removes the Last Window from the"
   @ 03,02 WINSAY "Screen."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "This Window was WinPush()ed onto the Screen."
   @ 06,02 WINSAY "Press ESC to WinPop() This Window."

   DO WHILE .T.
      SetMsgLin(" WinPush()/WinPop() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Center() >> in Proc:  MENU017                    
//    Comment: Center() Sample                                               
//;
PROCEDURE Dlog042()

   VarPush("DLOG042")

   SETCOLOR(Var(WNDW_CLR_))
   @ 10,24,17,68 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Builder Center() Function is Designed"
   @ 02,02 WINSAY "to be Useable Inside a Window."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "Press Any Key to Remove Window."

   SetMsgLin(" Center() Function Information  ESC-Exit ",TRUE)

   Hand043()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Message() >> in Proc:  MENU017                   
//    Comment: Message Sample                                                
//;
PROCEDURE Dlog044()

   VarPush("DLOG044")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,20,17,68 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Message() Function Simply Displays a"
   @ 02,02 WINSAY "Screen Message.  It is Most Useful When"
   @ 03,02 WINSAY "One Screen Line is Used for Several Messages."
   SETCOLOR(Var(WNDW_CLR_))

   SetMsgLin(" Message() Function Information  ESC-Exit ",TRUE)

   Hand045()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << SetMsgLin() >> in Proc:  MENU017                 
//    Comment: SetMsgLin() Sample                                            
//;
PROCEDURE Dlog051()

   VarPush("DLOG051")

   SETCOLOR(Var(WNDW_CLR_))
   @ 05,03,22,50 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The SetMsgLin() Function Works Like the"
   @ 02,02 WINSAY "Clipper SetColor() Function, Except that"
   @ 03,02 WINSAY "It Saves/Changes the Bottom Screen Line"
   @ 04,02 WINSAY "Instead of the Screen Color."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "For Example:"
   @ 07,07 WINSAY "cLin24 := SetMsgLin()"
   @ 09,02 WINSAY 'Would Set "cLin24" Equal to the Text From'
   @ 10,02 WINSAY "Screen Line 24.  And:"
   @ 11,07 WINSAY 'Lin24 := SetMsgLin(" Enter Stuff ")'
   @ 13,02 WINSAY "Would Save the Contents of Screen Line 24"
   @ 14,02 WINSAY 'in "cLin24" and Set Line 24 to the Character'
   @ 15,02 WINSAY "Data Passed."

   //SetMsgLin(" Enter Your Own Message Line Here  ESC-Exit ",TRUE)

   Hand105()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Thermometr() >> in Proc:  MENU017                
//    Comment: Thermometr() Sample                                           
//;
PROCEDURE Dlog052()

   VarPush("DLOG052")

   SETCOLOR(Var(WNDW_CLR_))
   @ 14,25,17,68 WINDOW STYLE "3+"

   @ 01,02 WINSAY "Processing..."

   SetMsgLin(" Processing--Please Wait  ESC-Exit ",TRUE)

   Hand053()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Gen_Maint() >> in Proc:  MENU016                 
//    Comment: Gen_Maint() Lib Func                                          
//;
PROCEDURE Dlog057()
   LOCAL GetList := {}
   LOCAL mOpts

   VarPush("DLOG057")

   SETCOLOR(Var(WNDW_CLR_))
   @ 10,09,18,56 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Gen_Maint() (Generic Mainenance) Library"
   @ 02,02 WINSAY "Function is a Full Feature File Maintenance"
   @ 03,02 WINSAY "Routine that is Typically Created by the"
   @ 04,02 WINSAY "Builder Code Generator (Not by Hand)."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "Enter the Allowed Menu Options:"

   mOpts := "ACDF"

   DO WHILE .T.
      SetMsgLin(" Enter A-Add, C-Change, D-Delete, F-Find  ESC-Exit ",TRUE)

      @ 06,34 WINGET mOpts PICTURE "!!!!" ;
         HELPKEY "MOPTS"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand142(mOpts)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Rel_Maint() >> in Proc:  MENU016                 
//    Comment: Rel_Maint() Sample                                            
//;
PROCEDURE Dlog059()

   VarPush("DLOG059")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,08,19,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Rel_Maint() Function is a File Maintenance"
   @ 02,02 WINSAY "Function That Works Like the Gen_Maint()"
   @ 03,02 WINSAY "Function, Except that Rel_Maint() is Used"
   @ 04,02 WINSAY "to Edit the Many Records of a One-to-Many"
   @ 05,02 WINSAY "Database Relationship."
   SETCOLOR(Var(WNDW_CLR_))
   @ 07,02 WINSAY "Press <Space> for Sample or ESC to Exit"

   SetMsgLin(" Press Any Key for Rel_Maint() Sample  ESC-Exit ",TRUE)

   Hand060()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Hand Code:  HAND060   Rel_Maint() Sample                      
//    Comment: Rel_Maint() Sample                                            
//;
PROCEDURE Dlog063()

   VarPush("DLOG063")

   SETCOLOR(Var(WNDW_CLR_))
   @ 09,06,16,50 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Following Windows Will Present a"
   @ 02,02 WINSAY "Picklist of Cities.  Following it Will be"
   @ 03,02 WINSAY "a Rel_Maint() to Enter a List of Friends"
   @ 04,02 WINSAY "in That City."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "Press Any Key to Continue"

   SetMsgLin(" Press Any Key to Continue  ESC-Exit ",TRUE)

   Hand139()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << AddPrompt()/AbMenu() >> in Proc:  MENU017        
//    Comment: AddPrompt() Sample                                            
//;
PROCEDURE Dlog064()

   VarPush("DLOG064")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,05,22,54 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Builder Menu System Consists of Two"
   @ 02,02 WINSAY "Functions.  The AddPrompt() Function Which"
   @ 03,02 WINSAY "Works Like the Clipper @..PROMPT Command and"
   @ 04,02 WINSAY "the AbMenu() Function Which Works Like the"
   @ 05,02 WINSAY "Clipper MENU TO .. Command."
   SETCOLOR(Var(WNDW_CLR_))
   @ 07,02 WINSAY "The Menu System is Mouseable.  This Demo"
   @ 08,02 WINSAY "Program's Menus Use The Builder Menu System."
   @ 09,02 WINSAY "Normally Builder Writes All the Menu Source"
   @ 10,02 WINSAY "Code.  Look at the Program Source for Samples."

   DO WHILE .T.
      SetMsgLin(" Builder Menu Functions  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Ask() >> in Proc:  MENU017                       
//    Comment: Ask() Sample                                                  
//;
PROCEDURE Dlog065()

   VarPush("DLOG065")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,07,18,54 WINDOW STYLE "3+"

   @ 01,02 WINSAY "The Builder Ask() Function Allows a Question"
   @ 02,02 WINSAY "to Be Asked.  The Ask() Function Erases"
   @ 03,02 WINSAY "it's Prompt When Finished."
   @ 04,02 WINSAY "Sample:"

   SetMsgLin(" Press Y-Yes or N-No  ESC-Exit ",TRUE)

   Hand066()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << AskMenu() >> in Proc:  MENU017                   
//    Comment: AskMenu() Sample                                              
//;
PROCEDURE Dlog067()

   VarPush("DLOG067")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,08,20,57 WINDOW STYLE "3+"

   @ 01,02 WINSAY "The AskMenu() Function Works Much Like the"
   @ 02,02 WINSAY "Ask() Function Except That Instead of Pressing"
   @ 03,02 WINSAY "a Single Key The User Can Select From a Menu."
   @ 04,02 WINSAY "Sample:"

   SETCOLOR(Var(WMSG_CLR_))
   @ 06,02 WINSAY "What is Your Favorite Computer Language?"
   SETCOLOR(Var(WNDW_CLR_))

   SetMsgLin(" Use Arrows to Move  ENTER-Select  ESC-Exit ",TRUE)

   Hand068()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Plist() >> in Proc:  MENU016                     
//    Comment: Plist() Sample                                                
//;
PROCEDURE Dlog069()

   VarPush("DLOG069")

   SETCOLOR(Var(WNDW_CLR_))
   @ 08,02,21,51 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Builder Plist() (Picklist) Function is"
   @ 02,02 WINSAY "a Very Powerful Database Scanning Tool."
   @ 03,02 WINSAY "There are Many Options in Plist(), Most"
   @ 04,02 WINSAY "Can be Set Using Builder Alone."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "Setting Both a 'Bounded by' AND a QWERTY"
   @ 07,02 WINSAY "Plist(), However, Requires Adding 3 Parameters"
   @ 08,02 WINSAY "to the Plist() Call After Builder Creates"
   @ 09,02 WINSAY "the Source Code."

   SETCOLOR(Var(WMSG_CLR_))
   @ 11,02 WINSAY 'See The "Picklist" Menu Selection Under'
   @ 12,02 WINSAY '"About Builder" also.'
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Plist() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Browser() >> in Proc:  MENU016                   
//    Comment: Browser() Sample                                              
//;
PROCEDURE Dlog070()

   VarPush("DLOG070")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,11,19,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "Browser() is a VERY Simple Database Browse."
   @ 02,02 WINSAY "It is So Simple, In Fact, That DbEdit() is"
   @ 03,02 WINSAY "Used Instead of tBrowse Code."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Press <Space> for Sample.  ESC to Exit"

   SetMsgLin(" Press <Space> to Start  ESC-Exit ",TRUE)

   Hand071()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Save_It() >> in Proc:  MENU016                   
//    Comment: Save_It() Sample                                              
//;
PROCEDURE Dlog072()

   VarPush("DLOG072")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,02,21,49 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Save_It() Function Allows Builder"
   @ 02,02 WINSAY "Applications to ADD and CHANGE databases"
   @ 03,02 WINSAY "One Record at a Time, Rather Than One Field"
   @ 04,02 WINSAY "At a Time."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "Optionally Use a Builder Delete Index and"
   @ 07,02 WINSAY "Recycle Your Deleted Records."

   SETCOLOR(Var(WMSG_CLR_))
   @ 09,02 WINSAY "Save_It() Locks/Unlocks Records on a Network"
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Save_It() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Fld_Repl() >> in Proc:  MENU016                  
//    Comment: Fld_Repl() Sample                                             
//;
PROCEDURE Dlog073()

   VarPush("DLOG073")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,16,19,57 WINDOW STYLE "3+"

   @ 01,02 WINSAY "Use Fld_Repl() Instead of the Clipper"
   @ 02,02 WINSAY "REPLACE Command.  Fld_Repl() Will Lock"
   @ 03,02 WINSAY "and Unlock Records on a Network."

   DO WHILE .T.
      SetMsgLin(" Fld_Repl() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << iSeek() >> in Proc:  MENU016                     
//    Comment: iSeek() Sample                                                
//;
PROCEDURE Dlog074()

   VarPush("DLOG074")

   SETCOLOR(Var(WNDW_CLR_))
   @ 16,15,22,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The iSeek() Function Does an Indexed"
   @ 02,02 WINSAY "Database Search.  Pass a Database Alias"
   @ 03,02 WINSAY "and an Index Order."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "One Line of Code to Replace 4 or 5"

   DO WHILE .T.
      SetMsgLin(" iSeek() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << PckVld() >> in Proc:  MENU015                    
//    Comment: PckVld() Sample                                               
//;
PROCEDURE Dlog075()
   LOCAL GetList := {}
   LOCAL mCity

   VarPush("DLOG075")

   SETCOLOR(Var(WNDW_CLR_))
   @ 12,12,20,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "PckVld() Forces Entry into a Field to be"
   @ 02,02 WINSAY "Controlled by a Look Up Table by Providing"
   @ 03,02 WINSAY "a Plist() on Invalid Entries."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "City:"
   @ 07,02 WINSAY "Easily Set Up PckVld()'s from Builder!"

   mCity := Space(25)

   DO WHILE .T.
      SetMsgLin(" Enter a Valid City Name  ESC-Exit ",TRUE)

      @ 05,08 WINGET mCity PICTURE "@!" VALIDBLOCK ;
      {|| ;
          PckVld("CITIES",1,2,.F., ;
                 "City", ;
                 .T.)} ;
         HELPKEY "MCITY"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << ChkChr() >> in Proc:  MENU015                    
//    Comment: ChkChk() Sample                                               
//;
PROCEDURE Dlog076()
   LOCAL GetList := {}
   LOCAL mPart_Typ

   VarPush("DLOG076")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,15,19,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The ChkChr() Function Forces Input to a"
   @ 02,02 WINSAY "GET to Match a Substring Search."
   SETCOLOR(Var(WNDW_CLR_))
   @ 04,02 WINSAY "Enter Part Type:"

   mPart_Typ := " "

   DO WHILE .T.
      SetMsgLin(" Enter Part Type B-Bolt, N-Nut, or S-Screw  ESC-Exit ",TRUE)

      @ 04,19 WINGET mPart_Typ PICTURE "!" VALIDBLOCK ;
      {|| ;
          ChkChr("BNS", ;
                 "B-Bolt, N-Nut, or S-Screw Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MPART_TYP"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Show_Text() >> in Proc:  MENU015                 
//    Comment: Show_Text() Sample                                            
//;
PROCEDURE Dlog077()

   VarPush("DLOG077")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,07,22,53 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Show_Text() Function Allows the Display"
   @ 02,02 WINSAY "of Data from a Look-Up Table if the Search"
   @ 03,02 WINSAY "Key Within a GET Stream is Changed."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "For Example, Displaying a Part Description"
   @ 06,02 WINSAY "When GETing a Part Number."
   @ 08,02 WINSAY "Calls to This Function Must be Written by"
   @ 09,02 WINSAY "Hand, Builder Does Not Create Show_Txt()"
   @ 10,02 WINSAY "Calls."

   DO WHILE .T.
      SetMsgLin(" Show_Text() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << InFile() >> in Proc:  MENU015                    
//    Comment: InFile() Sample                                               
//;
PROCEDURE Dlog078()
   LOCAL GetList := {}
   LOCAL mZip

   VarPush("DLOG078")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,09,22,53 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The InFile() Function Forces Input to a"
   @ 02,02 WINSAY "GET to be Located in a Look Up Table."
   SETCOLOR(Var(WNDW_CLR_))
   @ 04,02 WINSAY "Example, Enter a Zip Code From the CITIES"
   @ 05,02 WINSAY "Database."
   @ 07,02 WINSAY "Zip Code:"

   mZip := Space(09)

   DO WHILE .T.
      SetMsgLin(" Enter Zip Code  ESC-Exit ",TRUE)

      @ 07,12 WINGET mZip PICTURE "@R 99999 9999" VALIDBLOCK ;
      {|| ;
          InFile("CITIES",1, ;
                 "Zip Code Not Found in CITIES", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.T.,Var(WERR_CLR_))} ;
         HELPKEY "MZIP"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << DupChk() >> in Proc:  MENU015                    
//    Comment: DupChk() Sample                                               
//;
PROCEDURE Dlog079()

   VarPush("DLOG079")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,13,22,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The DupChk() Function is Useful When You"
   @ 02,02 WINSAY "Need to Maintain 2 Indexes on a Database,"
   @ 03,02 WINSAY "Both Without Duplicates."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "DupChk() Force Entry Into a GET to Not"
   @ 06,02 WINSAY "Duplicate an Existing Record."

   DO WHILE .T.
      SetMsgLin(" Enter State Code  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << GenVld() >> in Proc:  MENU015                    
//    Comment: GenVld() Sample                                               
//;
PROCEDURE Dlog080()
   LOCAL GetList := {}
   LOCAL mDate

   VarPush("DLOG080")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,06,22,55 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The GenVld() (Generic Valid) Function Allows"
   @ 02,02 WINSAY "ANY Logical Expression to Be Used for GET"
   @ 03,02 WINSAY "Validation."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Pass a Logical Expression and an Error Message"
   @ 07,02 WINSAY "Todays Date:"

   mDate := Ctod("")

   DO WHILE .T.
      SetMsgLin(" Enter Current Date  ESC-Exit ",TRUE)

      @ 07,15 WINGET mDate VALIDBLOCK ;
      {|| ;
          GenVld(GETACTIVE():varGet()==Date(), ;
                 "Not Equal to Your Computer Date", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.T.,Var(WERR_CLR_))} ;
         HELPKEY "MDATE"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Req() >> in Proc:  MENU015                       
//    Comment: Req() Sample                                                  
//;
PROCEDURE Dlog081()
   LOCAL GetList := {}
   LOCAL mStuff

   VarPush("DLOG081")

   SETCOLOR(Var(WNDW_CLR_))
   @ 16,10,22,56 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Req() Function Simply Forces Entry"
   @ 02,02 WINSAY "Into a GET.  No Further Validation is Done."
   SETCOLOR(Var(WNDW_CLR_))
   @ 04,02 WINSAY "Enter Stuff:"

   mStuff := Space(20)

   DO WHILE .T.
      SetMsgLin(" Enter Something  ESC-Exit ",TRUE)

      @ 04,15 WINGET mStuff VALIDBLOCK ;
      {|| ;
          Req("Enter Something, Anything", ;
              WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MSTUFF"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Open_Fil() >> in Proc:  MENU016                  
//    Comment: Open_Fil() Sample                                             
//;
PROCEDURE Dlog082()

   VarPush("DLOG082")

   SETCOLOR(Var(WNDW_CLR_))
   @ 12,01,22,50 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Open_Fil() Function is Replacement for"
   @ 02,02 WINSAY "Clipper's USE Command.  Open_Fil() Tests for"
   @ 03,02 WINSAY "Several Error Conditions and Displays an"
   @ 04,02 WINSAY "Error Message If the Database Cannot Be"
   @ 05,02 WINSAY "Opened."
   SETCOLOR(Var(WNDW_CLR_))
   @ 07,02 WINSAY "Open_Fil() Will Either Return a Logical"
   @ 08,02 WINSAY "False or Exit to DOS When an Error is"
   @ 09,02 WINSAY "Encountered, Depending on the Parameters Sent."

   DO WHILE .T.
      SetMsgLin(" Open_Fil() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Rght_Jst() >> in Proc:  MENU015                  
//    Comment: Rght_Jst() Sample                                             
//;
PROCEDURE Dlog083()
   LOCAL GetList := {}
   LOCAL mStuff

   VarPush("DLOG083")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,11,22,56 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Rght_Jst() Function Will Right Justify"
   @ 02,02 WINSAY "Input Into a GET.  This Will Only Work on"
   @ 03,02 WINSAY "a Character Memory Variable."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Enter Something to Right Justify:"
   @ 07,02 WINSAY "Right Justify:"

   mStuff := Space(10)

   DO WHILE .T.
      SetMsgLin(" Enter Something to Right Justify  ESC-Exit ",TRUE)

      @ 07,17 WINGET mStuff VALIDBLOCK ;
      {|| ;
          Rght_Jst("0")} ;
         HELPKEY "MSTUFF"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand084()
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << ChgDir() >> in Proc:  MENU014                    
//    Comment: ChgDir() Sample                                               
//;
PROCEDURE Dlog089()
   LOCAL GetList := {}
   LOCAL cDrctry

   VarPush("DLOG089")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,02,22,51 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The ChgDir() Function Accepts One Parameter,"
   @ 02,02 WINSAY "a Character Value of a DOS Subdirectory Name."
   @ 03,02 WINSAY "ChgDir() Attempts to Change to That Directory."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "ChgDir() Returns a Numeric Value Indicating"
   @ 06,02 WINSAY "the DOS Return Code."
   @ 08,02 WINSAY "Directory Name:"

   cDrctry := Padr("\"+CurDir(),60)

   DO WHILE .T.
      SetMsgLin(" Enter New Directory Name  ESC-Exit ",TRUE)

      @ 09,02 WINGET cDrctry PICTURE "@S46@!" ;
         HELPKEY "CDRCTRY"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand090(cDrctry)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << ChgDsk() >> in Proc:  MENU014                    
//    Comment: ChgDsk() Sample                                               
//;
PROCEDURE Dlog091()

   VarPush("DLOG091")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,12,18,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The ChgDsk() Function Works Much Like the"
   @ 02,02 WINSAY "ChgDir() Function, Except that the Default"
   @ 03,02 WINSAY "DOS Disk is Changed.  Based on a One Byte"
   @ 04,02 WINSAY "Drive Letter Passed to the Function."
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" ChgDsk() Function Description  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << MakDir() >> in Proc:  MENU014                    
//    Comment: MakDir() Sample                                               
//;
PROCEDURE Dlog092()
   LOCAL GetList := {}
   LOCAL cDrctry

   VarPush("DLOG092")

   SETCOLOR(Var(WNDW_CLR_))
   @ 14,13,22,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The MakDir() Function Attempts to Create"
   @ 02,02 WINSAY "a New DOS Subdirectory.  Pass a Character"
   @ 03,02 WINSAY "Value of the New Directory Name."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Directory to Create?"

   cDrctry := Space(60)

   DO WHILE .T.
      SetMsgLin(" Enter New Directory Name  ESC-Exit ",TRUE)

      @ 06,02 WINGET cDrctry PICTURE "@S41@!" ;
         HELPKEY "CDRCTRY"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand093(cDrctry)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << InPath() >> in Proc:  MENU014                    
//    Comment: InPath() Sample                                               
//;
PROCEDURE Dlog094()
   LOCAL GetList := {}
   LOCAL mFile

   VarPush("DLOG094")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,08,22,56 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The InPath() Function Will Check Your DOS"
   @ 02,02 WINSAY "PATH (Or Another) Environment Variable for"
   @ 03,02 WINSAY "The Existence of the Filename Passed."
   @ 04,02 WINSAY "InPath() Returns the Name of the Subdirectory"
   @ 05,02 WINSAY "Where the File is Located."
   SETCOLOR(Var(WNDW_CLR_))
   @ 07,02 WINSAY "Filename to Find:"

   mFile := Space(12)

   DO WHILE .T.
      SetMsgLin(" Enter a Filename  ESC-Exit ",TRUE)

      @ 07,20 WINGET mFile PICTURE "@!" VALIDBLOCK ;
      {|| ;
          Req("Enter a Filename", ;
              WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_)).and. ;
          Req("Enter a Filename", ;
              WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
         HELPKEY "MFILE"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand095(mFile)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << MaxHndls() >> in Proc:  MENU014                  
//    Comment: MaxHndls() Sample                                             
//;
PROCEDURE Dlog096()

   VarPush("DLOG096")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,11,22,56 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The MaxHndls() Function Counts the Number"
   @ 02,02 WINSAY "of Available DOS File Handles and Returns"
   @ 03,02 WINSAY "a Value Based on That Data."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Your System Has a Maximum xxx File Handles"
   @ 06,02 WINSAY "Available to Use."

   SetMsgLin(" Press ESC to Remove Window  ESC-Exit ",TRUE)

   Hand097()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << fEof() >> in Proc:  MENU013                      
//    Comment: fEof() Sample                                                 
//;
PROCEDURE Dlog098()

   VarPush("DLOG098")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,12,21,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The fEof() Function is to CR/LF Delimited"
   @ 02,02 WINSAY "Text Files What the Clipper Eof() Function"
   @ 03,02 WINSAY "is to Databases."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY 'A "DO WHILE !FEOF()/ENDDO" Loop (With an'
   @ 06,02 WINSAY "fGets() Inside) Will Read the Contents of"
   @ 07,02 WINSAY "a Text File."

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << fGets() >> in Proc:  MENU013                     
//    Comment: fGets() Sample                                                
//;
PROCEDURE Dlog099()

   VarPush("DLOG099")

   SETCOLOR(Var(WNDW_CLR_))
   @ 14,11,18,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The fGets() Function Simply Reads the Next"
   @ 02,02 WINSAY "Sequential Record of a CR/LF Delimited Text"
   @ 03,02 WINSAY "File."
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << fGetsR() >> in Proc:  MENU013                    
//    Comment: fGetsR() Sample                                               
//;
PROCEDURE Dlog100()

   VarPush("DLOG100")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,10,20,57 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The fGetsR() Function Works Like fGets()"
   @ 02,02 WINSAY "Except that it Reads the PREVIOUS Sequential"
   @ 03,02 WINSAY "Record in a CR/LF Delimted Text File.  The"
   @ 04,02 WINSAY '"R" Stands for "Reverse".'
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << TextView() >> in Proc:  MENU013                  
//    Comment: TextView() Sample                                             
//;
PROCEDURE Dlog101()

   VarPush("DLOG101")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,06,22,54 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The TextView() Function Displays the Contents"
   @ 02,02 WINSAY "of a CR/LF Delimited Text File Within a Set"
   @ 03,02 WINSAY "of Screen Coordinates."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY 'All the "Description" Menu Selections in'
   @ 06,02 WINSAY "This Program are Examples of TextView()."

   DO WHILE .T.
      SetMsgLin(" Press ESC to Remove Window  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Edt_Memo() >> in Proc:  MENU012                  
//    Comment: Edt_Memo() Sample                                             
//;
PROCEDURE Dlog106()

   VarPush("DLOG106")

   SETCOLOR(Var(WNDW_CLR_))
   @ 07,03,21,51 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "Edt_Memo() is the Full-Feature Half of the"
   @ 02,02 WINSAY "Builder Memo Functions."
   SETCOLOR(Var(WNDW_CLR_))
   @ 04,02 WINSAY "Edt_Memo() Will Put a Border on the Screen,"
   @ 05,02 WINSAY "a Title on the Window, and  Save Changes"
   @ 06,02 WINSAY "to Disk if Ctrl+W is Pressed."
   @ 08,02 WINSAY "Optionally You Can Start Editing at the End"
   @ 09,02 WINSAY "of the Memo Text or Limit the Size."
   @ 11,02 WINSAY "You Can Pass a Character String That is"
   @ 12,02 WINSAY "Appended to the Memo in the Event Any Changes"
   @ 13,02 WINSAY "are Made."

   SetMsgLin(" Press Enter for Test Memo  ESC-Exit ",TRUE)

   Hand107()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Show_Memo() >> in Proc:  MENU012                 
//    Comment: Show_Memo() Sample                                            
//;
PROCEDURE Dlog108()

   VarPush("DLOG108")

   SETCOLOR(Var(WNDW_CLR_))
   @ 10,00,22,54 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Show_Memo() Function Performs Some Features"
   @ 02,02 WINSAY "Before it Calls the Clipper MEMOEDIT() Function"
   SETCOLOR(Var(WNDW_CLR_))
   @ 04,04 WINSAY "o You Can Limit the Number of Lines Keyed"
   @ 05,06 WINSAY "into the Memo (Preventing Out of Memory Errors)"
   @ 07,04 WINSAY "o You Can Optionally Start Editting at the"
   @ 08,06 WINSAY "End of the Memo Text."

   SETCOLOR(Var(WMSG_CLR_))
   @ 10,02 WINSAY "However, It Does NOT:  Put a Border or Title"
   @ 11,02 WINSAY "On the Screen.  And Doesn't Save Changes to Disk"
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Press ESC to Continue  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << TtlKeyOn()/TtlKeyOff() >> in Proc:  MENU011      
//    Comment: TotalKeyOn()/TotalKeyOff()                                    
//;
PROCEDURE Dlog110()

   VarPush("DLOG110")

   SETCOLOR(Var(WNDW_CLR_))
   @ 12,06,22,55 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The TotalKeyOn() and TotalKeyOff() Functions"
   @ 02,02 WINSAY "Turn On and Off the Menu System's Ability to"
   @ 03,02 WINSAY "Jump Between Menus Dropped From the Root Menu."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Try This by Pressing the Right and Left Arrow"
   @ 06,02 WINSAY 'Keys From the "Library Functions" Menu.'
   @ 08,02 WINSAY "Builder Automatically Inserts Calls to These"
   @ 09,02 WINSAY "Functions Where Required."

   DO WHILE .T.
      SetMsgLin(" Press ESC to Continue  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << TimeOut() >> in Proc:  MENU011                   
//    Comment: TimeOut() Sample                                              
//;
PROCEDURE Dlog111()

   VarPush("DLOG111")

   SETCOLOR(Var(WNDW_CLR_))
   @ 11,00,22,54 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The TimeOut() Function Tests (Huup <deep breath>)"
   @ 02,02 WINSAY "The Keyboard, Screen, Disk, Communications, and"
   @ 03,02 WINSAY "Printer System Interrupts for Activity."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "If There is NO ACTIVITY on ANY Interrupt for the"
   @ 06,02 WINSAY "Specified Time Period, a Keystroke is Stuffed into"
   @ 07,02 WINSAY "the Keyboard Buffer.  Subsequent Calls to TimeOut()"
   @ 08,02 WINSAY 'and the Function Will Return the Value of "Y".'

   SETCOLOR(Var(WMSG_CLR_))
   @ 10,02 WINSAY "Press ENTER for a TimeOut() Test"
   SETCOLOR(Var(WNDW_CLR_))

   SetMsgLin(" TimeOut() Function Sample  ESC-Exit ",TRUE)

   Hand112()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Hand Code:  HAND112   TimeOut() Sample                        
//    Comment: TimeOut() Sample                                              
//;
PROCEDURE Dlog113()
   LOCAL GetList := {}
   LOCAL mDummy

   VarPush("DLOG113")

   SETCOLOR(Var(WNDW_CLR_))
   @ 08,13,14,61 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "If You Do Not Touch Your Keyboard for Five"
   @ 02,02 WINSAY "Consectutive Seconds, a TimeOut() Will Occur."
   SETCOLOR(Var(WNDW_CLR_))

   mDummy := Space(20)

   DO WHILE .T.
      SetMsgLin(" TimeOut() Function Sample  ESC-Exit ",TRUE)

      @ 04,02 WINGET mDummy ;
         HELPKEY "MDUMMY"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Hex2Dec() >> in Proc:  MENU010                   
//    Comment: Hex2Dec() Sample                                              
//;
PROCEDURE Dlog115()
   LOCAL GetList := {}
   LOCAL mHexnbr

   VarPush("DLOG115")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,08,22,50 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "What Function Library Would Be Complete"
   @ 02,02 WINSAY "Without a Hexidecimal to Decimal Number"
   @ 03,02 WINSAY "Conversion?"
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Enter Hex Number:"

   mHexnbr := Space(10)

   DO WHILE .T.
      SetMsgLin(" Enter a Hexidecimal Number to Convert  ESC-Exit ",TRUE)

      @ 05,20 WINGET mHexnbr PICTURE "@!" ;
         HELPKEY "MHEXNBR"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand116(mHexNbr)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Dec2Hex() >> in Proc:  MENU010                   
//    Comment: Dec2Hex() Sample                                              
//;
PROCEDURE Dlog117()
   LOCAL GetList := {}
   LOCAL mDecnbr

   VarPush("DLOG117")

   SETCOLOR(Var(WNDW_CLR_))
   @ 15,06,22,51 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "Of Course, a Library with a Hexidecimal to"
   @ 02,02 WINSAY "Decimal Conversion Also Needs the Ability"
   @ 03,02 WINSAY "to Do the Reverse Conversion."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Enter a Decimal Number:"

   mDecnbr := 0

   DO WHILE .T.
      SetMsgLin(" Enter a Number to Convert to Hexidecimal  ESC-Exit ",TRUE)

      @ 05,26 WINGET mDecnbr PICTURE "9999999999" ;
         HELPKEY "MDECNBR"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand118(mDecnbr)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << ErrTone() >> in Proc:  MENU018                   
//    Comment: ErrTone() Sample                                              
//;
PROCEDURE Dlog121()
   LOCAL GetList := {}
   LOCAL mTonenbr

   VarPush("DLOG121")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,01,22,45 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The ErrTone() Function Simply Sounds the"
   @ 02,02 WINSAY "Speaker of Your Computer.  It Makes Five"
   @ 03,02 WINSAY "Different Sounds.  Enter a Number Between"
   @ 04,02 WINSAY "0 and 4 Below to Hear Each Sound Made by"
   @ 05,02 WINSAY "ErrTone()."
   SETCOLOR(Var(WNDW_CLR_))
   @ 07,02 WINSAY "Error Tone to Sound:"

   mTonenbr := 0

   DO WHILE .T.
      SetMsgLin(" Enter a Number Between 0 and 4  ESC-Exit ",TRUE)

      @ 07,23 WINGET mTonenbr PICTURE "9" VALIDBLOCK ;
      {|| ;
          GenVld(Between(GETACTIVE():varGet(),0,4), ;
                 "Enter a Number Between 0 and 4 Only", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.F.,Var(WERR_CLR_))} ;
         HELPKEY "MTONENBR"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand124(mToneNbr)
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << WaitKey() >> in Proc:  MENU018                   
//    Comment: WaitKey() Sample                                              
//;
PROCEDURE Dlog122()

   VarPush("DLOG122")

   SETCOLOR(Var(WNDW_CLR_))
   @ 14,00,22,49 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The WaitKey() Function is a Replacement for"
   @ 02,02 WINSAY "the Clipper Inkey(0) Function.  The Builder"
   @ 03,02 WINSAY "WaitKey() Will Respond to Builder Mouse Inputs"
   @ 04,02 WINSAY "and Will React to SET KEY TO ... Also."
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02 WINSAY "All Builder Programs and Library Functions"
   @ 07,02 WINSAY "Use WaitKey() Where Appropriate."

   SetMsgLin(" Press Any Key to Continue  ESC-Exit ",TRUE)

   Hand123()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Asc2Bin() >> in Proc:  MENU010                   
//    Comment: Asc2Bin() Sample                                              
//;
PROCEDURE Dlog125()

   VarPush("DLOG125")

   SETCOLOR(Var(WNDW_CLR_))
   @ 06,02,22,52 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Asc2Bin() Function Allows You to Create"
   @ 02,02 WINSAY "Character Strings With Embedded Control"
   @ 03,02 WINSAY "Characters Easily."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "This is Especially Useful When Creating"
   @ 06,02 WINSAY "Printer Control Strings."
   @ 08,02 WINSAY "For Example:"
   @ 09,02 WINSAY 'The String "^[l1O" When Passed to Asc2Bin()'
   @ 10,02 WINSAY 'Would Create the HP-PCL Control Code Esc+"l1O",'
   @ 11,02 WINSAY 'or the Equivalent of Chr(27)+"l1O" in Clipper'
   @ 12,02 WINSAY "Code.  (Laser Printer Code for Landscape)"

   SETCOLOR(Var(WMSG_CLR_))
   @ 14,02 WINSAY "This Allows Storing Printer Control Strings"
   @ 15,02 WINSAY "in Databases That Users Can Update."
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" Asc2Bin() Function Example  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << AddMPad()/DelMPad() >> in Proc:  MENU019         
//    Comment: AddMPad()/DelMPad() Sample                                    
//;
PROCEDURE Dlog126()

   VarPush("DLOG126")

   SETCOLOR(Var(WNDW_CLR_))
   @ 06,03,22,50 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The AddMPad() and DelMPad() Functions Add"
   @ 02,02 WINSAY "and Delete Mouse Hot Spots.  You Will Only"
   @ 03,02 WINSAY "Need to Use These for Your Own Routines or"
   @ 04,02 WINSAY "Adding Mouse Awareness to Another 3rd Party"
   @ 05,02 WINSAY "Library Function.  All Builder GETs, Menus,"
   @ 06,02 WINSAY "and Picklists are Already Mouse Aware."
   SETCOLOR(Var(WNDW_CLR_))
   @ 08,02 WINSAY "If the AddMPad() Does Not Work, You May Need"
   @ 09,02 WINSAY "to Use the Builder SetMouse() Function.  See"
   @ 10,02 WINSAY "the Description for SetMouse() for More"
   @ 11,02 WINSAY "Information."
   @ 13,02 WINSAY "............................................"
   @ 14,02 WINSAY "........Click.Left.Mouse.Button.Here........"
   @ 15,02 WINSAY "............................................"

   SetMsgLin(" AddMPad()/DelMPad() Function Sample  ESC-Exit ",TRUE)

   Hand127()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Lateral Scrolling >> in Proc:  MENU003           
//    Comment: Lateral Scroll Picklist Sample                                
//;
PROCEDURE Dlog128()

   VarPush("DLOG128")

   SETCOLOR(Var(WNDW_CLR_))
   @ 07,25,19,71 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "If a Picklist Window is Narrower than the"
   @ 02,02 WINSAY "Data Being Displayed, an Arrow is Displayed"
   @ 03,02 WINSAY "in Either the Lower Left or Right Corner of"
   @ 04,02 WINSAY "the Window.  This Indicates More Data is"
   @ 05,02 WINSAY "Available for Viewing Outside the Window"
   @ 06,02 WINSAY "Boundries."
   SETCOLOR(Var(WNDW_CLR_))
   @ 08,02 WINSAY "Press the Left/Right Arrows or TAB/Back TAB"
   @ 09,02 WINSAY "Keys to Scroll the Picklist Laterally.  You"
   @ 10,02 WINSAY "Can Also Press the Left Mouse Button on the"
   @ 11,02 WINSAY "Left or Right Picklist Border."

   SetMsgLin(" Press ENTER for Example  ESC-Exit ",TRUE)

   Hand129()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Between() >> in Proc:  MENU018                   
//    Comment: Between() Sample                                              
//;
PROCEDURE Dlog131()
   LOCAL GetList := {}
   LOCAL mNumber

   VarPush("DLOG131")

   SETCOLOR(Var(WNDW_CLR_))
   @ 12,01,22,46 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Between() Function Simply Determines"
   @ 02,02 WINSAY "If a Value (any data type) is <= One Value"
   @ 03,02 WINSAY "and >= to Another Value."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "To Test This, Enter a Number Between 1 and"
   @ 06,02 WINSAY "100."
   @ 08,02 WINSAY "Enter a Number:"

   mNumber := 0

   DO WHILE .T.
      SetMsgLin(" Enter a Number Between 1 and 100  ESC-Exit ",TRUE)

      @ 08,18 WINGET mNumber PICTURE "999999" VALIDBLOCK ;
      {|| ;
          GenVld(Between(GETACTIVE():varGet(),1,100), ;
                 "That Number is NOT Between 1 and 100", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.T.,Var(WERR_CLR_))} ;
         HELPKEY "MNUMBER"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Numeric() >> in Proc:  MENU018                   
//    Comment: Numeric() Sample                                              
//;
PROCEDURE Dlog132()
   LOCAL GetList := {}
   LOCAL mNumtst

   VarPush("DLOG132")

   SETCOLOR(Var(WNDW_CLR_))
   @ 12,00,22,45 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The Numeric() Function Tests a Character"
   @ 02,02 WINSAY "String to Determine if All the Characters"
   @ 03,02 WINSAY "are Numeric or Not."
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Enter Numeric or Non-Numeric or Mixed Data"
   @ 06,02 WINSAY "to Test:"
   @ 08,02 WINSAY "Numeric Data Test:"

   mNumtst := Space(10)

   DO WHILE .T.
      SetMsgLin(" Enter Numeric() Test String  ESC-Exit ",TRUE)

      @ 08,21 WINGET mNumtst VALIDBLOCK ;
      {|| ;
          GenVld(Numeric(GETACTIVE():varGet()), ;
                 "Data is NOT Numeric", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.T.,Var(WERR_CLR_))} ;
         HELPKEY "MNUMTST"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << DbState() >> in Proc:  MENU018                   
//    Comment: DbState() Sample                                              
//;
PROCEDURE Dlog135()

   VarPush("DLOG135")

   SETCOLOR(Var(WNDW_CLR_))
   @ 08,00,22,48 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The DbState() Function is Useful When You are"
   @ 02,02 WINSAY "Writing Your Own Routines.  It Saves All"
   @ 03,02 WINSAY "Aspects of a Database Select Area to a Memory"
   @ 04,02 WINSAY "Variable.  Passing a DbState() Created Memory"
   @ 05,02 WINSAY "Variable as a Parameter Will Restore The"
   @ 06,02 WINSAY "Database to It's Previous State."
   SETCOLOR(Var(WNDW_CLR_))
   @ 08,02 WINSAY "DbState() Saves The Select Area, Index Order"
   @ 09,02 WINSAY "Number, Filter Condition, All Relations, and"
   @ 10,02 WINSAY "the Database Record Number."

   SETCOLOR(Var(WMSG_CLR_))
   @ 12,02 WINSAY "DbState() is Most Helpful When Writing"
   @ 13,02 WINSAY "'Black Box' Functions."
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" DbState() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << MouseInit() >> in Proc:  MENU019                 
//    Comment: MouseInit() Sample                                            
//;
PROCEDURE Dlog136()

   VarPush("DLOG136")

   SETCOLOR(Var(WNDW_CLR_))
   @ 09,03,22,50 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The MouseInit() Function Should Only Be Used"
   @ 02,02 WINSAY "Once per Program Execution.  It Initializes"
   @ 03,02 WINSAY "the Mouse Awareness for a Builder Application"
   SETCOLOR(Var(WNDW_CLR_))
   @ 05,02 WINSAY "Builder Will Put the MouseInit() Call in"
   @ 06,02 WINSAY "the Program for You."

   SETCOLOR(Var(WMSG_CLR_))
   @ 08,02 WINSAY "MouseInit() Initializes the Mouse Interrupt"
   @ 09,02 WINSAY "(Int 51h), Turns the Mouse Cursor On, Puts"
   @ 10,02 WINSAY "the Mouse Cursor in the Lower Right Screen"
   @ 11,02 WINSAY "Corner, and Initializes the Array Used by"
   @ 12,02 WINSAY "AddMPad()/DelMPad()"
   SETCOLOR(Var(WNDW_CLR_))

   DO WHILE .T.
      SetMsgLin(" MouseInit() Function Information  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Dialog Window:  DLOG141   GetEdit() Sample                    
//    Comment: AbGetEdit() Sample                                            
//;
PROCEDURE Dlog140()
   LOCAL GetList := {}
   LOCAL qCmprs,qLndcmp,qReset

   VarPush("DLOG140")

   SETCOLOR(Var(WNDW_CLR_))
   @ 07,09,16,64 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "PRINTER CODES:"
   SETCOLOR(Var(WNDW_CLR_))
   @ 03,02 WINSAY "132 Columns"
   @ 05,02 WINSAY "273 Columns"
   @ 07,08 WINSAY "Reset"

   qCmprs := Options->Cmprs
   qLndcmp := Options->LndCmp
   qReset := Options->Reset

   DO WHILE .T.
      SetMsgLin(" Enter Printer Codes  ESC-Exit ",TRUE)

      @ 03,14 WINGET qCmprs ;
         HELPKEY "QCMPRS"
      @ 05,14 WINGET qLndcmp ;
         HELPKEY "QLNDCMP"
      @ 07,14 WINGET qReset ;
         HELPKEY "QRESET"

      GetEdit("OPTIONS",WinBott()-1,WinLeft()+2,GetList)
      EXIT
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << GetEdit() >> in Proc:  MENU017                   
//    Comment: GetEdit() Sample                                              
//;
PROCEDURE Dlog141()

   VarPush("DLOG141")

   SETCOLOR(Var(WNDW_CLR_))
   @ 13,04,22,47 WINDOW STYLE "3+"

   SETCOLOR(Var(WMSG_CLR_))
   @ 01,02 WINSAY "The GetEdit() function allows you to"
   @ 02,02 WINSAY "save fields edited in a dialog box to a"
   @ 03,02 WINSAY "database record--using ONE line of code!"
   @ 05,02 WINSAY "This is most useful when programming a"
   @ 06,02 WINSAY "window to edit your system's defaults."
   SETCOLOR(Var(WNDW_CLR_))
   @ 08,02 WINSAY "Press any key to see a sample."

   DO WHILE .T.
      SetMsgLin(" Press Any key for Sample Window  ESC-Exit ",TRUE)

      WaitKey(0)     // Wait for KeyStroke

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Dlog140()
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Sample Dialog 2 >> in Proc:  MENU005             
//    Comment: Sample Dialog All Controls                                    
//;
PROCEDURE Dlog153()
   LOCAL GetList := {}
   LOCAL dDate,nNumber,nDrive,lTaxable,nStatus, ;
          cDesc

   VarPush("DLOG153")

   SETCOLOR(Var(WNDW_CLR_))
   @ 04,29,21,78 WINDOW STYLE "3+"
   SETCOLOR(Var(WNDW_CLR_))
   @ 06,01 WINSAY "               Ŀ"
   @ 07,01 WINSAY "                    "
   @ 08,01 WINSAY "                    "
   @ 09,01 WINSAY "                    "
   @ 10,01 WINSAY "                    "
   @ 11,01 WINSAY "                    "
   @ 12,01 WINSAY " "


   @ 01,02 WINSAY "Demonstration of all Builder GET controls."
   @ 03,05 WINSAY "Date:"
   @ 03,24 WINSAY "(<Alt+Up/Down> Spins)"
   @ 04,02 WINSAY "Numeric:"
   @ 06,04 WINSAY "Floppy Drive"
   @ 08,05 WINSAY '3.5" 1.44 MB'
   @ 08,25 WINSAY "Taxable:"
   @ 09,05 WINSAY '3.5" 720 KB'
   @ 10,05 WINSAY '5.25" 1.2 MB'
   @ 10,26 WINSAY "Status:"
   @ 11,05 WINSAY '5.25" 360 KB'
   @ 11,26 WINSAY "(<Alt+Down> Dropdown)"
   @ 14,03 WINSAY "Description:"

   dDate := DATE()
   nNumber := 300
   nDrive := 1
   lTaxable := TRUE
   nStatus := 1
   cDesc := SPACE( 40 )

   DO WHILE .T.
      SetMsgLin(" Edit Dialog Controls  ESC-Exit ",TRUE)

      @ 03,11 WINGET dDate ;
         WHEN CalInit() ;
         HELPKEY "DDATE" WITH SPINNER
      @ 04,11 WINGET nNumber PICTURE "99,999.99" ;
         WHEN CalcInit() ;
         HELPKEY "NNUMBER" WITH SPINNER
      @ 08,18 WINGET nDrive RADIOBUTTON USING {"(*)","( )"} GROUP 1 ;
         HELPKEY "NDRIVE"
      @ 09,18 WINGET nDrive RADIOBUTTON USING {"(*)","( )"} GROUP 1 ;
         HELPKEY "NDRIVE"
      @ 10,18 WINGET nDrive RADIOBUTTON USING {"(*)","( )"} GROUP 1 ;
         HELPKEY "NDRIVE"
      @ 11,18 WINGET nDrive RADIOBUTTON USING {"(*)","( )"} GROUP 1 ;
         HELPKEY "NDRIVE"
      @ 08,34 WINGET lTaxable CHECKBOX USING {"[x]","[ ]"} ;
         HELPKEY "LTAXABLE"
      @ 10,34 WINGET nStatus DROPDOWN USING {"Ordered","Shipped","Billed","Received","Paid"} ;
         HELPKEY "NSTATUS"
      @ 15,03 WINGET cDesc ;
         HELPKEY "CDESC"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // Add a command here to execute something after this
      // dialog box
   ENDDO

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << Shift States >> in Proc:  MENU014                
//    Comment: Shift States Dialog                                           
//;
PROCEDURE Dlog160()

   VarPush("DLOG160")

   SETCOLOR(Var(WNDW_CLR_))
   @ 07,16,20,63 WINDOW STYLE "3+"

   @ 01,02 WINSAY "There are four functions which return the"
   @ 02,02 WINSAY "various keyboard shift states.  You can also"
   @ 03,02 WINSAY "set the Caps, Num, and Scroll Lock states."

   SETCOLOR(Var(WMSG_CLR_))
   @ 05,02 WINSAY "A fifth function allows displaying the shift"
   @ 06,02 WINSAY "states by writing to video memory.  This is"
   @ 07,02 WINSAY "needed to avoid moving the cursor."
   SETCOLOR(Var(WNDW_CLR_))
   @ 09,02 WINSAY "The 2nd to last screen line should now be"
   @ 10,02 WINSAY "showing shift states.  Press 1 to set/reset"
   @ 11,02 WINSAY "Caps Lock, 2 to set/reset Num Lock, and 3 to"
   @ 12,02 WINSAY "set/reset Scroll Lock."

   //SetMsgLin(" Enter Your Own Message Line Here  ESC-Exit ",TRUE)

   Hand161()

   VarPop()
   WINDOW REMOVE

//͸
//  CALLED BY: Selection << DrvTst() >> in Proc:  MENU014                    
//    Comment: DrvTst() Sample Dialog                                        
//;
PROCEDURE Dlog162()
   LOCAL GetList := {}
   LOCAL cDrive

   VarPush("DLOG162")

   SETCOLOR(Var(WNDW_CLR_))
   @ 12,01,19,51 WINDOW STYLE "3+"

   @ 01,02 WINSAY "The DrvTst() function tests the disk drive"
   @ 02,02 WINSAY "passed as the first parameter.  Enter a Drive"
   @ 03,02 WINSAY "Letter to test."

   SETCOLOR(Var(WMSG_CLR_))
   @ 05,02 WINSAY "Drive to Test:"
   SETCOLOR(Var(WNDW_CLR_))

   cDrive := "A"

   DO WHILE .T.
      SetMsgLin(" Enter Drive Letter to Test  ESC-Exit ",TRUE)

      @ 05,17 WINGET cDrive PICTURE "!" VALIDBLOCK ;
      {|| ;
          GenVld(ISALPHA(GetActive():varGet()), ;
                 "A through Z only.", ;
                 WinBott()-1,WinLeft()+2,WinRight()-2,.T.,Var(WERR_CLR_))} ;
         HELPKEY "CDRIVE"

      ReadGets(@GetList)

      IF LASTKEY() == K_ESC
         EXIT
      ENDIF

      // You may want to do some validations here
      // before executing the next proc
      Hand163( cDrive )
   ENDDO

   VarPop()
   WINDOW REMOVE

// ENDDLOG End of Dialog Box Procs 

//͸
// >>>>>>>>>>>>>>>>>>>>>> Related Maintenance Windows <<<<<<<<<<<<<<<<<<<<< 
//;

//͸
//  CALLED BY: Pick List Window:  PLST061   Rel_Maint() Sample               
//    Comment: Rel_Maint() Sample (Maint)                                    
//;
PROCEDURE Rmnt062()
   LOCAL xBounds
   VarPush("RMNT062")

   SETCOLOR(Var(WNDW_CLR_))
   @ 05,00,12,29 WINDOW STYLE "3+"

   @ 02,02 WINSAY "First"
   @ 03,03 WINSAY "Last"
   @ 05,02 WINSAY "Phone"

   Friends->(DBSETORDER(1))

   Friends->(DBSEEK(Cities->City,.F.))

   xBounds := Cities->City
   Friends->(Rel_Maint(WinTop(),WinLeft(),WinBott(),WinRight(),"062", ;
      {||xBounds==Friends->City},,aFriends,1,"ACD"))

   VarPop()
   WINDOW REMOVE

FUNCTION Get062(cG_Func)
   LOCAL GetList := {}

   // Set Relation Key Fields
   BCITY := Cities->City

   @ 02,08 WINGET BFNAME PICTURE "!xxxxxxxxxxxxx" VALIDBLOCK ;
      {|| ;
          Req("First Name Required", ;
              WinBott()-1,WinLeft()+2,WinRight()-2,Var(WERR_CLR_))} ;
      HELPKEY "FNAME"
   @ 03,08 WINGET BLNAME PICTURE "!xxxxxxxxxxxxxxxxxxx" ;
      HELPKEY "LNAME"
   @ 05,08 WINGET BPHONE PICTURE "@R (999) 999-9999" ;
      HELPKEY "PHONE"

   IF cG_Func$"AC"
      ReadGets(@GetList)
   ENDIF
   RETURN(NIL)

// ENDRMNT End of Related Maintenances 

//͸
//  >>>>>>>>>>>>>>>>>>>>>>>>>>>> TBrowse Calls <<<<<<<<<<<<<<<<<<<<<<<<<<<<  
//;

//͸
//  CALLED BY: Hand Code:  HAND149   Position TBrowse Database               
//    Comment: TBrowse Demo                                                  
//;
FUNCTION Brws146()
   LOCAL nBr1,nBc1,nBr2,nBc2
   LOCAL nDisplayRow
   LOCAL oBrwObj,oColObj
   LOCAL aBrwCtrls := {},aColCtrls := {}
   LOCAL cOldColor := SETCOLOR(Var(BRWS_CLR_))
   LOCAL cDbStatus
   LOCAL aBrwObj
   LOCAL aHiddenCols := {}

   VarPush("BRWS146")

   nBr1 := 04
   nBc1 := 12
   nBr2 := nBr1+10
   nBc2 := nBc1+55


   // Add Browse Controls to a Control Dictionary
   // Builder TBrowse internal controls
   DictPut(aBrwCtrls,"WINCOORD",{nBr1,nBc1,nBr2,nBc2})  // Win Corrdinates
   DictPut(aBrwCtrls,"ALIAS","Cities")    // TB Alias
   DictPut(aBrwCtrls,"ORDER",2)       // TB Index Order
   DictPut(aBrwCtrls,"DELINDX",4)      // Delete Index
   DictPut(aBrwCtrls,"BOUNDS",NIL)      // Bounded by Block
   DictPut(aBrwCtrls,"BNDKEYS",NIL)     // Bounded by Key Init

   // Builder TBrowse options controls
   DictPut(aBrwCtrls,"HGLTBAR",NIL)     // Highlight Bar Color Pair
   DictPut(aBrwCtrls,"FREEZE",.T.)      // Freeze Control
   DictPut(aBrwCtrls,"DELETE",.T.)      // Delete/Recover Control
   DictPut(aBrwCtrls,"AWIDTH",.T.)      // Adjust Column Width Control
   DictPut(aBrwCtrls,"CHGORD",.F.)      // Change Index Order Control
   DictPut(aBrwCtrls,"IDXSRC",.T.)      // Index Search Control
   DictPut(aBrwCtrls,"APPEND",.F.)      // Append Records Control
   DictPut(aBrwCtrls,"RECNBR",.T.)      // Record Number Visible @Start
   DictPut(aBrwCtrls,"RECTGL",.T.)      // Record Number Column Toggle Control
   DictPut(aBrwCtrls,"DELREC",.T.)      // Delete Database Record Control
   DictPut(aBrwCtrls,"GOTOCOL",.F.)     // Enable Column Goto Control

   // Change the NIL here to the Seek prefix to use
   // if neeeded with Bounded by TBrowses.
   DictPut(aBrwCtrls,"BNDPFX",NIL)      // Bounded by Prefix

   // Change the {} here to a list of index orders
   // to remove from the Change Index Order list.
   DictPut(aBrwCtrls,"ORDEXCPT",{})     // Idx Orders to X From List

   // Change the NIL here to a codeblock that will
   // be evaluated for every TBrowse keystroke.
   DictPut(aBrwCtrls,"KYHNDLR",NIL)      // User Key Handler

   // Initialize the TBrowse Object
   oBrwObj := TBrowseDb(nBr1+1,nBc1+1,nBr2-2,nBc2-1)
   oBrwObj:cargo := aBrwCtrls
   oBrwObj:goBottomBlock := {||Cities->(AbGoBottom(oBrwObj))}
   oBrwObj:goTopBlock := {||Cities->(AbGoTop(oBrwObj))}
   oBrwObj:skipBlock := {|x|Cities->(AbTBSkip(x,oBrwObj))}
   oBrwObj:colorSpec := Var(BRWS_CLR_)+","+Var(BRWS_HL1_)+","+Var(BRWS_HL2_)
   oBrwObj:headSep := ""
   oBrwObj:colSep  := "  "
   oBrwObj:footSep := ""

   // Add Column Objects to the TBrowse Object
   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.F.)
   DictPut(aColCtrls,"PICTURE",NIL)
   DictPut(aColCtrls,"COLNBR",1)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("CITY",SELECT("Cities")))
   oColObj := TBColumnNew("City", ;
      {||Cities->City})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE","!!")
   DictPut(aColCtrls,"COLNBR",2)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID", ;
      {|| ;
          GenVld(In_Usa( Cities->State ), ;
                 "Not a Valid U.S. State Code", ;
                 nBr2-1,nBc1+2,nBc2-2,.F.,Var(BRWS_CLR_))})
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("STATE",SELECT("Cities")))
   oColObj := TBColumnNew("State", ;
      {||TRANSFORM(Cities->State,"!!")})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE",NIL)
   DictPut(aColCtrls,"COLNBR",3)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("ZIP",SELECT("Cities")))
   oColObj := TBColumnNew("Zip Code", ;
      {||Cities->Zip})
   oColObj:cargo := aColCtrls
   oColObj:defColor := { 3, 4 }
   oColObj:colorBlock := {|x|IF(!"0" $ x,{ 5, 6 }, {} ) }
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE",NIL)
   DictPut(aColCtrls,"COLNBR",4)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK", ;
      {|x|IF(x==NIL,Cities->Text,Cities->Text:=x)})
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("TEXT",SELECT("Cities")))
   oColObj := TBColumnNew("Text", ;
      {||"<Memo>"})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE",NIL)
   DictPut(aColCtrls,"COLNBR",5)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK", ;
      {||MsgBox( { "Execute Any Function","With This Technique!" } )})
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("< SEE ME >",SELECT("Cities")))
   oColObj := TBColumnNew("Execute Function", ;
      {||"<< See Me >>"})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE",NIL)
   DictPut(aColCtrls,"COLNBR",6)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("BOOLEAN",SELECT("Cities")))
   oColObj := TBColumnNew("Logical", ;
      {||IF(Cities->Boolean,"<True> ","<False>")})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   // Free up some memory
   oColObj   := NIL
   aBrwCtrls := NIL
   aColCtrls := NIL

   // Put a Window on the Screen
   @ nBr1,nBc1,nBr2,nBc2 WINDOW STYLE "3+"

   // Add Some Other Display Items
   nDisplayRow := oBrwObj:nBottom - oBrwObj:rowCount - 1

   // Put Hidden Columns in Object Dictionary
   DictPut(oBrwObj:cargo,"SAVCOLS",aHiddenCols)
   aBrwObj := { oBrwObj, Brws152() }

   // Execute the Browse
   DO WHILE .T.
      SetMsgLin(" Arrows/PgUp/PgDn-Move  ENTER-Edit  Alt+M-Menu  Ctrl+ENTER-Next  ESC-Exit ",TRUE)
      IF !BrowseDb(aBrwObj)
         EXIT
      ENDIF
      cDbStatus := DbState()
      DbState( cDbStatus )
   ENDDO

   SETCOLOR(cOldColor)
   WINDOW REMOVE   // Remove Window from Screen
   WINDOW REMOVE   // Remove Window from Screen
   VarPop()

   RETURN(oBrwObj)

//͸
//  CALLED BY: Table Browse: BRWS146   TBrowse Demo                          
//    Comment: Related TBrowse Test                                          
//;
FUNCTION Brws152()
   LOCAL nBr1,nBc1,nBr2,nBc2
   LOCAL nDisplayRow
   LOCAL oBrwObj,oColObj
   LOCAL aBrwCtrls := {},aColCtrls := {}
   LOCAL cOldColor := SETCOLOR(Var(BRWS_CLR_))
   LOCAL cDbStatus
   LOCAL aBrwObj
   LOCAL aHiddenCols := {}

   //Array to initialize new bounded by records
   LOCAL aBndKeyBlks := { ;
         {||Friends->City:=Cities->City} ;
      }

   VarPush("BRWS152")

   nBr1 := 15
   nBc1 := 24
   nBr2 := nBr1+07
   nBc2 := nBc1+43


   // Add Browse Controls to a Control Dictionary
   // Builder TBrowse internal controls
   DictPut(aBrwCtrls,"WINCOORD",{nBr1,nBc1,nBr2,nBc2})  // Win Corrdinates
   DictPut(aBrwCtrls,"ALIAS","Friends")    // TB Alias
   DictPut(aBrwCtrls,"ORDER",1)       // TB Index Order
   DictPut(aBrwCtrls,"DELINDX",2)      // Delete Index
   DictPut(aBrwCtrls,"BOUNDS", ;
      {|x|IF(x==NIL,Friends->City==Cities->City,Cities->City)})     // Bounded by Field
   DictPut(aBrwCtrls,"BNDKEYS",aBndKeyBlks)     // Bounded by Key Init

   // Builder TBrowse options controls
   DictPut(aBrwCtrls,"HGLTBAR",NIL)     // Highlight Bar Color Pair
   DictPut(aBrwCtrls,"FREEZE",.T.)      // Freeze Control
   DictPut(aBrwCtrls,"DELETE",.T.)      // Delete/Recover Control
   DictPut(aBrwCtrls,"AWIDTH",.T.)      // Adjust Column Width Control
   DictPut(aBrwCtrls,"CHGORD",.F.)      // Change Index Order Control
   DictPut(aBrwCtrls,"IDXSRC",.F.)      // Index Search Control
   DictPut(aBrwCtrls,"APPEND",.T.)      // Append Records Control
   DictPut(aBrwCtrls,"RECNBR",.F.)      // Record Number Visible @Start
   DictPut(aBrwCtrls,"RECTGL",.T.)      // Record Number Column Toggle Control
   DictPut(aBrwCtrls,"DELREC",.T.)      // Delete Database Record Control
   DictPut(aBrwCtrls,"GOTOCOL",.F.)     // Enable Column Goto Control

   // Change the NIL here to the Seek prefix to use
   // if neeeded with Bounded by TBrowses.
   DictPut(aBrwCtrls,"BNDPFX",NIL)      // Bounded by Prefix

   // Change the {} here to a list of index orders
   // to remove from the Change Index Order list.
   DictPut(aBrwCtrls,"ORDEXCPT",{})     // Idx Orders to X From List

   // Change the NIL here to a codeblock that will
   // be evaluated for every TBrowse keystroke.
   DictPut(aBrwCtrls,"KYHNDLR",NIL)      // User Key Handler

   // Initialize the TBrowse Object
   oBrwObj := TBrowseDb(nBr1+1,nBc1+1,nBr2-2,nBc2-1)
   oBrwObj:cargo := aBrwCtrls
   oBrwObj:goBottomBlock := {||Friends->(AbGoBottom(oBrwObj))}
   oBrwObj:goTopBlock := {||Friends->(AbGoTop(oBrwObj))}
   oBrwObj:skipBlock := {|x|Friends->(AbTBSkip(x,oBrwObj))}
   oBrwObj:colorSpec := Var(BRWS_CLR_)+","+Var(BRWS_HL1_)+","+Var(BRWS_HL2_)
   oBrwObj:headSep := ""
   oBrwObj:colSep  := "  "
   oBrwObj:footSep := ""

   // Add Column Objects to the TBrowse Object
   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE","!xxxxxxxxxxxxxx")
   DictPut(aColCtrls,"COLNBR",1)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("FNAME",SELECT("Friends")))
   oColObj := TBColumnNew("First", ;
      {||TRANSFORM(Friends->Fname,"!xxxxxxxxxxxxxx")})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE","!xxxxxxxxxxxxxxxxxxx")
   DictPut(aColCtrls,"COLNBR",2)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("LNAME",SELECT("Friends")))
   oColObj := TBColumnNew("Last", ;
      {||TRANSFORM(Friends->Lname,"!xxxxxxxxxxxxxxxxxxx")})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   aColCtrls := {}
   DictPut(aColCtrls,"EDITABLE",.T.)
   DictPut(aColCtrls,"PICTURE","@R (999) 999-9999")
   DictPut(aColCtrls,"COLNBR",3)
   DictPut(aColCtrls,"WHEN",NIL)
   DictPut(aColCtrls,"VALID",)
   DictPut(aColCtrls,"EXECBLK",NIL)
   DictPut(aColCtrls,"GETBLK",FIELDWBLOCK("PHONE",SELECT("Friends")))
   oColObj := TBColumnNew("Phone", ;
      {||TRANSFORM(Friends->Phone,"@R (999) 999-9999")})
   oColObj:cargo := aColCtrls
   oBrwObj:addColumn(oColObj)

   // Free up some memory
   oColObj   := NIL
   aBrwCtrls := NIL
   aColCtrls := NIL

   // Put a Window on the Screen
   @ nBr1,nBc1,nBr2,nBc2 WINDOW STYLE "3+"

   // Add Some Other Display Items
   nDisplayRow := oBrwObj:nBottom - oBrwObj:rowCount - 1

   // Put Hidden Columns in Object Dictionary
   DictPut(oBrwObj:cargo,"SAVCOLS",aHiddenCols)
   aBrwObj := { oBrwObj }

   // Execute the Browse

   SETCOLOR(cOldColor)
   VarPop()

   RETURN(oBrwObj)

// ENDBRWS End of Tbrowse Windows 

//͸
//  >>>>>>>>>>>>>>>>>>>>>>>>>>> Pick List Boxes <<<<<<<<<<<<<<<<<<<<<<<<<<<  
//;

//͸
//  CALLED BY: Hand Code:  HAND102   Picklist No Options Setup               
//    Comment: No Options Picklist                                           
//;
PROCEDURE Plst027()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp

   nPr1 := 11
   nPc1 := 22
   nPr2 := nPr1+09
   nPc2 := nPc1+44

   VarPush("PLST027")

   SETCOLOR(Var(WNDW_CLR_))

   cDisp := 'Transform(Zip,"@R 99999 99999")+" "+State+" "+City'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",1,cDisp,.F.,"","",{||Hand032()})

   VarPop()

//͸
//  CALLED BY: Hand Code:  HAND056   Setup Bounded by Picklist               
//    Comment: Picklist Bounded by Sample                                    
//;
PROCEDURE Plst029()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp
   LOCAL mState,bCond

   nPr1 := 16
   nPc1 := 32
   nPr2 := nPr1+06
   nPc2 := nPc1+44

   VarPush("PLST029")

   SETCOLOR(Var(WNDW_CLR_))

   // NOTE:  Using the PLIST() Bounded By option usually will require
   //        an indexed search here

   // Set Bounded By Memvar
   mState := Cities->State
   bCond := {||Cities->State == mState}

   cDisp := 'State+" "+City+" "+Transform(Zip,"@R 99999 9999")'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",3,cDisp,.F.,"","",{||Hand033()},bCond)

   VarPop()

//͸
//  CALLED BY: Hand Code:  HAND103   QWERTY Scroll Option Setup              
//    Comment: QWERTY Picklist Sample                                        
//;
PROCEDURE Plst030()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp
   LOCAL cKey

   nPr1 := 14
   nPc1 := 22
   nPr2 := nPr1+07
   nPc2 := nPc1+44

   VarPush("PLST030")

   SETCOLOR(Var(WNDW_CLR_))

   // You may want KF initialized to something other than
   // spaces, it depends on your particular usage
   cKey := SPACE(25)

   cDisp := 'City+" "+State+" "+Transform(Zip,"@R 99999 9999")'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",2,cDisp,.T.,@cKey,"",{||Hand031()})

   VarPop()

//͸
//  CALLED BY: Hand Code:  HAND139   Rel_Maint() Sample                      
//    Comment: Rel_Maint() Sample                                            
//;
PROCEDURE Plst061()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp
   LOCAL cKey

   nPr1 := 08
   nPc1 := 02
   nPr2 := nPr1+06
   nPc2 := nPc1+44

   VarPush("PLST061")

   SETCOLOR(Var(WNDW_CLR_))

   // You may want KF initialized to something other than
   // spaces, it depends on your particular usage
   cKey := SPACE(25)

   cDisp := 'City+" "+State+" "+Transform(Zip,"@R 99999 9999")'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",2,cDisp,.T.,@cKey,"",{||Rmnt062()})

   VarPop()

//͸
//  CALLED BY: Hand Code:  HAND129   Lateral Scroll Picklist Sample          
//    Comment: Lateral Scroll Picklist Sample                                
//;
PROCEDURE Plst130()
   LOCAL nPr1,nPc1,nPr2,nPc2,cDisp

   nPr1 := 15
   nPc1 := 52
   nPr2 := nPr1+06
   nPc2 := nPc1+25

   VarPush("PLST130")

   SETCOLOR(Var(WNDW_CLR_))

   cDisp := 'Zip+" "+City+" "+State'
   Plist(nPr1,nPc1,nPr2,nPc2,"CITIES",1,cDisp,.F.,"","",{||Hand133()})

   VarPop()

// ENDPLST End of Picklist Calls 

//͸
//  >>>>>>>>>>>>>>>>>>>>>>> File Maintenance Calls <<<<<<<<<<<<<<<<<<<<<<<<  
//                                                                           
//͵
//                        Note: for GEN_MAINT calls:                         
//          If the 3rd to last parameter is zero (0), you may want           
//          to replace it with the index order number of the index           
//                               created like:                               
//                   INDE ON IF(DELETED(),"*"," ") TO ...                    
//                            This requires that:                            
//                              SET DELETED ON                               
//           is in effect also.  This way the deleted records will           
//           be RECALLED and updated when you add a record instead           
//           of always doing an APPEND BLANK. This method removes            
//                      the need to PACK the database.                       
//;

//͸
//  CALLED BY: Hand Code:  HAND104   File Maintenance Setup                  
//    Comment: City File Maintenance                                         
//;
PROCEDURE Fmnt034()
   LOCAL nFmr1,nFmc1,nFmr2,nFmc2

   VarPush("FMNT034")

   nFmr1 := 13
   nFmc1 := 26
   nFmr2 := nFmr1+08
   nFmc2 := nFmc1+36

   SETCOLOR(Var(WNDW_CLR_))
   Cities->(DBSETORDER(2))

   Cities->(Gen_Maint(nFmr1,nFmc1,nFmr2,nFmc2,"034",aCities,4,.F.,"ACDF"))

   VarPop()

FUNCTION gSays_034()
   SETCOLOR(Var(WNDW_CLR_))
   @ 02,03 WINSAY "City"
   @ 04,03 WINSAY "State"
   @ 04,15 WINSAY "Zip"
   @ 06,02 WINSAY "Edit Memo Field?"

   RETURN(NIL)

FUNCTION gGets_034(cG_Func)
   LOCAL GetList := {}
   STATIC cMemChk1 := "N"

   @ 02,09 WINGET ACITY PICTURE "!xxxxxxxxxxxxxxxxxxxxxxxx" ;
      HELPKEY "CITY"
   CLEAR GETS

   @ 04,09 WINGET ASTATE PICTURE "!!" ;
      HELPKEY "STATE"
   @ 04,19 WINGET AZIP PICTURE "@R 99999-9999" ;
      HELPKEY "ZIP"
   @ 06,19 WINGET cMemChk1 MENU USING {" Yes "," No "} ;
      VALIDBLOCK {||ATEXT:=Edt_Memo(10,00,22,78,ATEXT,, ;
      " COMMENTS ",Var(WMSG_CLR_), ;
      Var(MSG_CLR_)),.T.} ;
      HELPKEY "TEXT"

   IF cG_Func$"AC"
      ReadGets(@GetList)
   ENDIF
   RETURN(NIL)

FUNCTION gEdit_034(cFilAction)
   // enter any additional field edits here and return false if an
   // error occured
   RETURN(.T.)

FUNCTION gKey_034(cGk_Func)        // A-Add, C-Change, D-Delete
   LOCAL gKey,x,GetList := {},gKey1

   @ 18,22,22,63 WINDOW STYLE "3+"
   SetMsgLin(" Enter Key Information  ESC-Exit ",TRUE)

   gKey1 := SPACE(25)

   @ 01,02 WINSAY "City"
   @ 01,07 WINGET gKey1 PICTURE "!xxxxxxxxxxxxxxxxxxxxxxxx" ;
      HELPKEY "CITY"

   IF cGk_Func != "A"
      @ WinBott()-2,WinLeft()+2 SAY "Enter Key Info or Blank for Current Rec"
   ELSE
      @ WinBott()-2,WinLeft()+2 SAY "Enter Key Info to Add or ESC to Exit"
   ENDIF

   ReadGets(@GetList)

   IF LASTKEY() != K_ESC
      IF !EMPTY(gKey1)
         ACITY := gKey1
      ENDIF
   ENDIF
   gKey := gKey1

   WINDOW REMOVE
   RETURN(gKey)

//͸
//  CALLED BY: Hand Code:  HAND142   Parm Pass mOpts                         
//    Comment: City File Maintenance                                         
//;
PROCEDURE Fmnt058(mOpts)
   LOCAL nFmr1,nFmc1,nFmr2,nFmc2

   VarPush("FMNT058")

   nFmr1 := 08
   nFmc1 := 02
   nFmr2 := nFmr1+08
   nFmc2 := nFmc1+36

   SETCOLOR(Var(WNDW_CLR_))
   Cities->(DBSETORDER(2))

   Cities->(Gen_Maint(nFmr1,nFmc1,nFmr2,nFmc2,"058",aCities,4,.F.,"ACDF"))

   VarPop()

FUNCTION gSays_058()
   SETCOLOR(Var(WNDW_CLR_))
   @ 02,03 WINSAY "City"
   @ 04,03 WINSAY "State"
   @ 04,15 WINSAY "Zip"
   @ 06,02 WINSAY "Edit Memo Field?"

   RETURN(NIL)

FUNCTION gGets_058(cG_Func)
   LOCAL GetList := {}
   STATIC cMemChk1 := "N"

   @ 02,09 WINGET ACITY PICTURE "!xxxxxxxxxxxxxxxxxxxxxxxx" ;
      HELPKEY "CITY"
   CLEAR GETS

   @ 04,09 WINGET ASTATE PICTURE "!!" ;
      HELPKEY "STATE"
   @ 04,19 WINGET AZIP PICTURE "@R 99999-9999" ;
      HELPKEY "ZIP"
   @ 06,19 WINGET cMemChk1 MENU USING {" Yes "," No "} ;
      VALIDBLOCK {||ATEXT:=Edt_Memo(10,00,22,78,ATEXT,, ;
      " COMMENTS ",Var(WMSG_CLR_), ;
      Var(MSG_CLR_)),.T.} ;
      HELPKEY "TEXT"

   IF cG_Func$"AC"
      ReadGets(@GetList)
   ENDIF
   RETURN(NIL)

FUNCTION gEdit_058(cFilAction)
   // enter any additional field edits here and return false if an
   // error occured
   RETURN(.T.)

FUNCTION gKey_058(cGk_Func)        // A-Add, C-Change, D-Delete
   LOCAL gKey,x,GetList := {},gKey1

   @ 13,-2,17,39 WINDOW STYLE "3+"
   SetMsgLin(" Enter Key Information  ESC-Exit ",TRUE)

   gKey1 := SPACE(25)

   @ 01,02 WINSAY "City"
   @ 01,07 WINGET gKey1 PICTURE "!xxxxxxxxxxxxxxxxxxxxxxxx" ;
      HELPKEY "CITY"

   IF cGk_Func != "A"
      @ WinBott()-2,WinLeft()+2 SAY "Enter Key Info or Blank for Current Rec"
   ELSE
      @ WinBott()-2,WinLeft()+2 SAY "Enter Key Info to Add or ESC to Exit"
   ENDIF

   ReadGets(@GetList)

   IF LASTKEY() != K_ESC
      IF !EMPTY(gKey1)
         ACITY := gKey1
      ENDIF
   ENDIF
   gKey := gKey1

   WINDOW REMOVE
   RETURN(gKey)

// ENDFMNT End of File Maintenance Calls 

//͸
//  Check Indexes, Called During Initialization                              
//;
PROCEDURE ChkNtxs()
   LOCAL cOldRdd := RDDSETDEFAULT(),cFileName

   EXTERNAL AbIbar

   BEGIN SEQUENCE
   SETCOLOR(Var(BRWS_CLR_))
   @ 09,17,14,62 WINDOW STYLE "3+"
   SetMsgLin(" Checking/Creating System Indexes  ESC to Abort ",TRUE)
   @ 02,03 WINSAY "Checking Indexes..."

   IF !FILE("HELP1.NTX")
      USE Help NEW EXCLUSIVE ALIAS Help VIA "DBFNTX"
      Message("HELP1.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

      INDEX ON Help->HProc+Help->Var ;
         TO    Help1 ;
         EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
         EVERY RECCOUNT()/100

      IF IBar() ; BREAK("Help1.ntx") ; ENDIF
      DBCLOSEAREA()
   ENDIF

   RDDSETDEFAULT(cOldRdd)
   IF !FILE("CITIES1.NTX") ;
         .OR. !FILE("CITIES2.NTX") ;
         .OR. !FILE("CITIES3.NTX") ;
         .OR. !FILE("CITIES4.NTX")
      USE Cities NEW EXCLUSIVE
      IF !FILE("CITIES1.NTX")
         Message("CITIES1.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

         INDEX ON Field->Zip ;
            TO    Cities1 ;
            EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
            EVERY RECCOUNT()/100

         IF IBar() ; BREAK("Cities1.NTX") ; ENDIF
      ENDIF
      IF !FILE("CITIES2.NTX")
         Message("CITIES2.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

         INDEX ON Field->City ;
            TO    Cities2 ;
            EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
            EVERY RECCOUNT()/100

         IF IBar() ; BREAK("Cities2.NTX") ; ENDIF
      ENDIF
      IF !FILE("CITIES3.NTX")
         Message("CITIES3.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

         INDEX ON Field->State ;
            TO    Cities3 ;
            EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
            EVERY RECCOUNT()/100

         IF IBar() ; BREAK("Cities3.NTX") ; ENDIF
      ENDIF
      IF !FILE("CITIES4.NTX")
         Message("CITIES4.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

         INDEX ON If(Dele(),"*"," ") ;
            TO    Cities4 ;
            EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
            EVERY RECCOUNT()/100

         IF IBar() ; BREAK("Cities4.NTX") ; ENDIF
      ENDIF
      DBCLOSEAREA()
   ENDIF

   RDDSETDEFAULT(cOldRdd)
   IF !FILE("FRIENDS1.NTX") ;
         .OR. !FILE("FRIENDS2.NTX")
      USE Friends NEW EXCLUSIVE
      IF !FILE("FRIENDS1.NTX")
         Message("FRIENDS1.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

         INDEX ON Field->City ;
            TO    Friends1 ;
            EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
            EVERY RECCOUNT()/100

         IF IBar() ; BREAK("Friends1.NTX") ; ENDIF
      ENDIF
      IF !FILE("FRIENDS2.NTX")
         Message("FRIENDS2.NTX Missing; Building-",WinTop()+02,WinLeft()+03,40)

         INDEX ON If(Dele(),"*"," ") ;
            TO    Friends2 ;
            EVAL  IBar(WinTop()+03,WinLeft()+03,"L",40,.T.) ;
            EVERY RECCOUNT()/100

         IF IBar() ; BREAK("Friends2.NTX") ; ENDIF
      ENDIF
      DBCLOSEAREA()
   ENDIF
   RDDSETDEFAULT(cOldRdd)

   RECOVER USING cFileName           // This executed on User Abort
      DBCLOSEALL()
      FERASE(cFileName)            // Erase Partially Built Index
      SETCOLOR("W/N")
      QUIT
   END SEQUENCE

   WINDOW REMOVE

//͸
//  Open All Application Data and Index Files                                 
//;
PROCEDURE OpenFiles()

   SETCOLOR(Var(BRWS_CLR_))
   @ 10,29,14,51 WINDOW STYLE "3+"
   @ 02,03 WINSAY "Opening Files..."
   SetMsgLin(" Opening Files, Please Wait ",TRUE)

   USE Help NEW EXCLUSIVE ALIAS Help VIA "DBFNTX" ;
       INDEX Help1

   USE Cities NEW EXCLUSIVE ALIAS Cities VIA "DBFNTX" ;
      INDEX Cities1,Cities2,Cities3,Cities4

   USE Friends NEW EXCLUSIVE ALIAS Friends VIA "DBFNTX" ;
      INDEX Friends1,Friends2

   WINDOW REMOVE
