/*
͸
                                                                            
  Aeolus Builder v2.3 System Constants                                      
       (c) Copyright 1995, All Rights Reserved                              
                                                                            
;
*/



#ifndef TRUE
  #define   TRUE     .T.
#endif
#ifndef FALSE
  #define   FALSE    .F.
#endif



/*
*  Window Style Manifest Constants
*
*/
#define      W_DOUBLE                     "=="
#define      W_SINGLE                     "--"
#define      W_DOUBLE_SINGLE              "=-"
#define      W_SINGLE_DOUBLE              "-="
#define      W_3D_PLUS                    "3+"
#define      W_3D_MINUS                   "3-"

/***
*  I/O Control Manifest Constants
*
*/
#define NETWORK             1       // Network logical
#define XPLODE              2       // Exploding windows logical

/***
*  Color Variable Array Element Numbers
*
*/
#define WREV_CLR_           3       // window reverse color (current GET)
#define WGET_CLR_           4       // window GET color
#define WMSG_CLR_           5       // window message color
#define WERR_CLR_           6       // window error message color
#define WNDW_CLR_           7       // window color

#define HDR_CLR_            8       // screen header color
#define HDR_MSG_            9       // message in screen header color

#define BREV_CLR_          10       // not used
#define BGET_CLR_          11       // not used
#define BKGD_CLR_          12       // not used
#define BMSG_CLR_          13       // not used
#define BERR_CLR_          14       // not used

#define WNDW2_CLR_         15       // not used
#define WMSG2_CLR_         16       // not used

#define SHDW_CLR_          17       // shadow color
#define ERR_CLR_           18       // error box color
#define MSG_CLR_           19       // message line color
#define HELP_CLR_          20       // help color

#define BRWS_CLR_          24       // TBrowse color
#define BRWS_REV_          25       // TBrowse pointer/GET color
#define BRWS_HL1_          26       // TBrowse highlight 1 color
#define BRWS_HR1_          27       // TBrowse highlight 1 pointer/GET color
#define BRWS_HL2_          28       // TBrowse highlight 2 color
#define BRWS_HR2_          29       // TBrowse highlight 2 pointer/GET color
#define MENU_CLR_          31       // menu color
#define MENU_REV_          32       // menu pointer color
#define HLGT_CLR_          33       // menu speed key color
#define MENU_OFF_          40       // menu pad unselecable color


// Internals--Used by Builder.Lib Functions
#define LRKEYS             21         // Left Right Menu Scrolling Logical
#define INGETSYS           22         // Get System Active Logical
#define WNDW_STYLE         23         // default window style for app
#define GETGOTO_           34         // get system mouse get# move
#define COLGOTO_           35         // get system mouse column move
#define MOUSE_DRIVER       36         // mouse driver being used logical
#define B_HELP_EDIT        37         // help editable from app logical
#define B_HELP_ON          38         // help system logical
#define B_HMAX_LINS        39         // maximum editable help lines
#define MOVEBLOCK_         41         // executed before a GET mouse move
#define MPADS             999         // Dummy to use the mPads Static Array



/*
͸
 Manifest constants used to set the <nAttribute> parameter for the          
 BIOSDisp() function                                                        
;
*/

#define     BD_BLINK               128
#define     BD_RED_BACKGROUND       64
#define     BD_GREEN_BACKGROUND     32
#define     BD_BLUE_BACKGROUND      16
#define     BD_HIGH_INTENSITY        8
#define     BD_RED_FOREGROUND        4
#define     BD_GREEN_FOREGROUND      2
#define     BD_BLUE_FOREGROUND       1



/*
͸
                                                                            
  Aeolus Builder User Defined Commands                                      
                                                                            
  @..GET.       Same as with Clipper with the addition of the VALIDBLOCK.   
                READER, and AS MENU clauses.                                
                                                                            
  @..ABPROMPT.  Similar to Clipper's @..PROMPT except this calls the        
                Aeolus Function Library 'AddPrompt()' function.             
                                                                            
  @..WINGET     Same as Builder @..GET except it will display use WinTop()  
                and WinLeft()                                               
                                                                            
  @..WINSAY     Same as Clipper @..SAY except it will display use WinTop()  
                and WinLeft()                                               
                                                                            
  @..WINPROMPT  Same as Builder @..ABPROMPT except it will display use      
                WinTop() and WinLeft()                                      
                                                                            
  @..WINDOW     Displays a window on the screen.                            
                                                                            
  WINDOW REMOVE Removes a window from the screen and restores screen  area  
                to its previous contents                                    
;
*/

#define     MENU_READER(Var,Row,Col,Array) ;
              {|oGet|AbMenu(CrteMnuArry(Row,Col,Array),Var,oGet,oGet==NIL)}

#define     ABMEMBLOCK( v )           {|x|IF(x==NIL,v,v:=x)}

#define     DROPDOWN(Var,Row,Col,Array) ;
              {|oGet|AbDrpDwn(Row,Col,Array,Var,oGet,oGet==NIL)}

#define     CHECKBOX(Row,Col,Var,Array) ;
              {|oGet|AbChkBox(Row,Col,Var,Array,oGet,oGet==NIL)}

#define     RADIOBUTTON(Row,Col,Var,Grp,Array) ;
              {|oGet|AbRadioBtn(Row,Col,Var,Grp,Array,oGet,oGet==NIL)}

#define     EXEC_READER(Var,Row,Col,Block) ;
              {|oGet|AbExecute(Row,Col,Var,{|x|Block},oGet,oGet==NIL)}

/***
*  @..GET  command for use with the Aeolus Builder
*/

#command @ <row>, <col> GET <var>                                       ;
                        [PICTURE <pic>]                                 ;
                        [VALID <valid>]                                 ;
                        [WHEN <when>]                                   ;
                        [VALIDBLOCK <validblk>]                         ;
                        [READER <readerblk>]                            ;
                        [SEND <msg>]                                    ;
                        [HELPKEY <htxt>]                                ;
                        [<spn: WITH SPINNER>]                           ;
                                                                        ;
      =>                                                                ;
         AbAddGet( <row>, <col>, ABMEMBLOCK( <var> ),                   ;
                   IF( <.htxt.>, <htxt>, <"var"> ),                     ;
                   <pic>, IF( <.validblk.>, <validblk>, <{valid}>),     ;
                   <{when}>, <readerblk>, GetList, <.spn.> )






// @..GET..EXECUTE (preprocessed to @..GET..READER)

#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        EXECUTE <function>                              ;
                        [<moreClauses,...>]                             ;
                                                                        ;
      => @ <row>, <col> GET <var>                                       ;
                        [<clauses>]                                     ;
                        READER EXEC_READER(<var>,<row>,<col>,<function>);
                        [<moreClauses>]





// @..GET..MENU USING (preprocessed to @..GET..READER)

#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        MENU USING <array>                              ;
                        [<moreClauses,...>]                             ;
                                                                        ;
      => @ <row>, <col> GET <var>                                       ;
                        [<clauses>]                                     ;
                        READER MENU_READER(<var>,<row>,<col>,<array>)   ;
                        [<moreClauses>]




// @..GET..DROPDOWN USING (preprocessed to @..GET..READER)

#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        DROPDOWN USING <array>                          ;
                        [<moreClauses,...>]                             ;
                                                                        ;
      => @ <row>, <col> GET <var>                                       ;
                        [<clauses>]                                     ;
                        READER DROPDOWN(<var>,<row>,<col>,<array>)      ;
                        [<moreClauses>]




// @..GET..CHECKBOX USING (preprocessed to @..GET..READER)

#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        CHECKBOX USING <array>                          ;
                        [<moreClauses,...>]                             ;
                                                                        ;
      => @ <row>, <col> GET <var>                                       ;
                        [<clauses>]                                     ;
                        READER CHECKBOX(<row>,<col>,<var>,<array>)      ;
                        [<moreClauses>]




// @..GET..RADIOBUTTON USING (preprocessed to @..GET..READER)

#command @ <row>, <col> GET <var>                                       ;
                        [<clauses,...>]                                 ;
                        RADIOBUTTON USING <array>                       ;
                        GROUP <grp>                                     ;
                        [<moreClauses,...>]                             ;
                                                                        ;
      => @ <row>, <col> GET <var>                                       ;
                        [<clauses>]                                     ;
                        READER                                          ;
                        RADIOBUTTON(<row>,<col>,<var>,<grp>,<array>)    ;
                        [<moreClauses>]




/***
*  @..ABPROMPT
*
*/

#command @ <row>, <col> ABPROMPT <text>                                 ;
                        TO <array>                                      ;
                       [EXECUTE <exec>]                                 ;
                       [WHEN <when>]                                    ;
                       [MESSAGE <msg>                                   ;
                        AT <mrow>, <mcol>]                              ;
         => AddPrompt( <array>, <row>, <col>, <text>, <{exec}>,         ;
               <mrow>, <mcol>, <msg>, <{when}> )                        ;



/***
*  @..WINGET
*
*  Adds WinTop() and WinLeft() to screen coordinates then calls the
*  regular Clipper GET
*
*/
#xcommand @ <row>, <col> WINGET <var>                                   ;
                        [<getclauses,...>]                              ;
                                                                        ;
      => @ WinTop()+<row>, WinLeft()+<col> GET <var>                    ;
                        [<getclauses>]                                  ;



/***
*  @..WINSAY
*
*  Adds WinTop() and WinLeft() to screen coordinates then calls the
*  regular Clipper SAY
*
*/
#xcommand @ <row>, <col> WINSAY <xpr>                                   ;
                        [<sayclauses,...>]                              ;
                                                                        ;
      => @ WinTop()+<row>, WinLeft()+<col> SAY <xpr>                    ;
                        [<sayclauses>]                                  ;



/***
*  @..WINPROMPT
*
*/

#command @ <row>, <col> WINROMPT [<promptclauses,...>]                  ;
                                                                        ;
         => @ WinTop()+<row>, WinLeft()+<col> ABPROMPT                  ;
                       [<promptclauses>]                                ;



/***
*  @..WINDOW
*/
#xcommand @ <top>, <left>, <bottom>, <right> WINDOW                     ;
                               [<nsv: NOSAVE>]                          ;
                               [<ncl: NOCLEAR>]                         ;
                               [<nsh: NOSHADOW>]                        ;
                               [<nbr: NOBORDER>]                        ;
                               [STYLE <wintype>]                        ;
                               [COLOR <color>]                          ;
                                                                        ;
      => WinPush(                                                       ;
                  <top>, <left>, <bottom>, <right>, !<.nsv.>,           ;
                  !<.ncl.>, !<.nbr.>, !<.nsh.>, <wintype>, <color> )


/***
*  WINDOW REMOVE
*/
#xcommand WINDOW REMOVE        => WinPop()



/***
*  @..WINPROMPT
*/
#xcommand @ <row>, <col> WINPROMPT                                      ;
                         [<promptclauses,...>]                          ;
                                                                        ;
      => @ WinTop()+<row>, WinLeft()+<col> ABPROMPT                     ;
                         [<promptclauses>]

/*
͸
                                                                            
        The following #xtranslate directives convert Builder.lib            
        function calls from their generic names to the names as             
        they appear in the Builder.lib library.  All the Builder            
        functions in the Builder.lib library are prefixed with              
        the letters 'Ab'.  This does two things, one makes the              
        function names unique, two makes the function names                 
        unreadable.                                                         
                                                                            
        The source code generated by the Builder.exe code gen-              
        erator will create function calls that DO NOT have the              
        'Ab' prefix characters.  The xtranslate directives here             
        will convert them (check your .ppo) to their actual                 
        names.                                                              
                                                                            
        See the file LIBC5X.DOC for information functions names.            
                                                                            
;
*/

// Builder.lib functions
#xtranslate Add_Rec([<args,...>])         => AbAdd_Rec([<args>])
#xtranslate AddGet([<args,...>])          => AbAddGet([<args>])
#xtranslate AddMPad([<args,...>])         => AbAddMPad([<args>])
#xtranslate AddPrompt([<args,...>])       => AbAddPrompt([<args>])
#xtranslate APop([<args,...>])            => AbAPop([<args>])
#xtranslate Asc2Bin([<args,...>])         => AbAsc2Bin([<args>])
#xtranslate Ask([<args,...>])             => AbAsk([<args>])
#xtranslate AskMenu([<args,...>])         => AbAskMenu([<args>])
#xtranslate BChoice([<args,...>])         => AbBChoice([<args>])
#xtranslate Between([<args,...>])         => AbBetween([<args>])
#xtranslate BldrErr([<args,...>])         => AbBldrErr([<args>])
#xtranslate BrowseDb([<args,...>])        => AbBrowseDb([<args>])
#xtranslate Browser([<args,...>])         => AbBrowser([<args>])
#xtranslate BrwMouse([<args,...>])        => AbBrwMouse([<args>])
#xtranslate ButtonPress([<args,...>])     => AbButtonPress([<args>])
#xtranslate Calendar([<args,...>])        => AbCalendar([<args>])
#xtranslate CalInit([<args,...>])         => AbCalInit([<args>])
#xtranslate CalReset([<args,...>])        => AbCalReset([<args>])
#xtranslate CalcInit([<args,...>])        => AbCalcInit([<args>])
#xtranslate CalcReset([<args,...>])       => AbCalcReset([<args>])
#xtranslate CasDel([<args,...>])          => AbCasDel([<args>])
#xtranslate Center([<args,...>])          => AbCenter([<args>])
#xtranslate ChkChr([<args,...>])          => AbChkChr([<args>])
#xtranslate CkPrtr([<args,...>])          => AbCkPrtr([<args>])
#xtranslate CrteMnuArry([<args,...>])     => AbCrteMnuArry([<args>])
#xtranslate DbChanged([<args,...>])       => AbDbChanged([<args>])
#xtranslate DbRepl([<args,...>])          => AbDbRepl([<args>])
#xtranslate DbState([<args,...>])         => AbDbState([<args>])
#xtranslate DbStor([<args,...>])          => AbDbStor([<args>])
#xtranslate Dec2Hex([<args,...>])         => AbDec2Hex([<args>])
#xtranslate DelColPut([<args,...>])       => AbDelColPut([<args>])
#xtranslate DelMPad([<args,...>])         => AbDelMPad([<args>])
#xtranslate DictPut([<args,...>])         => AbDictPut([<args>])
#xtranslate DictGet([<args,...>])         => AbDictGet([<args>])
#xtranslate DupChk([<args,...>])          => AbDupChk([<args>])
#xtranslate Edt_Memo([<args,...>])        => AbEdt_Memo([<args>])
#xtranslate ErrTone([<args,...>])         => AbErrTone([<args>])
#xtranslate Etc([<args,...>])             => AbEtc([<args>])
#xtranslate FEof([<args,...>])            => AbFEof([<args>])
#xtranslate FGets([<args,...>])           => AbFGets([<args>])
#xtranslate FGetsR([<args,...>])          => AbFGetsR([<args>])
#xtranslate Fil_Lock([<args,...>])        => AbFil_Lock([<args>])
#xtranslate FileView([<args,...>])        => AbFileView([<args>])
#xtranslate Fld_Repl([<args,...>])        => AbFld_Repl([<args>])
#xtranslate Gen_Maint([<args,...>])       => AbGen_Maint([<args>])
#xtranslate GenVld([<args,...>])          => AbGenVld([<args>])
#xtranslate GetEdit([<args,...>])         => AbGetEdit([<args>])
#xtranslate GetJump([<args,...>])         => AbGetJump([<args>])
#xtranslate Got([<args,...>])             => AbGot([<args>])
#xtranslate Hex2Dec([<args,...>])         => AbHex2Dec([<args>])
#xtranslate Ibar([<args,...>])            => AbIbar([<args>])
#xtranslate In_Canada([<args,...>])       => AbIn_Canada([<args>])
#xtranslate In_USA([<args,...>])          => AbIn_USA([<args>])
#xtranslate IncColor([<args,...>])        => AbIncColor([<args>])
#xtranslate InFile([<args,...>])          => AbInFile([<args>])
#xtranslate InPath([<args,...>])          => AbInPath([<args>])
#xtranslate ISeek([<args,...>])           => AbISeek([<args>])
#xtranslate Kybd([<args,...>])            => AbKybd([<args>])
#xtranslate MainColors([<args,...>])      => AbMainColors([<args>])
#xtranslate Make_Empty([<args,...>])      => AbMake_Empty([<args>])
#xtranslate MaxHndls([<args,...>])        => AbMaxHndls([<args>])
#xtranslate MemFunc([<args,...>])         => AbMemFunc([<args>])
#xtranslate Menu([<args,...>])            => AbMenu([<args>])
#xtranslate Message([<args,...>])         => AbMessage([<args>])
#xtranslate MGetRowCol([<args,...>])      => AbMgetRowCol([<args>])
#xtranslate MMaxCol([<args,...>])         => AbMMaxCol([<args>])
#xtranslate MMaxRow([<args,...>])         => AbMMaxRow([<args>])
#xtranslate MousCrs([<args,...>])         => AbMousCrs([<args>])
#xtranslate MousedGet([<args,...>])       => AbMousedGet([<args>])
#xtranslate MouseInit([<args,...>])       => AbMouseInit([<args>])
#xtranslate MReset([<args,...>])          => AbMReset([<args>])
#xtranslate MSetRowCol([<args,...>])      => AbMSetRowCol([<args>])
#xtranslate MsgBox([<args,...>])          => AbMsgBox([<args>])
#xtranslate MStart([<args,...>])          => AbMStart([<args>])
#xtranslate Net_Use([<args,...>])         => AbNet_Use([<args>])
#xtranslate NextExt([<args,...>])         => AbNextExt([<args>])
#xtranslate Not_Req([<args,...>])         => AbNot_Req([<args>])
#xtranslate Numeric([<args,...>])         => AbNumeric([<args>])
#xtranslate Open_Fil([<args,...>])        => AbOpen_Fil([<args>])
#xtranslate PckVld([<args,...>])          => AbPckVld([<args>])
#xtranslate Pdisp([<args,...>])           => AbPdisp([<args>])
#xtranslate Plist([<args,...>])           => AbPlist([<args>])
#xtranslate PopCalc([<args,...>])         => AbPopCalc([<args>])
#xtranslate Publ_Colo([<args,...>])       => AbPubl_Colo([<args>])
#xtranslate Putkey([<args,...>])          => AbPutkey([<args>])
#xtranslate ReadGets([<args,...>])        => AbReadGets([<args>])
#xtranslate Rec_Lock([<args,...>])        => AbRec_Lock([<args>])
#xtranslate Rel_Maint([<args,...>])       => AbRel_Maint([<args>])
#xtranslate Req([<args,...>])             => AbReq([<args>])
#xtranslate Rght_Jst([<args,...>])        => AbRght_Jst([<args>])
#xtranslate Save_It([<args,...>])         => AbSave_It([<args>])
#xtranslate SetColors([<args,...>])       => AbSetColors([<args>])
#xtranslate SetMsgLin([<args,...>])       => AbSetMsgLin([<args>])
#xtranslate SetWaitBlock([<args,...>])    => AbSetWaitBlock([<args>])
#xtranslate Shadow([<args,...>])          => AbShadow([<args>])
#xtranslate Show_Memo([<args,...>])       => AbShow_Memo([<args>])
#xtranslate Show_Txt([<args,...>])        => AbShow_Txt([<args>])
#xtranslate TbrowseColors([<args,...>])   => AbTbrowseColors([<args>])
#xtranslate TextView([<args,...>])        => AbTextView([<args>])
#xtranslate Thermometr([<args,...>])      => AbThermometr([<args>])
#xtranslate TtlKeyOff([<args,...>])       => AbTtlKeyOff([<args>])
#xtranslate TtlKeyOn([<args,...>])        => AbTtlKeyOn([<args>])
#xtranslate Var([<args,...>])             => AbVar([<args>])
#xtranslate VarInit([<args,...>])         => AbVarInit([<args>])
#xtranslate VarPop([<args,...>])          => AbVarPop([<args>])
#xtranslate VarPush([<args,...>])         => AbVarPush([<args>])
#xtranslate Waitkey([<args,...>])         => AbWaitkey([<args>])
#xtranslate WinBott([<args,...>])         => AbWinBott([<args>])
#xtranslate WinLeft([<args,...>])         => AbWinLeft([<args>])
#xtranslate WinPop([<args,...>])          => AbWinPop([<args>])
#xtranslate WinRight([<args,...>])        => AbWinRight([<args>])
#xtranslate WinStyle([<args,...>])        => AbWinStyle([<args>])
#xtranslate WinTop([<args,...>])          => AbWinTop([<args>])
#xtranslate WinPush([<args,...>])         => AbWinPush([<args>])
#xtranslate Zap_Ibar([<args,...>])        => AbZap_Ibar([<args>])
#xtranslate ZapMPads([<args,...>])        => AbZapMPads([<args>])

// BldrAsm.lib functions
#xtranslate BiosDisp([<args,...>])        => AbBiosDisp([<args>])
#xtranslate ChgDir([<args,...>])          => AbChgDir([<args>])
#xtranslate ChgDsk([<args,...>])          => AbChgDsk([<args>])
#xtranslate DrvTst([<args,...>])          => AbDrvTst([<args>])
#xtranslate Hndls([<args,...>])           => AbHndls([<args>])
#xtranslate IoCtl([<args,...>])           => AbIoCtl([<args>])
#xtranslate MakDir([<args,...>])          => AbMakDir([<args>])
#xtranslate MouseInt([<args,...>])        => AbMouseInt([<args>])
#xtranslate SetCaps([<args,...>])         => AbSetCaps([<args>])
#xtranslate SetNum([<args,...>])          => AbSetNum([<args>])
#xtranslate SetScroll([<args,...>])       => AbSetScroll([<args>])
#xtranslate ShftSt([<args,...>])          => AbShftSt([<args>])
#xtranslate Timeout([<args,...>])         => AbTimeout([<args>])



#stdout Aeolus Builder Application Generator is Copyright (c) 1994

// end of file Builder.ch
