/* ͻ
                                                                        
      READDBG.C                                                         
                                                                        
      Debug information file reader.                                    
                                                                        
      Copyright 1995, Frank A. Vorstenbosch                             
                                                                        
   ͼ

   File created 22-nov-94   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* Ŀ
                                                                        
      Variables.                                                        
                                                                        
    */

#define HEADERSIZE 256

static unsigned char Header[HEADERSIZE];


/*  Calculate checksum on header  */

static unsigned CheckSum(int n)
{  int i;
   unsigned c;

   for(i=c=0;i<n-2;i++)
      c=((c<<1)|!!(c&0x8000))+(unsigned char)Header[i];

   return c;
}


/* Ŀ
                                                                        
      Open a standardized binary file.                                  
                                                                        
    */

FILE *OpenBinary(char *fileName,char *fileDescr,
                 int minVersion,int maxVersion,int *version,int *flags)
{  int i,c,n;
   FILE *inFile;
   unsigned char *p;

   if((inFile=fopen(fileName,"rb"))==NULL)
   {  *version=-1;
      return NULL; }

   *version=-2;

   if((i=fread(Header,1,HEADERSIZE,inFile))<30)
   {
error:
      fclose(inFile);
      return NULL;
   }

   n=(Header[4]-'0')<<6|(Header[5]-'0');
   if(i<n)
      goto error;

   c=CheckSum(n);

   if(Header[n-2]!=(c>>8) || Header[n-1]!=(c&255))
      goto error;

   if(flags)
      *flags=Header[n-4]<<8|Header[n-3];

   if(memcmp(Header,"INFO",4) || memcmp(Header+6,"\b\b\b\b\b\b",6) ||
      memcmp(Header+12,fileDescr,i=strlen(fileDescr)))
      goto error;

   p=Header+12+i;

   if(*p!=' ' || p[1]!='[' || p[3]!='.' || p[6]!=']' ||
      p[7]!='\r' || p[8]!='\n')
      goto error;

   i=(p[2]-'0')*100+(p[4]-'0')*10+(p[5]-'0');

   if(i<0 || i>999)
      goto error;

   *version=i;

   if(i<minVersion || i>maxVersion)
      goto error;

   fseek(inFile,n,SEEK_SET);

   return inFile;
}


/* Ŀ
                                                                        
      Read various quantities.                                          
                                                                        
    */

int getShort(FILE *inFile)
{  int i;

   i=getc(inFile)<<8;
   return i|getc(inFile)&0xff;
}

long getLong(FILE *inFile)
{  long i;

   i=getShort(inFile)<<16L;
   return i|getShort(inFile)&0xffffL;
}

int getString(FILE *inFile,char *Buffer)
{  int i=getc(inFile)&0xff;

   fread(Buffer,1,i,inFile);
   Buffer[i]=0;
 
   return i;  
}


/* Ŀ
                                                                        
      Main routine.                                                     
                                                                        
    */

static char *Types[]=
{
   "    0",
   " Byte",
   " Word",
   " Data",
   " Long",
   "Instr",
   "?????"
};

static char *Segs[]=
{
   "   Code",
   "   Data",
   "    BSS",
   "    Reg",
   " Struct",
   "  Const",
   "???????",
   "???????"
};

char *Sources[128]={0};

int main(int argc,char *argv[])
{  FILE *inFile;
   int i,n,f,j;
   long a;
   char s[256];

   if(argc!=2)
   {  printf("Usage: READDBG <file>\n");
      return 1; }

   if((inFile=OpenBinary(argv[1],"This is a Kingswood source-level debug information file",
                         50,50,&n,&i))==NULL)
   {
      switch(n)
      {  case -1:
            printf("File %s not found.\n",argv[1]);
            break;
         case -2:
            printf("File %s has an incorrect format for a debug information file.\n",argv[1]);
            break;
         default:
            printf("File %s is an unknown version [%d.%02d].\n",argv[1],n/100,n%100);
            break;
      }
      return 2;
   }

   a=getLong(inFile);
   printf("CPU ID=%08lx: %c%ld",a,(char)(a>>24L),(a>>4L)&0xfffffL);
   if(a&15)
      printf(" rev. %d",(int)a&15);

   printf("\n\nSource files:\n");
   i=0;

   while(getString(inFile,s))
   {  Sources[i++]=strdup(s);
      printf("   %s\n",s); }

   printf("\nGlobal variables:\n   Value     Segment  Size   Name\n   ========  =======  =====  ================================\n");
   while(getString(inFile,s))
   {
      i=getc(inFile)&0xff;
      if(i&0x80)
         a=getLong(inFile);
      else
         a=getShort(inFile)&0xffffL;

      j=i&15;
      i=(i>>4)&7;
      if(j>5)
         j=5;

      printf("   %08lx  %7s  %s  %s\n",a,Segs[i],Types[j],s);
   }

   printf("\nLine numbers:\n   Address  File,Line\n   =======  =========\n");
   while((i=getc(inFile))!=EOF && i!=0)
   {
      i&=0xff;
      if(i&0x80)
      {  f=i&0x7f;
         n=getShort(inFile);
         j=getShort(inFile);
      }
      else
      {  
         n+=i;
         j+=getc(inFile)&0xff;
      }

      printf("   %04x     \"%s\",%u\n",j,Sources[f],n);
   }

   return 0;
}


/*  EOF  */

