#include <stdio.h>		// include file for files and I/O operations
#include <math.h>		// include file for math functions
#include <stdlib.h>		// include file for rand() fuction

void main ()
{
	FILE *stream;
	char c;
	int i,nsamp;
	float x,y1,y2;
	float w,dx;
	w=6.283185;
	nsamp=400;
	x=-2*w;
	dx=(5*w)/nsamp;
	y2=0;
	stream=fopen("data_bin.dat","wb");   // open the file in write binary mode
	fprintf(stream,"Comment= This is a example of a large binary file\r\n",c);
	fprintf(stream,"SYMB_POINT=none,triangle\r\n",c);
	fprintf(stream,"PLOT_TYPE=rectang,legend\r\n",c);
	fprintf(stream,"FILE_TYPE=binary\r\n",c);
	fprintf(stream,"NUM_SAMPS= %d\r\n",nsamp);
	fprintf(stream,"NUM_SIGS=2\r\n",c);	// there only one Y-axis signal	
	fprintf(stream,"SIGNALS= sinc(x)+int(noise),sum(y1)\r\n",c);
	fprintf(stream,"INTERVAL= %f,%f\r\n",dx,x);
	fprintf(stream,"DATA\r\n",c);
	for (i=0;i<nsamp;i++)
		{
		x=x+dx;
		y1=sin(x)/x + rand()/16384-.5;      // sinc(x) + int(noise)
		y2=y2+y1/nsamp*10;
		fwrite((void*)&y1,4,1,stream);	 	// output 1 memory content of y1 (4 bytes)
		fwrite((void*)&y2,4,1,stream);
		}
	fclose (stream);
}