/*
 *  TWOTHIRDS.C -- Tim Coe
 *  I call this divider model twothirds.c because
 *  it only continues dividing as long as the quotient
 *  so far calculated is 2/3.  When the model detects
 *  that the quotient is deviating from 2/3 it checks
 *  for the error condition, reports its conclusions,
 *  and then exits.  This is one brain dead divider,
 *  but it will predict Pentium divide errors.  Here
 *  are some hex numbers to run through it:
 *
 *  ---  Nicely's Prime  ---
 *  8 bfffffb829  decimal=824633702441
 *  800bf6 bffffc
 *  8 bffffb82200-bffffb831f3
 *  80000035f8 bfffee5dc
 */
#include <stdio.h>

main()
{
unsigned r0, r1, r2, r3, r4, r5, r6;
unsigned t0, t1, t2, t3, cycle, f, first, notlastminus1;
char line[30], *linepoint;

r0 = 0x0bffffc0;
r1 = 0;
r2 = 0x0800bf60;
r3 = 0;
printf("Enter mantissas with first digit between 8 and f.\n");
printf("Enter dividend mantissa in hex: ");
scanf("%s", line);
linepoint = line;
while (*linepoint != '\0') linepoint++;
while (linepoint < line + 15) *linepoint++ = '0';
*(line+15) = '\0';
sscanf(line+7, "%x", &r3);
*(line+7) = '\0';
sscanf(line, "%x", &r2);
printf("Enter divisor  mantissa in hex: ");
scanf("%s", line);
linepoint = line;
while (*linepoint != '\0') linepoint++;
while (linepoint < line + 15) *linepoint++ = '0';
*(line+15) = '\0';
sscanf(line+7, "%x", &r1);
*(line+7) = '\0';
sscanf(line, "%x", &r0);
r4 = 0;
r5 = 0;
cycle = 1;
first = 1;
notlastminus1 = 1;
while (notlastminus1) {
  if (first) {
    t0 = r2 ^ ~r0;
    t1 = r3 ^ ~r1;
    t2 = r2 & ~r0;
    t3 = r3 & ~r1;
    r2 = (t0 << 2) | (t1 >> 30);
    r3 = t1 << 2;
    r4 = (t2 << 3) | (t3 >> 29);
    r5 = (t3 << 3) | 4;
    first = 0;
    }
  else {
    t0 = r0 ^ r2 ^ r4;
    t1 = r1 ^ r3 ^ r5;
    t2 = (r0 & r2) | (r0 & r4) | (r2 & r4);
    t3 = (r1 & r3) | (r1 & r5) | (r3 & r5);
    r2 = (t0 << 2) | (t1 >> 30);
    r3 = t1 << 2;
    r4 = (t2 << 3) | (t3 >> 29);
    r5 = t3 << 3;
    }

  t0 = r2;
  f = 32;
  while (f--) {
    if (t0 & (1 << 31)) putchar('1');
    else putchar('0');
    t0 = t0 << 1;
    }
  t0 = r3;
  f = 32;
  while (f--) {
    if (t0 & (1 << 31)) putchar('1');
    else putchar('0');
    t0 = t0 << 1;
    }
  putchar('\n');
  t0 = r4;
  f = 32;
  while (f--) {
    if (t0 & (1 << 31)) putchar('1');
    else putchar('0');
    t0 = t0 << 1;
    }
  t0 = r5;
  f = 32;
  while (f--) {
    if (t0 & (1 << 31)) putchar('1');
    else putchar('0');
    t0 = t0 << 1;
    }
  putchar('\n');
  t0 = r2 + r4;
  f = 32;
  while (f--) {
    if (t0 & (1 << 31)) putchar('1');
    else putchar('0');
    t0 = t0 << 1;
    }
  printf(" iteration number %d\n", cycle++);
  putchar('\n');

/*  Numbers on one edge of the failure range  */
/*  fall out of the failure range due to the  */
/*  selection of 0 as next digit the cycle    */
/*  before the prospective failure.           */
  t0 = 255 & ((r2 >> 24) + (r4 >> 24));
  if ((t0 < 239) || (t0 > 250)) notlastminus1 = 0;

  }
/*  Numbers on the other edge of the failure  */
/*  range fall out of the failure range due   */
/*  to a lack of ones in both the sum and     */
/*  carry word on bit 11 in my bit numbering  */
if ((t0 == 30) && (((r2 >> 21) & 7) == 7) && (((r4 >> 21) & 7) == 7)) {
  printf("error on iteration number %d\n", cycle);
  printf("error in the amount of one part in 2^%d\n", 2*(cycle-1));
  }
else printf("end and most likely no error\n");
}

