// Socket
// socket.hpp 
//
// access to WinSockets
// 
//

#ifndef SOCKET_HPP
#define SOCKET_HPP

#include "winsock.h"

_CLASSDEF (string)

class _OWLCLASS TSocketCatch
{
public:
  virtual void WinSocketError(int nError, const char* pErrText){};
};

class _OWLCLASS TPOPSocketCatch : public TSocketCatch
{
public:
  virtual void MessageRetrieved(int nID, const char* pFilename){};
  virtual void MessageCount(int nCount){};
};

class _OWLCLASS TAsyncSocket : public TWindow
{
public:
	TAsyncSocket(TWindow* pParent,TSocketCatch* pCatcher);
	~TAsyncSocket();
	int Connect(const char* pHost, int nPort, int nProtocol);
	int Disconnect();
	int SyncSend(const char far* pData, int nLen);
	int SyncRecv(char far* pData, int nMaxLen);
	int SyncSendLine(const char* pData);
	int LastError();
protected:
	void EvTimer(uint uTimerId);
  void SetupWindow();
  void CleanupWindow();
  int AsyncGetHostByName(const char* pServerName);
  virtual LRESULT SmHostName(WPARAM,LPARAM);
  virtual LRESULT SmDataReady(WPARAM,LPARAM){return TRUE;};

  // data members
  char* pWorkBuffer;        // work buffer
  HANDLE hAsync;            // handle used for async Winsocket calls
  TSocketCatch* pCatcher;   // ptr to our info catcher
	BOOL bValid;              // true if socket is initialized
	BOOL bConnected;          // true if socket are connected
	static BOOL bBlocking;    // true if socket is blocking
	WSADATA wsaData;          // Winsocket data
	HINSTANCE hSockInstance;  // HINSTANCE for socket
	SOCKET sock;              // socket identifier
	hostent* pHost;           // ptr to host entry
	protoent* pProto;         // ptr to proto entry
	struct hostent Host;      // instance of hostent
	struct protoent Proto;    // instance of protoent
	struct sockaddr_in inetAddr; // instance of sockeaddr_in strucutre
	struct sockaddr sa;       // instance of sockaddr structure

	DECLARE_RESPONSE_TABLE(TAsyncSocket);
};

class _OWLCLASS TAsyncPOPSocket : public TAsyncSocket
{
public:
  enum {NONE,RETRIEVE,SEND};
  TAsyncPOPSocket(TWindow* pParent = NULL, TPOPSocketCatch* pC = 0);
  ~TAsyncPOPSocket();
  Connect(const char* pHost);
	int Disconnect();
	int RetrieveMail(const char* pHost, const char* pUser, const char* pPassword);
	int Quit();
protected:
	int RetrieveMessages();
  int GetMessageCount();
	long MessageTotal();
  void RetrieveNext();
	int Authorize(const char* pName, const char* pPassword);
	int MailResponse();
  virtual LRESULT SmHostName(WPARAM,LPARAM);
  virtual LRESULT SmDataReady(WPARAM,LPARAM);
  LRESULT SmPopConnect(WPARAM,LPARAM);
  LRESULT SmPopAuthorize(WPARAM,LPARAM);
  LRESULT SmPopPassword(WPARAM,LPARAM);
  LRESULT SmPopMessageCount(WPARAM,LPARAM);
  LRESULT SmPopGetMessage(WPARAM,LPARAM);
  LRESULT SmPopStartMessage(WPARAM,LPARAM);
	// data members
  string sServer;                 // used to store server name
  string sUser;                   // "" user name
  string sPassword;               // "" password
  string sTempName;               // used as filename holder
  TPOPSocketCatch* pMyCatcher;    // ptr to our info catcher
	bool bAuthorized;               // have we been authorized

	string* pWorkString;            // crutch for easy string stuff
  long lMessageTotal;             // message totals
  long lMessageCount;             // number of messages 
  int nMessagesPending;           // number of messages pending
  char* pCurrentMessage;          // ptr to current message text
  ofstream out;                   // used as temp file for storage

	DECLARE_RESPONSE_TABLE(TAsyncPOPSocket);
};


#endif




