
/*************************************************************************
**************************************************************************

   Listing 5, SUBST.CPP
   Copyright David Perelman-Hall & Jamshsid Afshar 1994.
   SubstitutionList class implementation.
   Class defines methods for tracking instantiations of variables
   during unification.

**************************************************************************
*************************************************************************/


#include "misc.h"
#pragma hdrstop

// OUTPUT TO OSTREAM
ostream& operator<<(ostream& os, const SubstitutionList& subst)
{
   os << "Table: " << (const MapOf<Variable, ValuePtr>&)subst << endl;
   os << "Var Equalities: " << subst._var_eqs << endl;
   return os;
}
   

// PLACE A VARIABLE AND ITS VALUE IN THE SUBSTITUTION LIST
bool SubstitutionList::set(const Variable& variable, const ValuePtr& valueptr)
{
   assert(variable != "");
   if (contains(variable))
      return valueptr==val(variable);
   enter(variable, valueptr);
   return TRUE;
}

// MAKE TWO VARIABLES THE SAME 
bool SubstitutionList::set_identical(const Variable& var1, const Variable& var2)
{
   assert(var1 != "" && var2 != "");

   // CAN'T MAKE TWO VARIABLES EQUAL WHICH ALREADY ARE SET TO DIFFERING VALUES
   if (contains(var1) && contains(var2) && val(var1) != val(var2)) {
      return FALSE;
   }

   // BUILD UP A NEW VARIABLE SET WHICH WILL CONTAIN BOTH VARIABLES
   VariableSet newset; 
   newset += var1; 
   newset += var2;
   ListOfIter<VariableSet> set(&_var_eqs);
   while (!set.offEnd()) {
      // IF CURRENT SET OF VARIABLE EQUALITIES ALREADY CONTAINS BOTH
      // VAR1 AND VAR2, RETURN TRUE
      if (set().contains(var1) && set().contains(var2))
         return TRUE;
      // IF VAR1 OR VAR2 IS ALREADY IN CURRENT SET, ADD THAT SET TO
      // NEWLY-BUILT VARIABLE SET
      else if (set().contains(var1) || set().contains(var2)) {
         newset += set();
         _var_eqs.remove(set); // REMOVE CURRENT SET
      } else
         set.next();
   }
   _var_eqs += newset; // ADD NEWLY-BUILT SET
   return TRUE;
}


// CHECK IF A VARIABLE IS CONTAINED IN THE SUBSTITUTION LIST
bool SubstitutionList::contains(const Variable& var) const
{
   assert(var != "");
   // SEE IF VARIABLE HAS HAD A VALUE SUBSTITUTED
   if (MapOf<String, ValuePtr>::contains(var)) return TRUE;

   // SEE IF AN IDENTICAL VARIABLE HAS HAD A VALUE SUBSTITUTED
   for (ListOfIter<VariableSet> set(&_var_eqs); !set.offEnd(); set.next())
      if (set().contains(var)) {
         VariableSet s = set() - var;
         SetOfIter<Variable> v(&s);
         for (; !v.offEnd(); ++v)
            if (MapOf<String, ValuePtr>::contains(v())) return TRUE;
         }
   return FALSE;
}


// RETURN THE VALUE WHICH VARIABLE WILL INSTANTIATE TO 
ValuePtr SubstitutionList::val(const Variable& var) const
{
   assert(var != "");

   // SEE IF VARIABLE HAS HAD A VALUE SUBSTITUTED
   if (MapOf<String, ValuePtr>::contains(var)) return valueOf(var);

   // SEE IF AN IDENTICAL VARIABLE HAS HAD A VALUE SUBSTITUTED
   for (ListOfIter<VariableSet> set(&_var_eqs); !set.offEnd(); set.next()) {
      if (set().contains(var)) {

         // GET SET MINUS THE VARIABLE SINCE ANOTHER VARIABLE MUST
         // INDICATE THE SUBSTITUTED VALUE
         VariableSet s = set() - var;
         SetOfIter<Variable> v(&s);

         // ITERATE THROUGH THIS REDUCED SET TO GET THE VALUE ASSOCIATED 
         // WITH THE VARIABLE
         for (; !v.offEnd(); ++v)
            if (MapOf<String, ValuePtr>::contains(v())) // EQUALS MAP<VARIABLE,VALUE>
               return valueOf(v());
      }
   }
   assert(!"val() called for unsubstituted variable");
   return ValuePtr();
}


// RETURN SET OF VARIABLES MINUS PASSED-IN VARIABLE WHICH WILL ACQUIRE SAME 
// VALUE  AS PASSED-IN VARIABLE
VariableSet SubstitutionList::same(const /*Variable*/String& var) const
{
   assert(var != "");
   for (ListOfIter<VariableSet> set(&_var_eqs); !set.offEnd(); set.next()) {
      if (set().contains(var)) {
         return set() - var;
      }
   }
   return VariableSet();   // no other variables identical
}
