
#ifndef TEMPLATE_LIST_H
#define TEMPLATE_LIST_H

#include <assert.h>
#include <iostream.h>

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//     LIST TEMPLATE
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
template <class T> class ListOfIter;
template <class T> class ListOf {
   friend class ListOfIter<T>;
   friend ostream& operator << (ostream&, const ListOf<T>&);
   public:
      ListOf(): size_(0), idx(0), arr(0) {}
      ListOf(const ListOf<T>& list);
		virtual ~ListOf() {
			delete [] arr;
		}
      T first() const { return arr[0]; }
      T last() const { return arr[idx-1]; }
      void dropLast() { if( idx > 0 ) idx--; }
      T elem(int index) const { assert(index>=0 && index<idx); return arr[index]; }
      void operator=(const ListOf<T>& list);
      virtual ListOf<T>&  Add(const T& item);
      ListOf<T>& operator+=(const T& item) { return Add(item); }
      ListOf<T>& operator+=(const ListOf<T>& list);
		int size() const { return idx; }
		int empty() const { return idx==0; }
      int contains(const T& item);
      virtual void clear() {
         delete [] arr;
         arr = 0;
         size_ = idx = 0;
      }
      void remove(ListOfIter<T>&);
	protected:
		T* arr;
		unsigned size_, idx;
};

template <class T>
void ListOf<T>::remove( ListOfIter<T>& iter )
{
   assert(iter.position>=0 && iter.position<size_);   
   for(int i=iter.position; i<size_-1; i++) arr[i] = arr[i+1];
   size_--;
}


template<class T>
ostream& operator << (ostream& os, const ListOf<T>& list)
{
   for(int i=0; i<list.idx; ++i) os << list.arr[i] << endl;   
   return os;
}

template<class T>
int ListOf<T>::contains(const T& item)
{
   for(int i=0; i<idx; i++) if(arr[i] == item) return 1;
   return 0;
}

template<class T>
ListOf<T>::ListOf(const ListOf<T>& list) : size_(list.size_),
idx(list.idx)
{
	arr = new T [size_];
	assert( arr != 0 );
	for(int i=0; i<idx; i++) arr[i] = list.arr[i];
}

template<class T>
void ListOf<T>::operator=(const ListOf<T>& list)
{
	if(&list == this) return;
	idx=list.idx;
	size_=list.size_;
	delete [] arr;
	arr = new T [size_];
	assert( arr != 0 );
	for(int i=0; i<idx; i++) arr[i] = list.arr[i];
}


template<class T>
ListOf<T>& ListOf<T>::operator+=(const ListOf<T>& list)
{
   if(!list.empty() ){
      size_+=list.size_;
      T *new_arr = new T [size_];
      assert(new_arr!=0);
      for(int i=0; i<idx; i++) new_arr[i] = arr[i];
      for(int k=0; k<list.idx; k++) {
         new_arr[i] = list.arr[k];
         ++i;
      }
      idx=i;
      delete [] arr;
      arr = new_arr;
   }
   return *this;
}


template<class T>
ListOf<T>& ListOf<T>::Add(const T& item)
{
   if(idx==size_){
      T *new_arr = new T [size_+=10];
      assert(new_arr!=0);
      for(int i=0; i<idx; i++) new_arr[i] = arr[i];
      delete [] arr;
      arr = new_arr;
   }
   arr[idx++] = item;
   return *this;
}



//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//     LIST ITERATOR TEMPLATE
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------

template <class T> class ListOfIter {
   friend class ListOf<T>;
   public:
      ListOfIter() : Tptr(0), /*my_list(0),*/ position(0), ptr(0) { my_list = 0; }

      ListOfIter(const ListOf<T>* list) :
			Tptr(list->arr), my_list(list), position(0) {
				ptr=&position;
				if(list->size_==0) ptr=0;
			}

      void rewind() {
         assert(Tptr!=0);
         ptr=&position;
         position=0;
      }

      void goEnd() {
         assert(Tptr!=0);
         ptr = &position;
         position = my_list->idx;
      }

		int isLast() const { return position == my_list->idx-1; }
      int offEnd() const {
         if(position<0 || position>=my_list->idx) return 1;
         return 0;
      }
      T Current() const { return Tptr[position]; }
      T operator()() const { return Tptr[position]; }
      T peek() const { if(!isLast()) return Tptr[position+1]; return T(); }
      operator void* () { return ptr; }
      void next() { operator++(); }
      void prev() { operator--(); }
      virtual void operator++() { position++; if(offEnd()) ptr=0;}
      virtual void operator--() { position--; if(offEnd()) ptr=0;}
      ~ListOfIter() { my_list = 0; Tptr = 0; ptr = 0; }
   private:
      const ListOf<T> *my_list;
      const T *Tptr;
      int *ptr;
   protected:
      int position;
};

#endif // TEMPLATE_LIST_H
