

/*************************************************************************
**************************************************************************

   Listing 7
   Copyright David Perelman-Hall 1994.
   Template classes for instatiating lists, arrays, maps, and sets.
   The SetOf template derives from the ArrayOf template, which
   probably isn't the best method of defining a set template.

**************************************************************************
*************************************************************************/



#ifndef TEMPLATE_ARRAY_H
#define TEMPLATE_ARRAY_H

#include <assert.h>
#include <iostream.h>


template<class T> class ArrayOf {
   public:
      ArrayOf() : arr(0), length(0) {}
      ArrayOf(const ArrayOf<T>& array) : length(0), arr(0) { *this=array; }
      ArrayOf(int length) : length(0), arr(0) { resize(length); }
      virtual ~ArrayOf() { clear(); }
      void operator=(const ArrayOf<T>& array);
      virtual void clear() {
         delete [] arr;
         arr=0;
         length=0;
      }
      void insert(const T& item, const int pos) {
         assert(pos>=0);
         assert(pos<=length);
         if(pos==length) resize(length+10);
         arr[pos]=item;
      }
      void resize(const int new_length);
      T& operator[](const int index) { assert(index>=0 && index<length); return arr[index]; }
      const T& operator[](const int index) const { assert(index>=0 && index<length); return arr[index]; }
      T& elem(const int index) const { assert(index>=0 && index<length); return arr[index]; }
      int size() const { return length; }
      friend ostream& operator << (ostream& os, const ArrayOf<T>& array);
      friend istream& operator >> (istream& is, ArrayOf<T>& array);
   protected:
      int contains(const T&) const;
      T* arr;
      int length;
};

template <class T>
int ArrayOf<T>::contains(const T& item) const {
   for(int i=0; i<length; i++) if(arr[i] == item) return 1;
   return 0;
}

template<class T>
ostream& operator<<(ostream& os, const ArrayOf<T>& array)
{
   for(int i=0; i<array.size(); i++) os << array[i] << ' ';
   return os;
}

template<class T>
void ArrayOf<T>::operator=(const ArrayOf<T>& array)
{
   if(this!=&array) {
      delete [] arr;
		arr = 0;
      length=array.length;
      if( length > 0 ) {
         arr = new T [length];
         assert(arr != 0);
         for(int i=0; i<length; i++) arr[i]=array.arr[i];
      }
   }
}

template<class T>
void ArrayOf<T>::resize(const int new_length)
{
   if(new_length==0) clear();
   else if(new_length!=length) {
      int min=length<new_length?length:new_length;
      length=new_length;
      T *new_arr = new T[length];
      assert(new_arr!=0);
      for(int i=0; i<min; i++) new_arr[i]=arr[i];
      delete [] arr;
      arr=new_arr;
   }
}


#endif // TEMPLATE_ARRAY_H
